/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.table.TableModel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.openconcerto.openoffice.LengthUnit;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.Axis;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.Column;
import org.openconcerto.openoffice.spreadsheet.ColumnStyle;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Range;
import org.openconcerto.openoffice.spreadsheet.RepeatedBreaker;
import org.openconcerto.openoffice.spreadsheet.Row;
import org.openconcerto.openoffice.spreadsheet.RowStyle;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SheetTableModel;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.openoffice.spreadsheet.TableCalcNode;
import org.openconcerto.openoffice.spreadsheet.TableGroup;
import org.openconcerto.openoffice.spreadsheet.TableStyle;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.xml.JDOMUtils;
import org.openconcerto.xml.SimpleXMLPath;

public class Table<D extends ODDocument>
extends TableCalcNode<TableStyle, D> {
    private final ArrayList<Row<D>> rows = new ArrayList(64);
    private TableGroup rowGroup;
    private final ArrayList<Column<D>> cols = new ArrayList(32);
    private TableGroup columnGroup;

    static Element createEmpty(XMLVersion ns) {
        Element col = Column.createEmpty(ns, null);
        Element row = Row.createEmpty(ns).addContent(Cell.createEmpty(ns));
        return new Element("table", ns.getTABLE()).addContent(col).addContent(row);
    }

    static final String getName(Element elem) {
        return elem.getAttributeValue("name", elem.getNamespace("table"));
    }

    public Table(D parent, Element local) {
        super(parent, local, TableStyle.class);
        this.readColumns();
        this.readRows();
    }

    private void readColumns() {
        this.read(Axis.COLUMN);
    }

    private final void readRows() {
        this.read(Axis.ROW);
    }

    private final void read(Axis axis) {
        boolean col = axis == Axis.COLUMN;
        Tuple2<TableGroup, List<Element>> r = TableGroup.createRoot(this, axis);
        ArrayList<TableCalcNode> l = col ? this.cols : this.rows;
        int oldSize = l.size();
        l.clear();
        int newSize = r.get0().getSize();
        l.ensureCapacity(newSize);
        if (col) {
            StyleStyleDesc<ColumnStyle> colStyleDesc = this.getColumnStyleDesc();
            for (Element clone : r.get1()) {
                this.addCol(clone, colStyleDesc);
            }
            this.columnGroup = r.get0();
        } else {
            StyleStyleDesc<RowStyle> rowStyleDesc = this.getRowStyleDesc();
            StyleStyleDesc<CellStyle> cellStyleDesc = this.getCellStyleDesc();
            for (Element clone : r.get1()) {
                this.addRow(clone, rowStyleDesc, cellStyleDesc);
            }
            this.rowGroup = r.get0();
        }
        if (oldSize - newSize > 8192) {
            l.trimToSize();
        }
        assert (newSize == (col ? this.getColumnCount() : this.getRowCount()));
    }

    private final void addCol(Element clone, StyleStyleDesc<ColumnStyle> colStyleDesc) {
        this.cols.add(new Column(this, clone, colStyleDesc));
    }

    static final int flattenChildren(List<Element> res, Element elem, Axis axis) {
        int count = 0;
        int[] index = new int[1];
        ArrayList children = new ArrayList(elem.getChildren(axis.getElemName(), elem.getNamespace()));
        int stop = children.size();
        int i = 0;
        while (i < stop) {
            Element row = (Element)children.get(i);
            count += Table.flatten1(res, row, axis, index);
            ++i;
        }
        return count;
    }

    static int flatten1(List<Element> res, Element row, Axis axis) {
        return Table.flatten1(res, row, axis, null);
    }

    private static int flatten1(List<Element> res, Element row, Axis axis, int[] parentIndex) {
        int repeated;
        int resSize = res.size();
        Attribute repeatedAttr = axis.getRepeatedAttr(row);
        int n = repeated = repeatedAttr == null ? 1 : Integer.parseInt(repeatedAttr.getValue());
        if (axis == Axis.COLUMN && repeated > 1) {
            row.removeAttribute(repeatedAttr);
            Element parent = row.getParentElement();
            int index = (parentIndex == null ? parent.indexOf(row) : parentIndex[0]) + 1;
            res.add(row);
            int i = 0;
            while (i < repeated - 1) {
                Element clone = (Element)row.clone();
                res.add(clone);
                parent.addContent(index + i, clone);
                ++i;
            }
        } else {
            res.add(row);
        }
        if (parentIndex != null) {
            parentIndex[0] = parentIndex[0] + (res.size() - resSize);
        }
        return repeated;
    }

    public final String getName() {
        return Table.getName(this.getElement());
    }

    public final void setName(String name) {
        this.getElement().setAttribute("name", name, ((ODDocument)this.getODDocument()).getVersion().getTABLE());
    }

    public void detach() {
        this.getElement().detach();
    }

    public final Object getPrintRanges() {
        return this.getElement().getAttributeValue("print-ranges", this.getTABLE());
    }

    public final void setPrintRanges(String s) {
        this.getElement().setAttribute("print-ranges", s, this.getTABLE());
    }

    public final void removePrintRanges() {
        this.getElement().removeAttribute("print-ranges", this.getTABLE());
    }

    public final synchronized void duplicateFirstRows(int nbFirstRows, int nbDuplicate) {
        this.duplicateRows(0, nbFirstRows, nbDuplicate);
    }

    public final synchronized void insertDuplicatedRows(int rowDuplicated, int nbDuplicate) {
        this.duplicateRows(rowDuplicated, 1, nbDuplicate);
    }

    public final synchronized void duplicateRows(int start, int count, int copies) {
        this.duplicateRows(start, count, copies, true);
    }

    public final synchronized void duplicateRows(int start, int count, int copies, boolean updateCellAddresses) {
        int stop = start + count;
        HashMap<Point, Integer> coverOrigins = new HashMap<Point, Integer>();
        ArrayList<Point> coverOriginsToUpdate = new ArrayList<Point>();
        int colCount = this.getColumnCount();
        int x = 0;
        while (x < colCount) {
            int y = start;
            while (y < stop) {
                int lastCoveredCellRow;
                Point coverOrigin = this.getCoverOrigin(x, y);
                if (coverOrigin == null) {
                    ++y;
                    continue;
                }
                if (coverOrigins.containsKey(coverOrigin)) {
                    lastCoveredCellRow = (Integer)coverOrigins.get(coverOrigin);
                } else {
                    Cell<D> covering = this.getImmutableCellAt(coverOrigin.x, coverOrigin.y);
                    lastCoveredCellRow = coverOrigin.y + covering.getRowsSpanned() - 1;
                    if (coverOrigin.y < start) {
                        if (lastCoveredCellRow < stop - 1) {
                            throw new IllegalArgumentException("Span starts before the duplicated rows and doesn't extend past the end of duplicated rows at " + Table.getAddress(coverOrigin));
                        }
                    } else if (lastCoveredCellRow > stop - 1) {
                        throw new IllegalArgumentException("Span starts in the duplicated rows and extend past the end of duplicated rows at " + Table.getAddress(coverOrigin));
                    }
                    coverOrigins.put(coverOrigin, lastCoveredCellRow);
                    if (coverOrigin.y < start || lastCoveredCellRow > stop - 1) {
                        coverOriginsToUpdate.add(coverOrigin);
                    }
                }
                y = lastCoveredCellRow + 1;
            }
            ++x;
        }
        ArrayList<Element> clones = new ArrayList<Element>(count * copies);
        int l = start;
        while (l < stop) {
            Row<D> toClone;
            Row<D> immutableRow = this.getRow(l);
            if (immutableRow.getY() < l) {
                toClone = this.getMutableRow(l);
            } else {
                assert (immutableRow.getY() == l);
                if (immutableRow.getLastY() >= stop) {
                    assert (this.getRow(stop) == immutableRow);
                    this.getMutableRow(stop);
                    toClone = this.getRow(l);
                } else {
                    toClone = immutableRow;
                }
            }
            assert (toClone.getY() == l);
            assert (toClone.getLastY() < stop) : "Row goes to far";
            l += toClone.getRepeated();
            clones.add((Element)toClone.getElement().clone());
        }
        int clonesSize = clones.size();
        int i = 1;
        while (i < copies) {
            int j = 0;
            while (j < clonesSize) {
                clones.add((Element)((Element)clones.get(j)).clone());
                ++j;
            }
            ++i;
        }
        assert (this.getRow(stop - 1).getLastY() == stop - 1) : "Adding XML element too far";
        JDOMUtils.insertAfter(this.getRow(stop - 1).getElement(), clones);
        for (Point coverOrigin : coverOriginsToUpdate) {
            MutableCell<D> coveringCell = this.getCellAt(coverOrigin);
            coveringCell.setRowsSpanned(coveringCell.getRowsSpanned() + count * copies);
        }
        this.readRows();
        if (updateCellAddresses && this.getODDocument() instanceof SpreadSheet) {
            SpreadSheet ssheet = (SpreadSheet)this.getODDocument();
            SimpleXMLPath<Attribute> descAttrs = SimpleXMLPath.allAttributes("end-cell-address", "table");
            for (Attribute endCellAttr : descAttrs.selectNodes(this.getElement())) {
                int newEndY;
                Tuple2<Sheet, Point> resolved = ssheet.resolve(endCellAttr.getValue());
                Sheet endCellSheet = resolved.get0();
                if (endCellSheet != this) {
                    throw new UnsupportedOperationException("End sheet is not this : " + endCellSheet);
                }
                Point endCellPoint = resolved.get1();
                if (endCellPoint.y < start) continue;
                Element endCellParentElem = endCellAttr.getParent();
                Element rowElem = JDOMUtils.getAncestor(endCellParentElem, "table-row", this.getTABLE());
                if (rowElem == null) {
                    throw new IllegalStateException("Not in a row : " + JDOMUtils.output(endCellParentElem));
                }
                int startRowIndex = -1;
                int rowCount = this.getRowCount();
                int i2 = 0;
                while (i2 < rowCount) {
                    if (this.getRow(i2).getElement() == rowElem) {
                        startRowIndex = i2;
                        break;
                    }
                    ++i2;
                }
                if (startRowIndex < 0) {
                    throw new IllegalStateException("Row not found for " + JDOMUtils.output(endCellParentElem));
                }
                if (startRowIndex >= start + (copies + 1) * count) {
                    newEndY = endCellPoint.y + copies * count;
                } else if (startRowIndex >= start + count && endCellPoint.y < start + count) {
                    int nth = (startRowIndex - start) / count;
                    newEndY = endCellPoint.y + nth * count;
                } else {
                    LengthUnit unit = LengthUnit.MM;
                    BigDecimal[] coordinates = ((ODDocument)this.getODDocument()).getFormatVersion().getXML().getCoordinates(endCellParentElem, unit, false, true);
                    if (coordinates == null) {
                        throw new IllegalStateException("Couldn't find the height of the shape : " + JDOMUtils.output(endCellParentElem));
                    }
                    BigDecimal endYFromAnchor = coordinates[3];
                    assert (endYFromAnchor != null) : "getCoordinates() should never return null BigDecimal (unless requested by horizontal/vertical)";
                    int rowIndex = startRowIndex;
                    BigDecimal cellEndYFromAnchor = ((RowStyle)this.getRow(rowIndex).getStyle()).getTableRowProperties().getHeight(unit);
                    while (endYFromAnchor.compareTo(cellEndYFromAnchor) > 0) {
                        cellEndYFromAnchor = cellEndYFromAnchor.add(((RowStyle)this.getRow(++rowIndex).getStyle()).getTableRowProperties().getHeight(unit));
                    }
                    BigDecimal cellStartYFromAnchor = cellEndYFromAnchor.subtract(((RowStyle)this.getRow(rowIndex).getStyle()).getTableRowProperties().getHeight(unit));
                    BigDecimal endY = endYFromAnchor.subtract(cellStartYFromAnchor);
                    assert (endY.signum() >= 0);
                    newEndY = rowIndex;
                    endCellParentElem.setAttribute("end-y", unit.format(endY), this.getTABLE());
                }
                endCellAttr.setValue(String.valueOf(SpreadSheet.formatSheetName(endCellSheet.getName())) + "." + Table.getAddress(new Point(endCellPoint.x, newEndY)));
            }
        }
    }

    private synchronized void addRow(Element child, StyleDesc<RowStyle> styleDesc, StyleDesc<CellStyle> cellStyleDesc) {
        Row row = new Row(this, child, this.rows.size(), styleDesc, cellStyleDesc);
        int toRepeat = row.getRepeated();
        int i = 0;
        while (i < toRepeat) {
            this.rows.add(row);
            ++i;
        }
    }

    public final Point resolveHint(String ref) {
        Point res = Table.resolve(ref);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException(String.valueOf(ref) + " is not a cell ref, if it's a named range, you must use it on a SpreadSheet.");
    }

    public final boolean isCellValid(int x, int y) {
        if (x > this.getColumnCount()) {
            return false;
        }
        if (y > this.getRowCount()) {
            return false;
        }
        return this.getImmutableCellAt(x, y).isValid();
    }

    public final MutableCell<D> getCellAt(int x, int y) {
        return this.getMutableRow(y).getMutableCellAt(x);
    }

    public final MutableCell<D> getCellAt(String ref) {
        return this.getCellAt(this.resolveHint(ref));
    }

    final MutableCell<D> getCellAt(Point p) {
        return this.getCellAt(p.x, p.y);
    }

    public final void setValueAt(Object val, int x, int y) {
        if (val == null) {
            val = "";
        }
        if (!val.equals(this.getValueAt(x, y))) {
            this.getCellAt(x, y).setValue(val);
        }
    }

    public final Cell<D> getImmutableCellAt(int x, int y) {
        return this.getRow(y).getCellAt(x);
    }

    public final Cell<D> getImmutableCellAt(String ref) {
        Point p = this.resolveHint(ref);
        return this.getImmutableCellAt(p.x, p.y);
    }

    public final Point getCoverOrigin(int x, int y) {
        Cell<D> c = this.getImmutableCellAt(x, y);
        if (c.coversOtherCells()) {
            return new Point(x, y);
        }
        if (!c.isCovered()) {
            return null;
        }
        Row<D> row = this.getRow(y);
        Cell<D> currentCell = c;
        int currentX = x;
        while (currentX > 0 && currentCell.isCovered()) {
            currentCell = row.getCellAt(--currentX);
        }
        if (currentCell.coversOtherCells()) {
            return new Point(currentX, y);
        }
        if (!currentCell.isCovered()) {
            currentCell = row.getCellAt(++currentX);
        }
        assert (currentCell.isCovered());
        int currentY = y;
        while (!currentCell.coversOtherCells()) {
            currentCell = this.getImmutableCellAt(currentX, --currentY);
        }
        return new Point(currentX, currentY);
    }

    public final Object getValueAt(int column, int row) {
        return this.getImmutableCellAt(column, row).getValue();
    }

    public final String getStyleNameAt(int column, int row) {
        String cellStyle = this.getImmutableCellAt(column, row).getStyleAttr();
        if (cellStyle != null) {
            return cellStyle;
        }
        cellStyle = this.getRow(row).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
        if (cellStyle != null) {
            return cellStyle;
        }
        return this.getColumn(column).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
    }

    public final CellStyle getStyleAt(int column, int row) {
        return (CellStyle)this.getCellStyleDesc().findStyleForNode(this.getImmutableCellAt(column, row), this.getStyleNameAt(column, row));
    }

    protected StyleStyleDesc<CellStyle> getCellStyleDesc() {
        return Style.getStyleStyleDesc(CellStyle.class, ((ODDocument)this.getODDocument()).getVersion());
    }

    public final CellStyle getDefaultCellStyle() {
        return this.getCellStyleDesc().findDefaultStyle(((ODDocument)this.getODDocument()).getPackage());
    }

    public final List<Tuple2<Integer, Integer>> getStyleReferences(String cellStyleName) {
        ArrayList<Tuple2<Integer, Integer>> res = new ArrayList<Tuple2<Integer, Integer>>();
        HashSet<Integer> cols = new HashSet<Integer>();
        int columnCount = this.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            if (cellStyleName.equals(this.getColumn(i).getElement().getAttributeValue("default-cell-style-name", this.getTABLE()))) {
                cols.add(i);
            }
            ++i;
        }
        int rowCount = this.getRowCount();
        int y = 0;
        while (y < rowCount) {
            Row<D> row = this.getRow(y);
            String rowStyle = row.getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
            int x = 0;
            while (x < columnCount) {
                String cellStyle = row.getCellAt(x).getStyleAttr();
                boolean match = cellStyle != null ? cellStyleName.equals(cellStyle) : (rowStyle != null ? cellStyleName.equals(rowStyle) : cols.contains(x));
                if (match) {
                    res.add(Tuple2.create(x, y));
                }
                ++x;
            }
            ++y;
        }
        return res;
    }

    protected final StyleStyleDesc<ColumnStyle> getColumnStyleDesc() {
        return Style.getStyleStyleDesc(ColumnStyle.class, XMLVersion.getVersion(this.getElement()));
    }

    protected final StyleStyleDesc<RowStyle> getRowStyleDesc() {
        return Style.getStyleStyleDesc(RowStyle.class, XMLVersion.getVersion(this.getElement()));
    }

    public final Object getValueAt(String ref) {
        return this.getImmutableCellAt(ref).getValue();
    }

    final Row<D> getRow(int index) {
        return this.rows.get(index);
    }

    final Row<D> getMutableRow(int y) {
        Row<D> c = this.getRow(y);
        if (c.getRepeated() > 1) {
            RepeatedBreaker.getRowBreaker().breakRepeated(this, this.rows, y);
            return this.getRow(y);
        }
        return c;
    }

    public final Column<D> getColumn(int i) {
        return this.cols.get(i);
    }

    public final int getRowCount() {
        return this.rows.size();
    }

    public final TableGroup getRowGroup() {
        return this.rowGroup;
    }

    public final TableGroup getRowGroupAt(int y) {
        return this.getRowGroup().getDescendentOrSelfContaining(y);
    }

    public final int getHeaderRowCount() {
        return this.getRowGroup().getFollowingHeaderCount();
    }

    public final int getColumnCount() {
        return this.cols.size();
    }

    public final TableGroup getColumnGroup() {
        return this.columnGroup;
    }

    public final TableGroup getColumnGroupAt(int x) {
        return this.getColumnGroup().getDescendentOrSelfContaining(x);
    }

    public final int getHeaderColumnCount() {
        return this.getColumnGroup().getFollowingHeaderCount();
    }

    public final void setColumnCount(int newSize) {
        this.setColumnCount(newSize, -1, false);
    }

    public final void ensureColumnCount(int newSize) {
        if (newSize > this.getColumnCount()) {
            this.setColumnCount(newSize);
        }
    }

    public final void setColumnCount(int newSize, int colIndex, boolean keepTableWidth) {
        int toGrow = newSize - this.getColumnCount();
        if (toGrow < 0) {
            this.removeColumn(newSize, this.getColumnCount(), keepTableWidth);
        } else if (toGrow > 0) {
            int indexOfLastCol = this.getColumnCount() == 0 ? this.getElement().getContentSize() - 1 : this.getElement().getContent().indexOf(this.getColumn(this.getColumnCount() - 1).getElement());
            Element elemToClone = colIndex < 0 ? Column.createEmpty(((ODDocument)this.getODDocument()).getVersion(), this.createDefaultColStyle()) : this.getColumn(colIndex).getElement();
            StyleStyleDesc<ColumnStyle> columnStyleDesc = this.getColumnStyleDesc();
            int i = 0;
            while (i < toGrow) {
                Element newElem = (Element)elemToClone.clone();
                this.getElement().addContent(indexOfLastCol + 1 + i, newElem);
                this.cols.add(new Column(this, newElem, columnStyleDesc));
                ++i;
            }
            this.updateWidth(keepTableWidth);
            StyleStyleDesc<CellStyle> cellStyleDesc = this.getCellStyleDesc();
            int rowCount = this.getRowCount();
            int i2 = 0;
            while (i2 < rowCount) {
                Row<D> r = this.getRow(i2);
                r.columnCountChanged(cellStyleDesc);
                i2 += r.getRepeated();
            }
        }
    }

    public final void removeColumn(int colIndex, boolean keepTableWidth) {
        this.removeColumn(colIndex, colIndex + 1, keepTableWidth);
    }

    public final void removeColumn(int firstIndex, int lastIndex, boolean keepTableWidth) {
        Row<D> r;
        int rowCount = this.getRowCount();
        int i = 0;
        while (i < rowCount) {
            r = this.getRow(i);
            r.checkRemove(firstIndex, lastIndex);
            i += r.getRepeated();
        }
        this.remove(Axis.COLUMN, firstIndex, lastIndex - 1);
        this.updateWidth(keepTableWidth);
        i = 0;
        while (i < rowCount) {
            r = this.getRow(i);
            r.removeCells(firstIndex, lastIndex);
            i += r.getRepeated();
        }
    }

    private void updateWidth(boolean keepTableWidth) {
        Float currentWidth = this.getWidth();
        float newWidth = 0.0f;
        Column<D> nullWidthCol = null;
        for (Column<D> col : this.cols) {
            Float colWidth = col.getWidth();
            if (colWidth != null) {
                assert (colWidth.floatValue() >= 0.0f);
                newWidth += colWidth.floatValue();
                continue;
            }
            newWidth = -1.0f;
            nullWidthCol = col;
            break;
        }
        if (keepTableWidth && currentWidth != null) {
            if (nullWidthCol != null) {
                throw new IllegalStateException("Cannot keep width since a column has no width : " + nullWidthCol);
            }
            float ratio = currentWidth.floatValue() / newWidth;
            HashSet<ColumnStyle> colStyles = new HashSet<ColumnStyle>();
            for (Column<D> col : this.cols) {
                colStyles.add((ColumnStyle)col.getStyle());
            }
            for (ColumnStyle colStyle : colStyles) {
                colStyle.setWidth(colStyle.getWidth().floatValue() * ratio);
            }
        } else {
            TableStyle style = (TableStyle)this.getStyle();
            if (style != null) {
                if (nullWidthCol != null) {
                    throw new IllegalStateException("Cannot update table width since a column has no width : " + nullWidthCol);
                }
                style.setWidth(newWidth);
            }
            for (Column<D> col : this.cols) {
                ColumnStyle colStyle = (ColumnStyle)col.getStyle();
                if (colStyle == null) continue;
                colStyle.rmRelWidth();
            }
        }
    }

    public final Float getWidth() {
        TableStyle style = (TableStyle)this.getStyle();
        return style == null ? null : style.getWidth();
    }

    private final ColumnStyle createDefaultColStyle() {
        ColumnStyle colStyle = (ColumnStyle)ColumnStyle.DESC.createAutoStyle(((ODDocument)this.getODDocument()).getPackage(), "defaultCol");
        colStyle.setWidth(20.0f);
        return colStyle;
    }

    private final void setCount(Axis col, int newSize) {
        this.remove(col, newSize, -1);
    }

    private final void remove(Axis col, int fromIndex, int toIndexIncl) {
        assert (col == Axis.COLUMN || toIndexIncl < 0) : "Row index will be wrong";
        ArrayList<TableCalcNode> l = col == Axis.COLUMN ? this.cols : this.rows;
        int toIndexValid = CollectionUtils.getValidIndex(l, toIndexIncl);
        int toRemoveCount = toIndexValid - fromIndex + 1;
        int removedCount = 0;
        while (removedCount < toRemoveCount) {
            int i = toIndexValid - removedCount;
            TableCalcNode removed = (TableCalcNode)l.get(i);
            if (removed instanceof Row) {
                Row r = (Row)removed;
                int removeFromRepeated = i - Math.max(fromIndex, r.getY()) + 1;
                assert (removeFromRepeated > 0);
                int newRepeated = r.getRepeated() - removeFromRepeated;
                if (newRepeated == 0) {
                    removed.getElement().detach();
                } else {
                    r.setRepeated(newRepeated);
                }
                removedCount += removeFromRepeated;
                continue;
            }
            removed.getElement().detach();
            ++removedCount;
        }
        l.subList(fromIndex, toIndexValid + 1).clear();
    }

    public final void ensureRowCount(int newSize) {
        if (newSize > this.getRowCount()) {
            this.setRowCount(newSize);
        }
    }

    public final void setRowCount(int newSize) {
        this.setRowCount(newSize, -1);
    }

    public final void setRowCount(int newSize, int rowIndex) {
        int toGrow = newSize - this.getRowCount();
        if (toGrow < 0) {
            this.setCount(Axis.ROW, newSize);
        } else if (toGrow > 0) {
            Element elemToClone;
            if (rowIndex < 0) {
                elemToClone = Row.createEmpty(((ODDocument)this.getODDocument()).getVersion());
                elemToClone.addContent(Cell.createEmpty(((ODDocument)this.getODDocument()).getVersion(), this.getColumnCount()));
            } else {
                elemToClone = (Element)this.getRow(rowIndex).getElement().clone();
            }
            Axis.ROW.setRepeated(elemToClone, toGrow);
            this.getElement().addContent(elemToClone);
            this.addRow(elemToClone, this.getRowStyleDesc(), this.getCellStyleDesc());
        }
    }

    public final SheetTableModel<D> getTableModel(int column, int row) {
        return new SheetTableModel(this, row, column);
    }

    public final SheetTableModel<D> getTableModel(int column, int row, int lastCol, int lastRow) {
        return new SheetTableModel(this, row, column, lastRow, lastCol);
    }

    public final SheetTableModel.MutableTableModel<D> getMutableTableModel(int column, int row) {
        return new SheetTableModel.MutableTableModel(this, row, column);
    }

    public final SheetTableModel.MutableTableModel<D> getMutableTableModel(Point start, Point end2) {
        return new SheetTableModel.MutableTableModel(this, start.y, start.x, end2.y + 1, end2.x + 1);
    }

    public final void merge(TableModel t, int column, int row) {
        this.merge(t, column, row, false);
    }

    public final void merge(TableModel t, int column, int row, boolean includeColNames) {
        int offset = includeColNames ? 1 : 0;
        this.ensureColumnCount(column + t.getColumnCount());
        this.ensureRowCount(row + t.getRowCount() + offset);
        SheetTableModel.MutableTableModel<D> thisModel = this.getMutableTableModel(column, row);
        if (includeColNames) {
            int x = 0;
            while (x < t.getColumnCount()) {
                thisModel.setValueAt(t.getColumnName(x), 0, x);
                ++x;
            }
        }
        int y = 0;
        while (y < t.getRowCount()) {
            int x = 0;
            while (x < t.getColumnCount()) {
                Object value = t.getValueAt(y, x);
                thisModel.setValueAt(value, y + offset, x);
                ++x;
            }
            ++y;
        }
    }

    public final Range getUsedRange() {
        return this.getUsedRange(false);
    }

    public final Range getUsedRange(boolean checkStyle) {
        int minX = -1;
        int minY = -1;
        int maxX = -1;
        int maxY = -1;
        int colCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        int x = 0;
        while (x < colCount) {
            int y = 0;
            while (y < rowCount) {
                if (!this.isCellBlank(x, y, checkStyle)) {
                    if (minX < 0 || x < minX) {
                        minX = x;
                    }
                    if (minY < 0 || y < minY) {
                        minY = y;
                    }
                    if (maxX < 0 || x > maxX) {
                        maxX = x;
                    }
                    if (maxY < 0 || y > maxY) {
                        maxY = y;
                    }
                }
                ++y;
            }
            ++x;
        }
        return minX < 0 ? null : new Range(this.getName(), new Point(minX, minY), new Point(maxX, maxY));
    }

    protected final boolean isCellBlank(int x, int y, boolean checkStyle) {
        if (!this.getImmutableCellAt(x, y).isEmpty()) {
            return false;
        }
        if (checkStyle) {
            CellStyle style = this.getStyleAt(x, y);
            return style == null || style.getBackgroundColor() == null && style.getTableCellProperties().getBorders().isEmpty();
        }
        return true;
    }

    public final Range getCurrentRegion(String ref) {
        return this.getCurrentRegion(ref, false);
    }

    public final Range getCurrentRegion(String ref, boolean checkStyle) {
        Point p = this.resolveHint(ref);
        return this.getCurrentRegion(p.x, p.y, checkStyle);
    }

    public final Range getCurrentRegion(int startX, int startY) {
        return this.getCurrentRegion(startX, startY, false);
    }

    public final Range getCurrentRegion(int startX, int startY, boolean checkStyle) {
        return new RegionExplorer(startX, startY, checkStyle).getCurrentRegion();
    }

    static final Point resolve(String ref) {
        Matcher matcher = SpreadSheet.minCellPattern.matcher(ref);
        if (!matcher.matches()) {
            return null;
        }
        return Table.resolve(matcher.group(1), matcher.group(2));
    }

    static final Point resolve(String letters, String digits) {
        return new Point(Table.toInt(letters), Integer.parseInt(digits) - 1);
    }

    static final int toInt(String col) {
        if (col.length() < 1) {
            throw new IllegalArgumentException("x cannot be empty");
        }
        col = col.toUpperCase();
        int x = 0;
        int i = 0;
        while (i < col.length()) {
            x = x * 26 + (col.charAt(i) - 65 + 1);
            ++i;
        }
        return x - 1;
    }

    public static final String toStr(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("negative column : " + col);
        }
        ++col;
        int radix = 26;
        StringBuilder chars = new StringBuilder(4);
        while (col > 0) {
            chars.append((char)(65 + (col - 1) % 26));
            col = (col - 1) / 26;
        }
        return chars.reverse().toString();
    }

    static final String getAddress(Point p) {
        if (p.x < 0 || p.y < 0) {
            throw new IllegalArgumentException("negative coordinates : " + p);
        }
        return String.valueOf(Table.toStr(p.x)) + (p.y + 1);
    }

    private class RegionExplorer {
        private final boolean checkStyle;
        private final int rowCount;
        private final int colCount;
        protected int minX;
        protected int minY;
        protected int maxX;
        protected int maxY;

        public RegionExplorer(int startX, int startY, boolean checkStyle) {
            this.rowCount = Table.this.getRowCount();
            this.colCount = Table.this.getColumnCount();
            this.minX = this.maxX = startX;
            this.minY = this.maxY = startY;
            this.checkStyle = checkStyle;
        }

        public boolean canXDecrement() {
            return this.minX > 0;
        }

        public boolean canYDecrement() {
            return this.minY > 0;
        }

        public boolean canXIncrement() {
            return this.maxX < this.colCount - 1;
        }

        public boolean canYIncrement() {
            return this.maxY < this.rowCount - 1;
        }

        private boolean checkRow(boolean upper) {
            if (upper && this.canYDecrement() || !upper && this.canYIncrement()) {
                int y = upper ? this.minY - 1 : this.maxY + 1;
                int start = this.canXDecrement() ? this.minX - 1 : this.minX;
                int stop = this.canXIncrement() ? this.maxX + 1 : this.maxX;
                int x = start;
                while (x <= stop) {
                    if (!Table.this.isCellBlank(x, y, this.checkStyle)) {
                        if (upper) {
                            this.minY = y;
                        } else {
                            this.maxY = y;
                        }
                        if (x < this.minX) {
                            this.minX = x;
                        }
                        if (x > this.maxX) {
                            this.maxX = x;
                        }
                        return true;
                    }
                    ++x;
                }
            }
            return false;
        }

        private boolean checkCol(boolean left) {
            if (left && this.canXDecrement() || !left && this.canXIncrement()) {
                int x = left ? this.minX - 1 : this.maxX + 1;
                int y = this.minY;
                while (y <= this.maxY) {
                    if (!Table.this.isCellBlank(x, y, this.checkStyle)) {
                        if (left) {
                            this.minX = x;
                        } else {
                            this.maxX = x;
                        }
                        return true;
                    }
                    ++y;
                }
            }
            return false;
        }

        private final boolean checkFrame() {
            return this.checkRow(true) || this.checkRow(false) || this.checkCol(true) || this.checkCol(false);
        }

        public final Range getCurrentRegion() {
            while (this.checkFrame()) {
            }
            return new Range(Table.this.getName(), new Point(this.minX, this.minY), new Point(this.maxX, this.maxY));
        }
    }
}

