/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.ContentTypeVersioned;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.Range;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SheetTableModel;
import org.openconcerto.openoffice.spreadsheet.Table;
import org.openconcerto.utils.Tuple2;

public class SpreadSheet
extends ODDocument {
    private final Map<Element, Sheet> sheets = new HashMap<Element, Sheet>();
    private static final String minCell = "\\$?([A-Z]+)\\$?([0-9]+)";
    static final Pattern cellPattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?([A-Z]+)\\$?([0-9]+))");
    static final Pattern minCellPattern = Pattern.compile("\\$?([A-Z]+)\\$?([0-9]+)");
    static final Pattern cellRangePattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+)(:(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+))?");
    static final Pattern tableNameQuoteQuotePattern = Pattern.compile("''", 16);
    static final Pattern tableNameQuotePattern = Pattern.compile("'", 16);
    static final Pattern tableNameQuoteNeededPattern = Pattern.compile("[ \t.']");

    public static SpreadSheet createFromFile(File f) throws IOException {
        return new ODPackage(f).getSpreadSheet();
    }

    public static SpreadSheet get(ODPackage fd) {
        return fd.hasODDocument() ? fd.getSpreadSheet() : new SpreadSheet(fd);
    }

    public static SpreadSheet createEmpty(TableModel t) throws IOException {
        return SpreadSheet.createEmpty(t, XMLFormatVersion.getDefault());
    }

    public static SpreadSheet createEmpty(TableModel t, XMLFormatVersion ns) throws IOException {
        ContentTypeVersioned ct = ContentType.SPREADSHEET.getVersioned(ns.getXMLVersion());
        SpreadSheet spreadSheet = ct.createPackage(ns).getSpreadSheet();
        spreadSheet.getBody().addContent(Sheet.createEmpty(ns.getXMLVersion()));
        spreadSheet.getSheet(0).merge(t, 0, 0, true);
        return spreadSheet;
    }

    public static File export(TableModel t, File f, XMLFormatVersion ns) throws IOException {
        return SpreadSheet.createEmpty(t, ns).saveAs(f);
    }

    private SpreadSheet(ODPackage orig) {
        super(orig);
    }

    protected static final String parseSheetName(String n) {
        String res;
        if (n == null) {
            return null;
        }
        String string = res = n.charAt(0) == '$' ? n.substring(1) : n;
        if (res.charAt(0) == '\'') {
            if (res.charAt(res.length() - 1) != '\'') {
                throw new IllegalArgumentException("Missing closing quote");
            }
            res = tableNameQuoteQuotePattern.matcher(res.substring(1, res.length() - 1)).replaceAll(tableNameQuotePattern.pattern());
        }
        return res;
    }

    protected static final String formatSheetName(String n) {
        if (n == null) {
            return null;
        }
        if (tableNameQuoteNeededPattern.matcher(n).find()) {
            return "'" + tableNameQuotePattern.matcher(n).replaceAll(tableNameQuoteQuotePattern.pattern()) + "'";
        }
        return n;
    }

    public final SheetTableModel.MutableTableModel<SpreadSheet> getTableModel(String name) {
        Element range;
        try {
            XPath path = this.getXPath("./table:named-expressions/table:named-range[@table:name='" + name + "']");
            range = (Element)path.selectSingleNode(this.getBody());
        }
        catch (JDOMException e) {
            throw new IllegalStateException(e);
        }
        if (range == null) {
            return null;
        }
        String baseCell = range.getAttributeValue("cell-range-address", this.getVersion().getTABLE());
        Range points = Range.parse(baseCell);
        if (points.spanSheets()) {
            throw new UnsupportedOperationException("different sheet names: " + points.getStartSheet() + " != " + points.getEndSheet());
        }
        Sheet sheet = this.getSheet(points.getStartSheet(), true);
        return sheet.getMutableTableModel(points.getStartPoint(), points.getEndPoint());
    }

    public final Cell<SpreadSheet> getCellAt(String ref) {
        Tuple2<Sheet, Point> res = this.resolve(ref);
        return res.get0().getCellAt(res.get1());
    }

    public final Tuple2<Sheet, Point> resolve(String ref) {
        Matcher m = cellPattern.matcher(ref);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.valueOf(ref) + " is not a valid cell address: " + m.pattern().pattern());
        }
        String sheetName = SpreadSheet.parseSheetName(m.group(1));
        if (sheetName == null) {
            throw new IllegalArgumentException("no sheet specified: " + ref);
        }
        return Tuple2.create(this.getSheet(sheetName, true), Sheet.resolve(m.group(5), m.group(6)));
    }

    public XPath getXPath(String p) throws JDOMException {
        return OOUtils.getXPath(p, this.getVersion());
    }

    private final List<Element> getTables() {
        return this.getBody().getChildren("table", this.getVersion().getTABLE());
    }

    public int getSheetCount() {
        return this.getTables().size();
    }

    public Sheet getSheet(int i) {
        return this.getSheet(this.getTables().get(i));
    }

    public Sheet getSheet(String name) {
        return this.getSheet(name, false);
    }

    public Sheet getSheet(String name, boolean mustExist) throws NoSuchElementException {
        for (Element table : this.getTables()) {
            if (!name.equals(Table.getName(table))) continue;
            return this.getSheet(table);
        }
        if (mustExist) {
            throw new NoSuchElementException("no such sheet: " + name);
        }
        return null;
    }

    private final Sheet getSheet(Element table) {
        Sheet res = this.sheets.get(table);
        if (res == null) {
            res = new Sheet(this, table);
            this.sheets.put(table, res);
        }
        return res;
    }

    void invalidate(Element element) {
        this.sheets.remove(element);
    }

    public final Sheet addSheet(int index, String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        Element newElem = Table.createEmpty(this.getVersion());
        return this.addSheet(index, newElem, name);
    }

    final Sheet addSheet(int index, Element newElem, String name) {
        this.getBody().addContent(this.getContentIndex(index), newElem);
        Sheet res = this.getSheet(newElem);
        if (name != null) {
            res.setName(name);
        }
        assert (res.getName() != null);
        return res;
    }

    private final int getContentIndex(int tableIndex) {
        if (tableIndex < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + tableIndex);
        }
        ArrayList<Element> tables = new ArrayList<Element>(this.getTables());
        if (tableIndex > tables.size()) {
            throw new IndexOutOfBoundsException("index (" + tableIndex + ") > count (" + tables.size() + ")");
        }
        int contentIndex = tableIndex == tables.size() ? this.getBody().indexOf((Content)tables.get(tableIndex - 1)) + 1 : this.getBody().indexOf((Content)tables.get(tableIndex));
        return contentIndex;
    }

    public final Sheet addSheet(String name) {
        return this.addSheet(this.getSheetCount(), name);
    }

    void move(Sheet sheet, int toIndex) {
        Element parentElement = sheet.getElement().getParentElement();
        sheet.getElement().detach();
        parentElement.addContent(this.getContentIndex(toIndex), sheet.getElement());
    }
}

