/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.Axis;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.RepeatedBreaker;
import org.openconcerto.openoffice.spreadsheet.RowStyle;
import org.openconcerto.openoffice.spreadsheet.Table;
import org.openconcerto.openoffice.spreadsheet.TableCalcNode;

public class Row<D extends ODDocument>
extends TableCalcNode<RowStyle, D> {
    private final Table<D> parent;
    private final int index;
    private int repeated;
    private Cell<D>[] cells;
    private int cellCount;

    static Element createEmpty(XMLVersion ns) {
        return new Element("table-row", ns.getTABLE());
    }

    Row(Table<D> parent, Element tableRowElem, int index, StyleDesc<RowStyle> styleDesc, StyleDesc<CellStyle> cellStyleDesc) {
        super(parent.getODDocument(), tableRowElem, styleDesc);
        this.parent = parent;
        this.index = index;
        this.repeated = Axis.ROW.getRepeated(this.getElement());
        Cell[] unsafe = new Cell[parent.getColumnCount()];
        this.cells = unsafe;
        this.cellCount = 0;
        for (Element cellElem : this.getCellElements()) {
            this.addCellElem(cellElem, cellStyleDesc);
        }
    }

    private final void ensureRoom(int additionalItems) {
        int requiredSize = this.getCellCount() + additionalItems;
        if (requiredSize > this.cells.length) {
            this.cells = Arrays.copyOf(this.cells, requiredSize);
        }
    }

    protected final Table<D> getSheet() {
        return this.parent;
    }

    final int getY() {
        return this.index;
    }

    final int getLastY() {
        return this.getY() + this.getRepeated() - 1;
    }

    final int getRepeated() {
        return this.repeated;
    }

    final void setRepeated(int newRepeated) {
        Axis.ROW.setRepeated(this.getElement(), newRepeated);
        this.repeated = newRepeated;
    }

    final int getX(MutableCell<D> c) {
        int stop = this.getCellCount();
        int i = 0;
        while (i < stop) {
            Cell<D> item = this.cells[i];
            if (c.equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addCellElem(Element cellElem, StyleDesc<CellStyle> cellStyleDesc) {
        Cell cell = new Cell(this, cellElem, cellStyleDesc);
        String repeatedS = cellElem.getAttributeValue("number-columns-repeated", this.getTABLE());
        int toRepeat = StyleProperties.parseInt(repeatedS, 1);
        int stop = this.cellCount + toRepeat;
        int i = this.cellCount;
        while (i < stop) {
            this.cells[i] = cell;
            ++i;
        }
        this.cellCount = stop;
    }

    private List<Element> getCellElements() {
        return this.getElement().getChildren();
    }

    protected final int getCellCount() {
        return this.cellCount;
    }

    private final List<Cell<D>> getCellsAsList() {
        return Arrays.asList(this.cells);
    }

    protected final Cell<D> getCellAt(int col) {
        return this.cells[col];
    }

    protected final Cell<D> getValidCellAt(int col) {
        Cell<D> c = this.getCellAt(col);
        if (!c.isValid()) {
            throw new IllegalArgumentException("invalid cell " + c);
        }
        return c;
    }

    public final MutableCell<D> getMutableCellAt(int col) {
        Cell<D> c = this.getValidCellAt(col);
        if (!(c instanceof MutableCell)) {
            RepeatedBreaker.getCellBreaker().breakRepeated(this, this.getCellsAsList(), col);
        }
        return (MutableCell)this.getValidCellAt(col);
    }

    void columnCountChanged(StyleStyleDesc<CellStyle> cellStyleDesc) {
        int diff = this.getSheet().getColumnCount() - this.getCellCount();
        if (diff < 0) {
            throw new IllegalStateException("should have used Table.removeColumn()");
        }
        if (diff > 0) {
            Element e = Cell.createEmpty(((ODDocument)this.getSheet().getODDocument()).getVersion(), diff);
            this.getElement().addContent(e);
            this.ensureRoom(diff);
            this.addCellElem(e, cellStyleDesc);
        }
        assert (this.getCellCount() == this.getSheet().getColumnCount());
    }

    void checkRemove(int firstIndex, int lastIndexExcl) {
        if (lastIndexExcl > this.getCellCount()) {
            throw new IndexOutOfBoundsException(String.valueOf(lastIndexExcl) + " > " + this.getCellCount());
        }
        if (!this.getCellAt(firstIndex).isValid()) {
            throw new IllegalArgumentException("unable to remove covered cell at " + firstIndex);
        }
    }

    void removeCells(int firstIndex, int lastIndexExcl) {
        this.getMutableCellAt(firstIndex).unmerge();
        if (lastIndexExcl < this.getCellCount()) {
            if (!this.getCellAt(lastIndexExcl - 1).isValid()) {
                int currentCol = lastIndexExcl - 2;
                while (!this.getCellAt(currentCol).isValid()) {
                    --currentCol;
                }
                this.getMutableCellAt(currentCol).unmerge();
            }
            this.getMutableCellAt(lastIndexExcl - 1).unmerge();
        }
        int i = firstIndex;
        while (i < lastIndexExcl) {
            this.cells[i].getElement().detach();
            ++i;
        }
        int movedCount = this.getCellCount() - lastIndexExcl;
        System.arraycopy(this.cells, lastIndexExcl, this.cells, firstIndex, movedCount);
        this.cells = Arrays.copyOfRange(this.cells, 0, firstIndex + movedCount);
        this.cellCount = this.cells.length;
        assert (this.getCellCount() == this.getSheet().getColumnCount());
    }
}

