/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.openconcerto.openoffice.Log;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODFrame;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.OOXML;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.spreadsheet.BytesProducer;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.Row;
import org.openconcerto.openoffice.style.data.DataStyle;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.Tuple3;

public class MutableCell<D extends ODDocument>
extends Cell<D> {
    private static final DateFormat TextPDateFormat = DateFormat.getDateInstance();
    private static final DateFormat TextPTimeFormat = DateFormat.getTimeInstance();
    private static final NumberFormat TextPMinuteSecondFormat = new DecimalFormat("00.###");
    private static final NumberFormat TextPFloatFormat = DecimalFormat.getNumberInstance();
    private static final NumberFormat TextPPercentFormat = DecimalFormat.getPercentInstance();
    private static final NumberFormat TextPCurrencyFormat = DecimalFormat.getCurrencyInstance();

    public static String formatNumber(Number n, CellStyle defaultStyle) {
        return MutableCell.formatNumber(TextPFloatFormat, n, defaultStyle, false);
    }

    public static String formatPercent(Number n, CellStyle defaultStyle) {
        return MutableCell.formatNumber(TextPPercentFormat, n, defaultStyle, true);
    }

    public static String formatCurrency(Number n, CellStyle defaultStyle) {
        return MutableCell.formatNumber(TextPCurrencyFormat, n, defaultStyle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatNumber(NumberFormat format, Number n, CellStyle defaultStyle, boolean forceFraction) {
        NumberFormat numberFormat = format;
        synchronized (numberFormat) {
            int decPlaces = DataStyle.getDecimalPlaces(defaultStyle);
            format.setMinimumFractionDigits(forceFraction ? decPlaces : 0);
            format.setMaximumFractionDigits(decPlaces);
            return format.format(n);
        }
    }

    MutableCell(Row<D> parent, Element elem, StyleDesc<CellStyle> styleDesc) {
        super(parent, elem, styleDesc);
    }

    public final int getX() {
        return this.getRow().getX(this);
    }

    public final int getY() {
        return this.getRow().getY();
    }

    public final Point getPoint() {
        return new Point(this.getX(), this.getY());
    }

    final void setRowsSpanned(int rowsSpanned) {
        if (rowsSpanned <= 1) {
            this.getElement().removeAttribute("number-rows-spanned", this.getNS().getTABLE());
        } else {
            this.getElement().setAttribute("number-rows-spanned", String.valueOf(rowsSpanned), this.getNS().getTABLE());
        }
    }

    private void setValueAttributes(ODValueType type, Object val) {
        if (type == null) {
            Attribute valueTypeAttr = this.getElement().getAttribute("value-type", this.getValueNS());
            if (valueTypeAttr != null) {
                valueTypeAttr.detach();
                this.getElement().removeAttribute(ODValueType.get(valueTypeAttr.getValue()).getValueAttribute(), this.getValueNS());
            }
        } else {
            this.getElement().setAttribute("value-type", type.getName(), this.getValueNS());
            this.getElement().setAttribute(type.getValueAttribute(), type.format(val), this.getValueNS());
        }
    }

    private void setTextP(String value) {
        if (value == null) {
            this.getElement().removeContent();
        } else {
            Element child = this.getElement().getChild("p", this.getNS().getTEXT());
            Element t = child != null ? child : new Element("p", this.getNS().getTEXT());
            t.setContent(OOXML.get(((ODDocument)this.getODDocument()).getFormatVersion()).encodeWSasList(value));
            this.getElement().setContent(t);
        }
    }

    private void setValue(ODValueType type, Object value, String textP) {
        this.setValueAttributes(type, value);
        this.setTextP(textP);
    }

    public void clearValue() {
        this.setValue(null, null, null);
    }

    public void setValue(Object obj) {
        this.setValue(obj, true);
    }

    public void setValue(Object obj, boolean allowTypeChange) throws UnsupportedOperationException {
        ODValueType currentType = this.getValueType();
        ODValueType type = currentType != null && currentType.canFormat(obj.getClass()) ? currentType : ODValueType.forObject(obj);
        if (type == null) {
            throw new IllegalArgumentException("Couldn't infer type of " + obj);
        }
        this.setValue(obj, type, allowTypeChange, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object obj, ODValueType vt, boolean allowTypeChange, boolean lenient) throws UnsupportedOperationException {
        String text;
        Tuple3<String, ODValueType, Object> formatted = this.format(obj, vt, !allowTypeChange, lenient);
        vt = (ODValueType)((Object)formatted.get1());
        obj = formatted.get2();
        if (formatted.get0() != null) {
            text = (String)formatted.get0();
        } else if (vt == ODValueType.FLOAT) {
            text = MutableCell.formatNumber((Number)obj, this.getDefaultStyle());
        } else if (vt == ODValueType.PERCENTAGE) {
            text = MutableCell.formatPercent((Number)obj, this.getDefaultStyle());
        } else if (vt == ODValueType.CURRENCY) {
            text = MutableCell.formatCurrency((Number)obj, this.getDefaultStyle());
        } else if (vt == ODValueType.DATE) {
            Date d = obj instanceof Calendar ? ((Calendar)obj).getTime() : (Date)obj;
            text = TextPDateFormat.format(d);
        } else if (vt == ODValueType.TIME) {
            if (obj instanceof Duration) {
                Duration normalized = ((ODDocument)this.getODDocument()).getEpoch().normalizeToHours((Duration)obj);
                text = "" + normalized.getHours() + ':' + TextPMinuteSecondFormat.format(normalized.getMinutes()) + ':' + TextPMinuteSecondFormat.format(normalized.getField(DatatypeConstants.SECONDS));
            } else {
                text = TextPTimeFormat.format(((Calendar)obj).getTime());
            }
        } else if (vt == ODValueType.BOOLEAN) {
            if (!lenient) throw new UnsupportedOperationException((Object)((Object)vt) + " not supported");
            text = obj.toString();
        } else {
            if (vt != ODValueType.STRING) throw new IllegalStateException((Object)((Object)vt) + " unknown");
            text = obj.toString();
        }
        this.setValue(vt, obj, text);
    }

    private Tuple3<String, ODValueType, Object> format(Object obj, ODValueType valueType, boolean onlyCast, boolean lenient) {
        String res = null;
        try {
            Tuple3<DataStyle, ODValueType, Object> ds = this.getDataStyleAndValue(obj, valueType, onlyCast);
            if (ds != null) {
                obj = ds.get2();
                valueType = (ODValueType)((Object)ds.get1());
                if (((DataStyle)ds.get0()).canFormat(obj.getClass())) {
                    res = ((DataStyle)ds.get0()).format(obj, this.getDefaultStyle(), lenient);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            if (lenient) {
                Log.get().warning(ExceptionUtils.getStackTrace(e));
            }
            throw e;
        }
        return Tuple3.create(res, valueType, obj);
    }

    public final DataStyle getDataStyle() {
        Tuple3<DataStyle, ODValueType, Object> s = this.getDataStyleAndValue(this.getValue(), this.getValueType(), true);
        return s != null ? (DataStyle)s.get0() : null;
    }

    private final Tuple3<DataStyle, ODValueType, Object> getDataStyleAndValue(Object obj, ODValueType valueType, boolean onlyCast) {
        CellStyle s = (CellStyle)this.getStyle();
        return s != null ? ((CellStyle)this.getStyle()).getDataStyle(obj, valueType, onlyCast) : null;
    }

    protected final CellStyle getDefaultStyle() {
        return this.getRow().getSheet().getDefaultCellStyle();
    }

    public void replaceBy(String oldValue, String newValue) {
        this.replaceContentBy(this.getElement(), oldValue, newValue);
    }

    private void replaceContentBy(Element l, String oldValue, String newValue) {
        List content = l.getContent();
        int i = 0;
        while (i < content.size()) {
            Object obj = content.get(i);
            if (obj instanceof Text) {
                Text t = (Text)obj;
                t.setText(t.getText().replaceAll(oldValue, newValue));
            } else if (obj instanceof Element) {
                this.replaceContentBy((Element)obj, oldValue, newValue);
            }
            ++i;
        }
    }

    public final void unmerge() {
        int x = this.getX();
        int y = this.getY();
        int columnsSpanned = this.getColumnsSpanned();
        int rowsSpanned = this.getRowsSpanned();
        int i = 0;
        while (i < columnsSpanned) {
            int j = 0;
            while (j < rowsSpanned) {
                this.getRow().getSheet().getImmutableCellAt(x + i, y + j).getElement().setName("table-cell");
                ++j;
            }
            ++i;
        }
        this.getElement().removeAttribute("number-columns-spanned", this.getNS().getTABLE());
        this.getElement().removeAttribute("number-rows-spanned", this.getNS().getTABLE());
    }

    public final void merge(int columnsSpanned, int rowsSpanned) {
        boolean shrinks;
        int currentCols = this.getColumnsSpanned();
        int currentRows = this.getRowsSpanned();
        if (columnsSpanned == currentCols && rowsSpanned == currentRows) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int i = 0;
        while (i < columnsSpanned) {
            int j = 0;
            while (j < rowsSpanned) {
                boolean coveredByThis;
                boolean bl = coveredByThis = i < currentCols && j < currentRows;
                if (!coveredByThis) {
                    int x2 = x + i;
                    int y2 = y + j;
                    Cell immutableCell = this.getRow().getSheet().getImmutableCellAt(x2, y2);
                    if (immutableCell.coversOtherCells()) {
                        throw new IllegalArgumentException("Cell at " + x2 + "," + y2 + " is a merged cell.");
                    }
                    if (immutableCell.getElement().getName().equals("covered-table-cell")) {
                        throw new IllegalArgumentException("Cell at " + x2 + "," + y2 + " is already covered.");
                    }
                }
                ++j;
            }
            ++i;
        }
        boolean bl = shrinks = columnsSpanned < currentCols || rowsSpanned < currentRows;
        if (shrinks) {
            this.unmerge();
        }
        int i2 = 0;
        while (i2 < columnsSpanned) {
            int j = 0;
            while (j < rowsSpanned) {
                boolean coveredByThis;
                boolean bl2 = coveredByThis = i2 < currentCols && j < currentRows;
                if (!(i2 == 0 && j == 0 || !shrinks && coveredByThis)) {
                    this.getRow().getSheet().getCellAt(x + i2, y + j).getElement().setName("covered-table-cell");
                }
                ++j;
            }
            ++i2;
        }
        this.getElement().setAttribute("number-columns-spanned", String.valueOf(columnsSpanned), this.getNS().getTABLE());
        this.getElement().setAttribute("number-rows-spanned", String.valueOf(rowsSpanned), this.getNS().getTABLE());
    }

    @Override
    public final String getStyleName() {
        return this.getRow().getSheet().getStyleNameAt(this.getX(), this.getY());
    }

    public void setImage(File pic) throws IOException {
        this.setImage(pic, false);
    }

    public void setImage(File pic, boolean keepRatio) throws IOException {
        this.setImage(pic.getName(), new BytesProducer.ByteArrayProducer(FileUtils.readBytes(pic), keepRatio));
    }

    public void setImage(String name, Image img) throws IOException {
        this.setImage(name, img == null ? null : new BytesProducer.ImageProducer(img, true));
    }

    private void setImage(String name, BytesProducer data) {
        Element imageElem;
        Namespace draw = this.getNS().getNS("draw");
        Element frame = this.getElement().getChild("frame", draw);
        Element element = imageElem = frame == null ? null : frame.getChild("image", draw);
        if (imageElem != null) {
            Attribute refAttr = imageElem.getAttribute("href", this.getNS().getNS("xlink"));
            ((ODDocument)this.getODDocument()).getPackage().putFile(refAttr.getValue(), null);
            if (data == null) {
                frame.detach();
            } else {
                refAttr.setValue("Pictures/" + name + (data.getFormat() != null ? "." + data.getFormat() : ""));
                ((ODDocument)this.getODDocument()).getPackage().putFile(refAttr.getValue(), data.getBytes(new ODFrame(this.getODDocument(), frame)));
            }
        } else if (data != null) {
            throw new IllegalStateException("this cell doesn't contain an image: " + this);
        }
    }

    public final void setBackgroundColor(Color color) {
        ((CellStyle)this.getPrivateStyle()).getTableCellProperties().setBackgroundColor(color);
    }
}

