/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.math.BigDecimal;
import org.jdom.Element;
import org.openconcerto.openoffice.LengthUnit;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.TableStyle;

public class ColumnStyle
extends StyleStyle {
    public static final StyleStyleDesc<ColumnStyle> DESC = new StyleStyleDesc<ColumnStyle>(ColumnStyle.class, XMLVersion.OD, "table-column", "co", "table"){

        @Override
        public ColumnStyle create(ODPackage pkg, Element e) {
            return new ColumnStyle(pkg, e);
        }
    };
    private StyleTableColumnProperties colProps;

    public ColumnStyle(ODPackage pkg, Element tableColElem) {
        super(pkg, tableColElem);
    }

    public final StyleTableColumnProperties getTableColumnProperties() {
        if (this.colProps == null) {
            this.colProps = new StyleTableColumnProperties(this);
        }
        return this.colProps;
    }

    public final Float getWidth() {
        BigDecimal res = this.getTableColumnProperties().getWidth(TableStyle.DEFAULT_UNIT);
        return res == null ? null : Float.valueOf(res.floatValue());
    }

    void setWidth(float f) {
        this.getFormattingProperties().setAttribute("column-width", String.valueOf(f) + TableStyle.DEFAULT_UNIT.getSymbol(), this.getSTYLE());
        this.rmRelWidth();
    }

    void rmRelWidth() {
        this.getFormattingProperties().removeAttribute("rel-column-width", this.getSTYLE());
    }

    public static class StyleTableColumnProperties
    extends StyleProperties {
        public StyleTableColumnProperties(StyleStyle style) {
            super(style, style.getFamily());
        }

        public final BigDecimal getWidth(LengthUnit in) {
            return LengthUnit.parseLength(this.getAttributeValue("column-width", this.getNS("style")), in);
        }

        public final String getBreakBefore() {
            return this.getAttributeValue("break-before", this.getNS("fo"));
        }

        public final String getBreakAfter() {
            return this.getAttributeValue("break-after", this.getNS("fo"));
        }
    }
}

