/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.awt.Color;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Element;
import org.openconcerto.openoffice.Log;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.StyledNode;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.style.RelationalOperator;
import org.openconcerto.openoffice.style.SideStyleProperties;
import org.openconcerto.openoffice.style.data.BooleanStyle;
import org.openconcerto.openoffice.style.data.DataStyle;
import org.openconcerto.openoffice.style.data.NumberStyle;
import org.openconcerto.openoffice.text.ParagraphStyle;
import org.openconcerto.openoffice.text.TextStyle;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.xml.JDOMUtils;

public class CellStyle
extends StyleStyle {
    private static final Pattern numberPatrn = Pattern.compile("-?\\d+(?:\\.\\d+)?");
    private static final Pattern escapedQuotePatrn = Pattern.compile("\"\"", 16);
    private static final Pattern stringPatrn = Pattern.compile("\"(?:[^\\p{Cntrl}\"]|\\p{Space}|" + escapedQuotePatrn.pattern() + ")*\"");
    private static final String valuePatrn = "(" + numberPatrn.pattern() + "|" + stringPatrn.pattern() + ")";
    private static final Pattern cellContentPatrn = Pattern.compile("cell-content\\(\\) *(" + RelationalOperator.OR_PATTERN + ") *" + valuePatrn);
    private static final Pattern cellContentBetweenPatrn = Pattern.compile("cell-content-is(?:-not)?-between\\(" + valuePatrn + ", *" + valuePatrn + "\\)");
    public static final StyleStyleDesc<CellStyle> DESC = new StyleStyleDesc<CellStyle>(CellStyle.class, XMLVersion.OD, "table-cell", "ce", "table", Arrays.asList("table:body", "table:covered-table-cell", "table:even-rows", "table:first-column", "table:first-row", "table:last-column", "table:last-row", "table:odd-columns", "table:odd-rows", "table:table-cell")){
        {
            this.getMultiRefElementsMap().putAll("table:default-cell-style-name", (String[])new String[]{"table:table-column", "table:table-row"});
        }

        @Override
        public CellStyle create(ODPackage pkg, Element e) {
            return new CellStyle(pkg, e);
        }

        @Override
        protected boolean supportConditions() {
            return true;
        }

        @Override
        protected Element evaluateConditions(StyledNode<CellStyle, ?> styledNode, List<Element> styleMaps) {
            Cell cell = (Cell)styledNode;
            Object cellValue = cell.getValue();
            for (Element styleMap : styleMaps) {
                String condition = styleMap.getAttributeValue("condition", this.getVersion().getSTYLE()).trim();
                Matcher matcher = cellContentPatrn.matcher(condition);
                if (matcher.matches()) {
                    if (!RelationalOperator.getInstance(matcher.group(1)).compare(cellValue, CellStyle.parse(matcher.group(2)))) continue;
                    return styleMap;
                }
                matcher = cellContentBetweenPatrn.matcher(condition);
                if (matcher.matches()) {
                    boolean isBetween;
                    boolean wantBetween = condition.startsWith("cell-content-is-between");
                    if (!$assertionsDisabled && !(wantBetween ^ condition.startsWith("cell-content-is-not-between"))) {
                        throw new AssertionError();
                    }
                    Object o1 = CellStyle.parse(matcher.group(1));
                    Object o2 = CellStyle.parse(matcher.group(2));
                    boolean bl = isBetween = CompareUtils.compare(cellValue, o1) >= 0 && CompareUtils.compare(cellValue, o2) <= 0;
                    if (isBetween != wantBetween) continue;
                    return styleMap;
                }
                Log.get().fine("Ignoring " + JDOMUtils.output(styleMap));
            }
            return null;
        }
    };
    private static final Pattern conditionPatrn = Pattern.compile("value\\(\\) *(" + RelationalOperator.OR_PATTERN + ") *(true|false|" + numberPatrn.pattern() + ")");
    private StyleTableCellProperties cellProps;
    private TextStyle.StyleTextProperties textProps;
    private ParagraphStyle.StyleParagraphProperties pProps;

    private static final Object convertForCondition(Object value, DataStyle style) {
        Serializable castedValue = style instanceof BooleanStyle ? (Serializable)BooleanStyle.toBoolean(value) : (Serializable)NumberStyle.toNumber(value, style.getEpoch());
        return castedValue;
    }

    public CellStyle(ODPackage pkg, Element tableColElem) {
        super(pkg, tableColElem);
    }

    private final DataStyle getDataStyle(Attribute name) {
        return (DataStyle)Style.getReferencedStyle(this.getPackage(), name);
    }

    final Tuple3<DataStyle, ODValueType, Object> getDataStyle(Object cellValue, ODValueType valueType, boolean onlyCast) {
        DataStyle res = this.getDataStyle(this.getElement().getAttribute("data-style-name", this.getSTYLE()));
        ODValueType returnValueType = valueType;
        Object returnCellValue = cellValue;
        if (res != null && valueType != null) {
            Object converted;
            List styleMaps;
            Object convertedForStyle;
            if (!onlyCast && (convertedForStyle = res.convert(cellValue)) != null) {
                returnCellValue = convertedForStyle;
                returnValueType = res.getDataType();
            }
            if ((styleMaps = res.getElement().getChildren("map", this.getSTYLE())).size() > 0 && (converted = CellStyle.convertForCondition(returnCellValue, res)) != null) {
                for (Object child : styleMaps) {
                    Element styleMap = (Element)child;
                    Matcher matcher = conditionPatrn.matcher(styleMap.getAttributeValue("condition", this.getSTYLE()).trim());
                    if (!matcher.matches()) {
                        throw new IllegalStateException("Cannot parse " + JDOMUtils.output(styleMap));
                    }
                    if (!RelationalOperator.getInstance(matcher.group(1)).compare(converted, CellStyle.parse(matcher.group(2)))) continue;
                    res = this.getDataStyle(styleMap.getAttribute("apply-style-name", this.getSTYLE()));
                    break;
                }
            }
        }
        assert (valueType == null == (returnValueType == null)) : "don't change type to null";
        assert (!onlyCast || returnValueType == valueType && returnCellValue == cellValue) : "Requested to only cast, but different object";
        return res == null ? null : Tuple3.create(res, returnValueType, returnCellValue);
    }

    private static Object parse(String val) {
        if (val.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (val.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (val.charAt(0) == '\"') {
            return escapedQuotePatrn.matcher(val.substring(1, val.length() - 1)).replaceAll("\"");
        }
        return new BigDecimal(val);
    }

    public final Color getBackgroundColor() {
        return this.getTableCellProperties().getBackgroundColor();
    }

    public final StyleTableCellProperties getTableCellProperties() {
        if (this.cellProps == null) {
            this.cellProps = new StyleTableCellProperties(this);
        }
        return this.cellProps;
    }

    public final TextStyle.StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.StyleTextProperties(this);
        }
        return this.textProps;
    }

    public final ParagraphStyle.StyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new ParagraphStyle.StyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public static class StyleTableCellProperties
    extends SideStyleProperties {
        public StyleTableCellProperties(StyleStyle style) {
            super(style, DESC.getFamily());
        }

        public final int getRotationAngle() {
            String s = this.getAttributeValue("rotation-angle", this.getElement().getNamespace("style"));
            return StyleTableCellProperties.parseInt(s, 0);
        }

        public final boolean isContentPrinted() {
            return StyleTableCellProperties.parseBoolean(this.getAttributeValue("print-content", this.getElement().getNamespace("style")), true);
        }

        public final boolean isContentRepeated() {
            return StyleTableCellProperties.parseBoolean(this.getAttributeValue("repeat-content", this.getElement().getNamespace("style")), false);
        }

        public final boolean isShrinkToFit() {
            return StyleTableCellProperties.parseBoolean(this.getAttributeValue("shrink-to-fit", this.getElement().getNamespace("style")), false);
        }

        public final Integer getDecimalPlaces() {
            return StyleTableCellProperties.parseInteger(this.getAttributeValue("decimal-places", this.getElement().getNamespace("style")));
        }
    }
}

