/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.OOXML;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.Row;
import org.openconcerto.openoffice.spreadsheet.TableCalcNode;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.xml.JDOMUtils;

public class Cell<D extends ODDocument>
extends TableCalcNode<CellStyle, D> {
    private static final Pattern multiSpacePattern = Pattern.compile("[\t\r\n ]+");
    private static boolean OO_MODE = true;
    private static final Pattern ErrorPattern = Pattern.compile("#[A-Z0-9]+( ?[!?]|(/([A-Z]|([0-9] ?[!?]))))");
    private final Row<D> row;

    public static void setTextValueMode(boolean ooMode) {
        OO_MODE = ooMode;
    }

    public static boolean getTextValueMode() {
        return OO_MODE;
    }

    static final Element createEmpty(XMLVersion ns) {
        return Cell.createEmpty(ns, 1);
    }

    static final Element createEmpty(XMLVersion ns, int count) {
        Element e = new Element("table-cell", ns.getTABLE());
        if (count > 1) {
            e.setAttribute("number-columns-repeated", String.valueOf(count), ns.getTABLE());
        }
        return e;
    }

    Cell(Row<D> parent, Element elem, StyleDesc<CellStyle> styleDesc) {
        super(parent.getODDocument(), elem, styleDesc);
        this.row = parent;
    }

    protected final Row<D> getRow() {
        return this.row;
    }

    protected final XMLVersion getNS() {
        return ((ODDocument)this.getODDocument()).getVersion();
    }

    protected final Namespace getValueNS() {
        XMLVersion ns = this.getNS();
        return ns == XMLVersion.OD ? ns.getOFFICE() : ns.getTABLE();
    }

    protected final String getType() {
        return this.getElement().getAttributeValue("value-type", this.getValueNS());
    }

    public final ODValueType getValueType() {
        String type = this.getType();
        return type == null ? null : ODValueType.get(type);
    }

    @Override
    protected String getStyleName() {
        throw new UnsupportedOperationException("cannot resolve our style, use MutableCell");
    }

    String getStyleAttr() {
        return this.getElement().getAttributeValue("style-name", this.getNS().getTABLE());
    }

    private final String getValue(String attrName) {
        return this.getElement().getAttributeValue(attrName, this.getValueNS());
    }

    public Object getValue() {
        ODValueType vt = this.getValueType();
        if (vt == null || vt == ODValueType.STRING) {
            String attr;
            String string = attr = vt == null ? null : this.getValue(vt.getValueAttribute());
            if (attr != null) {
                return attr;
            }
            return this.getTextValue();
        }
        return vt.parse(this.getValue(vt.getValueAttribute()));
    }

    public String getTextValue() {
        return this.getTextValue(Cell.getTextValueMode());
    }

    public String getTextValue(boolean ooMode) {
        ArrayList<String> ps = new ArrayList<String>();
        for (Object o : this.getElement().getChildren()) {
            Element child = (Element)o;
            if (!child.getName().equals("p") && !child.getName().equals("h") || !child.getNamespacePrefix().equals("text")) continue;
            ps.add(this.getStringValue(child, ooMode));
        }
        return CollectionUtils.join(ps, "\n");
    }

    private String getStringValue(Element pElem, boolean ooMode) {
        StringBuilder sb = new StringBuilder();
        Namespace textNS = pElem.getNamespace();
        OOXML xml = OOXML.get(((ODDocument)this.getODDocument()).getFormatVersion());
        Element tabElem = xml.getTab();
        Element newLineElem = xml.getLineBreak();
        boolean spaceSuffix = false;
        Iterator iter = pElem.getDescendants();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Text) {
                String text = multiSpacePattern.matcher(((Text)o).getText()).replaceAll(" ");
                if (!ooMode && text.startsWith(" ") && (spaceSuffix || sb.length() == 0)) {
                    sb.append(text.substring(1));
                } else {
                    sb.append(text);
                }
                spaceSuffix = text.endsWith(" ");
                continue;
            }
            if (!(o instanceof Element)) continue;
            Element elem = (Element)o;
            if (JDOMUtils.equals(elem, tabElem)) {
                sb.append("\t");
                continue;
            }
            if (JDOMUtils.equals(elem, newLineElem)) {
                sb.append("\n");
                continue;
            }
            if (!elem.getName().equals("s") || !elem.getNamespace().equals(textNS)) continue;
            int count = Integer.valueOf(elem.getAttributeValue("c", textNS, "1"));
            char[] toAdd = new char[count];
            Arrays.fill(toAdd, ' ');
            sb.append(toAdd);
        }
        if (!ooMode && spaceSuffix) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public final String getFormula() {
        return this.getElement().getAttributeValue("formula", this.getTABLE());
    }

    public String getError() {
        if (this.getFormula() == null) {
            return null;
        }
        String textValue = this.getTextValue();
        return XMLFormatVersion.get(XMLVersion.OD, "1.1").equals(((ODDocument)this.getODDocument()).getFormatVersion()) && textValue.equals("#NA") || ErrorPattern.matcher(textValue).matches() ? textValue : null;
    }

    public boolean isValid() {
        return !this.isCovered();
    }

    protected final boolean isCovered() {
        return this.getElement().getName().equals("covered-table-cell");
    }

    public final boolean isEmpty() {
        return this.getValueType() == null && this.getElement().getContentSize() == 0;
    }

    public final int getColumnsSpanned() {
        return Integer.parseInt(this.getElement().getAttributeValue("number-columns-spanned", this.getNS().getTABLE(), "1"));
    }

    public final int getRowsSpanned() {
        return Integer.parseInt(this.getElement().getAttributeValue("number-rows-spanned", this.getNS().getTABLE(), "1"));
    }

    protected final boolean coversOtherCells() {
        return this.getColumnsSpanned() > 1 || this.getRowsSpanned() > 1;
    }
}

