/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation.desc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.generation.desc.ReportDefine;
import org.openconcerto.openoffice.generation.desc.ReportType;

public final class ReportTypes {
    private final File baseDir;
    private final Document doc;
    private final Map<String, ReportType> types;
    private final Map<String, ReportDefine> defines;

    public static final ReportType createSingle(File template, String partType) {
        Document doc = new Document(new Element("types"));
        String typeName = "single";
        Element type = ReportType.createSingle("single", template.getName(), null, partType);
        doc.getRootElement().addContent(type);
        return new ReportTypes(doc, template.getParentFile()).getType("single");
    }

    public ReportTypes(File f) throws JDOMException, IOException {
        this(new SAXBuilder().build(f), f.getParentFile());
    }

    public ReportTypes(Document doc, File baseDir) {
        this.baseDir = baseDir;
        this.doc = doc;
        this.defines = new HashMap<String, ReportDefine>();
        this.loadDefines();
        this.preProcess();
        List l = this.doc.getRootElement().getChildren("reportType");
        this.types = new LinkedHashMap<String, ReportType>();
        ListIterator i = l.listIterator();
        while (i.hasNext()) {
            Element elem = (Element)i.next();
            ReportType type = new ReportType(this, elem);
            this.types.put(type.getName(), type);
        }
    }

    private final void preProcess() {
        try {
            List includes = XPath.newInstance("//include").selectNodes(this.doc.getRootElement());
            for (Element includeElem : includes) {
                String name = includeElem.getAttributeValue("name");
                ReportDefine define = this.getDefine(name);
                if (define == null) {
                    throw new IllegalStateException("no corresponding define with name: " + name);
                }
                define.replace(includeElem);
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public final List<ReportType> getTypes() {
        return new ArrayList<ReportType>(this.types.values());
    }

    public final ReportType getType(String name) {
        return this.types.get(name);
    }

    public final File resolve(String fname) {
        return new File(this.baseDir, fname);
    }

    private final void loadDefines() {
        this.defines.clear();
        List l = this.doc.getRootElement().getChildren("defineSub");
        ListIterator i = l.listIterator();
        while (i.hasNext()) {
            Element elem = (Element)i.next();
            ReportDefine define = new ReportDefine(elem);
            if (this.defines.put(define.getName(), define) == null) continue;
            throw new IllegalStateException("define with duplicate name : " + define.getName());
        }
    }

    private final ReportDefine getDefine(String name) {
        return this.defines.get(name);
    }
}

