/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation.desc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ognl.Ognl;
import ognl.OgnlException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.xml.JDOMUtils;

public abstract class ParamsHelper {
    private static final Element getParamElem(Element elem, String paramName) {
        try {
            XPath p = XPath.newInstance("./ancestor-or-self::*[./params/param/@name='" + paramName + "'][1]/params/param[@name='" + paramName + "']");
            return (Element)p.selectSingleNode(elem);
        }
        catch (JDOMException e) {
            throw new IllegalStateException("pb xpath", e);
        }
    }

    static final String getParam(Element elem, String paramName, IFactory<?> data) {
        return (String)ParamsHelper.getParam(elem, paramName, data, false);
    }

    private static final Object getParam(Element elem, String paramName, IFactory<?> data, boolean asList) {
        String res;
        Element paramElem = ParamsHelper.getParamElem(elem, paramName);
        if (paramElem == null) {
            return null;
        }
        String attr = paramElem.getAttributeValue("value");
        String exprAttr = paramElem.getAttributeValue("valueExpr");
        List<Element> children = ParamsHelper.getListParam(paramElem);
        boolean[] valuesEmptyness = new boolean[]{attr == null, exprAttr == null, children.isEmpty()};
        String[] names = new String[]{"value attribute", "valueExpr attribute", "children"};
        ArrayList<String> definedValues = new ArrayList<String>();
        int i = 0;
        while (i < valuesEmptyness.length) {
            if (!valuesEmptyness[i]) {
                definedValues.add(names[i]);
            }
            ++i;
        }
        if (definedValues.size() == 0) {
            throw new IllegalArgumentException(String.valueOf(JDOMUtils.output(elem)) + " has neither an attribute nor any children defined");
        }
        if (definedValues.size() > 1) {
            throw new IllegalArgumentException(String.valueOf(JDOMUtils.output(elem)) + " has defined :" + definedValues);
        }
        if (asList) {
            List<String> res2;
            if (attr != null) {
                res2 = Collections.singletonList(attr);
            } else if (exprAttr != null) {
                Object value = ParamsHelper.evaluteOgnl(exprAttr, data);
                if (value instanceof List) {
                    List l = (List)value;
                    res2 = new ArrayList<String>(l.size());
                    for (Object o : l) {
                        res2.add(o.toString());
                    }
                } else {
                    res2 = Collections.singletonList(value.toString());
                }
            } else {
                res2 = new ArrayList<String>();
                for (Element valElem : children) {
                    res2.add(ParamsHelper.getValue(valElem));
                }
            }
            return res2;
        }
        if (attr != null) {
            res = attr;
        } else if (exprAttr != null) {
            res = ParamsHelper.evaluteOgnl(exprAttr, data).toString();
        } else {
            if (children.size() > 1) {
                throw new IllegalArgumentException("more than one children for " + JDOMUtils.output(elem));
            }
            res = ParamsHelper.getValue(children.get(0));
        }
        return res;
    }

    static Object evaluteOgnl(String exprAttr, IFactory<?> data) {
        try {
            return Ognl.getValue(exprAttr, data.createChecked());
        }
        catch (OgnlException e) {
            throw new IllegalArgumentException("error evaluating :" + exprAttr, e);
        }
    }

    private static String getValue(Element valElem) {
        return valElem.getTextTrim();
    }

    private static final List<Element> getListParam(Element paramElem) {
        return paramElem.getChildren("value");
    }

    static final List<String> getListParam(Element elem, String paramName, IFactory<?> data) {
        return (List)ParamsHelper.getParam(elem, paramName, data, true);
    }
}

