/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation;

public final class TaskStatus {
    public static final TaskStatus NOT_STARTED = new TaskStatus(State.NOT_STARTED, 0.0f);
    public static final TaskStatus STARTED = new TaskStatus(State.WORKING, 0.0f);
    public static final TaskStatus DONE = new TaskStatus(State.DONE, 1.0f);
    private final State s;
    private final float completion;

    static TaskStatus create(float completion) {
        return new TaskStatus(State.WORKING, completion);
    }

    private TaskStatus(State s, float completion) {
        this.s = s;
        if (completion < 0.0f || completion > 1.0f) {
            throw new IllegalArgumentException(String.valueOf(completion) + " is not between 0 and 1");
        }
        this.completion = completion;
    }

    public final float getCompletion() {
        return this.completion;
    }

    public final State getState() {
        return this.s;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskStatus) {
            TaskStatus t = (TaskStatus)obj;
            return t.getState().equals((Object)this.getState()) && t.getCompletion() == this.completion;
        }
        return false;
    }

    public int hashCode() {
        return this.s.hashCode() + (int)(this.completion * 100.0f);
    }

    public String toString() {
        return (Object)((Object)this.s) + " " + this.completion;
    }

    public static enum State {
        NOT_STARTED,
        WORKING,
        DONE;

    }
}

