/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.openconcerto.openoffice.OOXML;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.utils.CompareUtils;

public final class XMLFormatVersion {
    private static Map<XMLFormatVersion, XMLFormatVersion> instances = new HashMap<XMLFormatVersion, XMLFormatVersion>();
    private static final XMLFormatVersion OOo = XMLFormatVersion.get(XMLVersion.OOo, "1.0");
    private final XMLVersion xmlVersion;
    private final String officeVersion;
    private OOXML xml;

    public static XMLFormatVersion getOOo() {
        return OOo;
    }

    public static XMLFormatVersion getDefault() {
        return OOXML.getDefault().getFormatVersion();
    }

    public static XMLFormatVersion get(Document doc) {
        return XMLFormatVersion.get(doc.getRootElement());
    }

    public static XMLFormatVersion get(Element root) {
        XMLVersion version = XMLVersion.getVersion(root);
        return XMLFormatVersion.get(version, root.getAttributeValue("version", version.getOFFICE()));
    }

    public static XMLFormatVersion get(XMLVersion xmlVersion, String officeVersion) {
        XMLFormatVersion key = new XMLFormatVersion(xmlVersion, officeVersion);
        XMLFormatVersion res = instances.get(key);
        if (res == null) {
            res = key;
            instances.put(res, res);
        }
        return res;
    }

    private XMLFormatVersion(XMLVersion xmlVersion, String officeVersion) {
        if (xmlVersion == null) {
            throw new NullPointerException("Null XMLVersion");
        }
        this.xmlVersion = xmlVersion;
        this.officeVersion = officeVersion;
        this.xml = null;
    }

    public final XMLVersion getXMLVersion() {
        return this.xmlVersion;
    }

    public final String getOfficeVersion() {
        return this.officeVersion;
    }

    public final OOXML getXML() {
        if (this.xml == null) {
            this.xml = OOXML.get(this);
        }
        return this.xml;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.officeVersion == null ? 0 : this.officeVersion.hashCode());
        result = 31 * result + this.xmlVersion.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLFormatVersion other = (XMLFormatVersion)obj;
        return this.xmlVersion == other.xmlVersion && CompareUtils.equals(this.officeVersion, other.officeVersion);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + (Object)((Object)this.getXMLVersion()) + " version " + this.getOfficeVersion();
    }
}

