/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.XMLVersion;

public abstract class StyleStyleDesc<S extends StyleStyle>
extends StyleDesc<S> {
    static final String ELEMENT_NAME = "style";
    static final String ELEMENT_DEFAULT_NAME = "default-style";
    private final String family;

    static String getFamily(Element styleElem) {
        assert (styleElem.getName().equals(ELEMENT_NAME) || styleElem.getName().equals(ELEMENT_DEFAULT_NAME));
        return styleElem.getAttributeValue("family", styleElem.getNamespace(ELEMENT_NAME));
    }

    public static <C extends StyleStyle> StyleStyleDesc<C> copy(final StyleStyleDesc<C> toClone, XMLVersion version) {
        StyleStyleDesc res = new StyleStyleDesc<C>(toClone.getStyleClass(), version, toClone.getFamily(), toClone.getBaseName()){

            @Override
            public C create(ODPackage pkg, Element e) {
                return (StyleStyle)toClone.create(pkg, e);
            }
        };
        res.getRefElementsMap().putAll(toClone.getRefElementsMap());
        res.getMultiRefElementsMap().putAll(toClone.getMultiRefElementsMap());
        return res;
    }

    protected StyleStyleDesc(Class<S> clazz, XMLVersion version, String family, String baseName, String ns) {
        this(clazz, version, family, baseName, ns, Collections.singletonList(String.valueOf(ns) + ":" + family));
    }

    protected StyleStyleDesc(Class<S> clazz, XMLVersion version, String family, String baseName, String ns, List<String> refQNames) {
        this(clazz, version, family, baseName);
        this.getRefElementsMap().putAll((Object)(String.valueOf(ns) + ":style-name"), refQNames);
    }

    protected StyleStyleDesc(Class<S> clazz, XMLVersion version, String family, String baseName) {
        super(clazz, version, ELEMENT_NAME, baseName);
        this.family = family;
    }

    public final String getFamily() {
        return this.family;
    }

    @Override
    protected void initStyle(Element elem) {
        super.initStyle(elem);
        elem.setAttribute("family", this.getFamily(), elem.getNamespace());
    }

    public final S findDefaultStyle(ODPackage pkg) {
        Element styleElem = pkg.getDefaultStyle(this);
        return (S)(styleElem == null ? null : (StyleStyle)this.create(pkg, styleElem));
    }
}

