/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.StyledNode;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class StyleDesc<S extends Style> {
    private static final ITransformer<String, String> Q_NAME_TRANSF = new ITransformer<String, String>(){

        @Override
        public String transformChecked(String input) {
            return "name() = '" + input + "'";
        }
    };
    private final Class<S> clazz;
    private final XMLVersion version;
    private Namespace elemNS;
    private final String elemName;
    private final String baseName;
    private final CollectionMap<String, String> refElements;
    private final CollectionMap<String, String> multiRefElements;
    private XPath refXPath;

    public static <C extends Style> StyleDesc<C> copy(final StyleDesc<C> toClone, XMLVersion version) {
        if (toClone instanceof StyleStyleDesc) {
            StyleStyleDesc res = StyleStyleDesc.copy((StyleStyleDesc)toClone, version);
            return res;
        }
        StyleDesc res = new StyleDesc<C>(toClone.getStyleClass(), version, toClone.getElementName(), toClone.getBaseName()){

            @Override
            public C create(ODPackage pkg, Element e) {
                return toClone.create(pkg, e);
            }
        };
        res.getRefElementsMap().putAll(toClone.getRefElementsMap());
        res.getMultiRefElementsMap().putAll(toClone.getMultiRefElementsMap());
        return res;
    }

    private static final String getXPath(Collection<Map.Entry<String, Collection<String>>> entries) {
        return CollectionUtils.join(entries, " or ", new ITransformer<Map.Entry<String, Collection<String>>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, Collection<String>> e) {
                String nameTest = CollectionUtils.join(e.getValue(), " or ", Q_NAME_TRANSF);
                return "( @" + e.getKey() + " = $name  and ( " + nameTest + " ))";
            }
        });
    }

    protected StyleDesc(Class<S> clazz, XMLVersion version, String elemName, String baseName, String ns, List<String> refQNames) {
        this(clazz, version, elemName, baseName);
        this.getRefElementsMap().putAll((Object)(String.valueOf(ns) + ":style-name"), refQNames);
    }

    protected StyleDesc(Class<S> clazz, XMLVersion version, String elemName, String baseName) {
        this.clazz = clazz;
        this.version = version;
        this.elemNS = version.getSTYLE();
        this.elemName = elemName;
        this.baseName = baseName;
        this.refElements = new CollectionMap();
        this.multiRefElements = new CollectionMap(4);
        this.refXPath = null;
    }

    public abstract S create(ODPackage var1, Element var2);

    final Class<S> getStyleClass() {
        return this.clazz;
    }

    public final XMLVersion getVersion() {
        return this.version;
    }

    protected final void setElementNS(Namespace elemNS) {
        this.elemNS = elemNS;
    }

    public final Namespace getElementNS() {
        return this.elemNS;
    }

    public final String getElementName() {
        return this.elemName;
    }

    public final String getBaseName() {
        return this.baseName;
    }

    private final XPath getRefXPath() {
        if (this.refXPath == null) {
            String attrOr = "( $includeSingle and " + StyleDesc.getXPath(this.getRefElementsMap().entrySet()) + " )";
            String multiOr = this.getMultiRefElementsMap().size() == 0 ? "" : " or ( $includeMulti and " + StyleDesc.getXPath(this.getMultiRefElementsMap().entrySet()) + " )";
            try {
                this.refXPath = OOUtils.getXPath("//*[ " + attrOr + multiOr + " ]", this.version);
            }
            catch (JDOMException e) {
                throw new IllegalStateException("couldn't create xpath with " + this.getRefElements(), e);
            }
        }
        return this.refXPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Element> getReferences(Document doc, String name, boolean wantSingle, boolean wantMulti) {
        XPath xp = this.getRefXPath();
        try {
            XPath xPath = xp;
            synchronized (xPath) {
                xp.setVariable("name", name);
                xp.setVariable("includeSingle", wantSingle);
                xp.setVariable("includeMulti", wantMulti);
                return xp.selectNodes(doc);
            }
        }
        catch (JDOMException e) {
            throw new IllegalStateException("unable to search for occurences of " + this, e);
        }
    }

    protected final Collection<String> getRefElements() {
        return this.getRefElementsMap().values();
    }

    protected final CollectionMap<String, String> getRefElementsMap() {
        return this.refElements;
    }

    protected final CollectionMap<String, String> getMultiRefElementsMap() {
        return this.multiRefElements;
    }

    public final S findStyleWithName(ODPackage pkg, Document doc, String name) {
        return this.findStyle(pkg, doc, name, null);
    }

    public final S findStyleForNode(StyledNode<S, ?> styledNode, String name) {
        return this.findStyleForNode(((ODDocument)styledNode.getODDocument()).getPackage(), styledNode.getElement().getDocument(), styledNode, name);
    }

    public final S findStyleForNode(ODPackage pkg, Document doc, StyledNode<S, ?> styledNode, String name) {
        if (styledNode == null) {
            throw new NullPointerException("null node");
        }
        return this.findStyle(pkg, doc, name, styledNode);
    }

    private final S findStyle(ODPackage pkg, Document doc, String name, StyledNode<S, ?> styledNode) {
        List styleMaps;
        Element styleMap;
        Element styleElem = pkg.getStyle(doc, this, name);
        if (styleElem == null) {
            return null;
        }
        if (styledNode != null && this.supportConditions() && (styleMap = this.evaluateConditions(styledNode, styleMaps = styleElem.getChildren("map", this.getVersion().getSTYLE()))) != null) {
            if (styleElem != styleMap.getParent()) {
                throw new IllegalStateException("map element not in " + styleElem);
            }
            styleElem = pkg.getStyle(doc, this, styleMap.getAttributeValue("apply-style-name", this.getVersion().getSTYLE()));
        }
        return this.create(pkg, styleElem);
    }

    protected boolean supportConditions() {
        return false;
    }

    protected Element evaluateConditions(StyledNode<S, ?> styledNode, List<Element> styleMaps) {
        return null;
    }

    public final S createAutoStyle(ODPackage pkg) {
        return this.createAutoStyle(pkg, this.getBaseName());
    }

    public final S createAutoStyle(ODPackage pkg, String baseName) {
        ODXMLDocument xml = pkg.getContent();
        Namespace style = xml.getVersion().getSTYLE();
        Element elem = new Element(this.getElementName(), style);
        this.initStyle(elem);
        elem.setAttribute("name", xml.findUnusedName(this, baseName), style);
        xml.addAutoStyle(elem);
        return this.create(pkg, elem);
    }

    protected void initStyle(Element elem) {
    }
}

