/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.math.BigDecimal;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.Duration;
import org.openconcerto.utils.FormatGroup;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.XMLDateFormat;

public enum ODValueType {
    FLOAT("value", new Class[]{Number.class}){

        @Override
        public String format(Object o) {
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).toPlainString();
            }
            return ((Number)o).toString();
        }

        @Override
        public BigDecimal parse(String s) {
            return new BigDecimal(s);
        }
    }
    ,
    PERCENTAGE("value", new Class[]{Number.class}){

        @Override
        public String format(Object o) {
            return FLOAT.format(o);
        }

        @Override
        public Object parse(String s) {
            return FLOAT.parse(s);
        }
    }
    ,
    CURRENCY("value", new Class[]{Number.class}){

        @Override
        public String format(Object o) {
            return FLOAT.format(o);
        }

        @Override
        public Object parse(String s) {
            return FLOAT.parse(s);
        }
    }
    ,
    DATE("date-value", new Class[]{Date.class, Calendar.class}){

        @Override
        public String format(Object o) {
            Date d = o instanceof Calendar ? ((Calendar)o).getTime() : (Date)o;
            return DATE_FORMAT.format(d);
        }

        @Override
        public Date parse(String date) {
            if (date.length() == 0) {
                return null;
            }
            try {
                return (Date)DATE_FORMAT.parseObject(date);
            }
            catch (ParseException e) {
                throw new IllegalStateException("wrong date: " + date, e);
            }
        }
    }
    ,
    TIME("time-value", new Class[]{Duration.class, Calendar.class}){

        @Override
        public String format(Object o) {
            if (o instanceof Duration) {
                return o.toString();
            }
            Calendar cal = (Calendar)o;
            return TimeUtils.timePartToDuration(cal).toString();
        }

        @Override
        public Duration parse(String date) {
            if (date.length() == 0) {
                return null;
            }
            return TimeUtils.getTypeFactory().newDuration(date);
        }
    }
    ,
    BOOLEAN("boolean-value", new Class[]{Boolean.class}){

        @Override
        public String format(Object o) {
            return ((Boolean)o).toString().toLowerCase();
        }

        @Override
        public Boolean parse(String s) {
            return Boolean.valueOf(s);
        }
    }
    ,
    STRING("string-value", new Class[]{String.class}){

        @Override
        public String format(Object o) {
            return o.toString();
        }

        @Override
        public String parse(String s) {
            return s;
        }
    };

    private final String attr;
    private final List<Class<?>> acceptedClasses;
    private static final Format DATE_FORMAT;

    static {
        DATE_FORMAT = new FormatGroup(new XMLDateFormat(), new SimpleDateFormat("yyyy-MM-dd'T'HH':'mm':'ss"), new SimpleDateFormat("yyyy-MM-dd"));
    }

    private ODValueType(String attr, Class<?> ... classes) {
        this.attr = attr;
        this.acceptedClasses = Arrays.asList(classes);
    }

    public final String getValueAttribute() {
        return this.attr;
    }

    public boolean canFormat(Class<?> toFormat) {
        for (Class<?> c : this.acceptedClasses) {
            if (!c.isAssignableFrom(toFormat)) continue;
            return true;
        }
        return false;
    }

    public abstract String format(Object var1);

    public abstract Object parse(String var1);

    public final String getName() {
        return this.name().toLowerCase();
    }

    public static ODValueType get(String name) {
        return ODValueType.valueOf(name.toUpperCase());
    }

    public static ODValueType forObject(Object o) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof Number) {
            return FLOAT;
        }
        if (o instanceof Boolean) {
            return BOOLEAN;
        }
        if (o instanceof String) {
            return STRING;
        }
        if (o instanceof Duration) {
            return TIME;
        }
        if (DATE.canFormat(o.getClass())) {
            return DATE;
        }
        return null;
    }

    /* synthetic */ ODValueType(String string, int n, String string2, Class[] classArray, ODValueType oDValueType) {
        this(string2, classArray);
    }
}

