/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ODEpoch;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;

public abstract class ODDocument {
    private final ODPackage pkg;
    private ODEpoch epoch;

    protected ODDocument(ODPackage orig) {
        if (orig.hasODDocument()) {
            throw new IllegalStateException("ODPackage already has an ODDocument");
        }
        this.pkg = orig;
    }

    public final XMLVersion getVersion() {
        return this.getFormatVersion().getXMLVersion();
    }

    public final XMLFormatVersion getFormatVersion() {
        return this.getPackage().getFormatVersion();
    }

    public final ODPackage getPackage() {
        return this.pkg;
    }

    public final Document getContentDocument() {
        return this.getPackage().getContent().getDocument();
    }

    protected final Element getBody() {
        return this.getPackage().getContentType().getBody(this.getContentDocument());
    }

    private final String findEpoch() throws ParseException {
        Element nullDateElem;
        Namespace tableNS = this.getVersion().getTABLE();
        Element settings = this.getBody().getChild("calculation-settings", tableNS);
        if (settings != null && (nullDateElem = settings.getChild("null-date", tableNS)) != null) {
            return nullDateElem.getAttributeValue("date-value", tableNS);
        }
        return null;
    }

    public final ODEpoch getEpoch() {
        return this.getEpoch(false);
    }

    public final ODEpoch getEpoch(boolean updateFromXML) {
        if (this.epoch == null || updateFromXML) {
            try {
                this.epoch = ODEpoch.getInstance(this.findEpoch());
            }
            catch (ParseException e) {
                throw new IllegalStateException("Unable to parse the epoch of " + this, e);
            }
        }
        assert (this.epoch != null);
        return this.epoch;
    }

    public File saveAs(File file) throws FileNotFoundException, IOException {
        this.getPackage().setFile(file);
        return this.getPackage().save();
    }
}

