/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.xml.JDOMUtils;

final class Manifest {
    public static final String ENTRY_NAME = "META-INF/manifest.xml";
    private static final DocType DOC_TYPE = new DocType("manifest:manifest", "-//OpenOffice.org//DTD Manifest 1.0//EN", "Manifest.dtd");
    private final XMLVersion version;
    private final Document doc;

    public static final Map<String, String> parse(InputStream ins) throws JDOMException, IOException {
        HashMap<String, String> res = new HashMap<String, String>();
        Document manifestDoc = OOUtils.getBuilder().build(ins);
        for (Object child : manifestDoc.getRootElement().getChildren()) {
            Element fileEntry = (Element)child;
            String path = fileEntry.getAttributeValue("full-path", fileEntry.getNamespace("manifest"));
            if (path.equals("/")) continue;
            String type = fileEntry.getAttributeValue("media-type", fileEntry.getNamespace("manifest"));
            res.put(path, type);
        }
        return res;
    }

    public Manifest(XMLVersion version, String mainType) {
        this.version = version;
        this.doc = new Document(new Element("manifest", this.getNS()), version == XMLVersion.OOo ? (DocType)DOC_TYPE.clone() : null);
        this.addEntry("/", mainType);
    }

    private Namespace getNS() {
        return this.version.getManifest();
    }

    public void addEntry(String path, String type) {
        Element elem = new Element("file-entry", this.getNS());
        elem.setAttribute("media-type", type, this.getNS());
        elem.setAttribute("full-path", path, this.getNS());
        this.doc.getRootElement().addContent(elem);
    }

    public String asString() {
        return JDOMUtils.output(this.doc);
    }
}

