/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.HashSet;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODPackageEntry;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyledNode;

public class ImmutableDocStyledNode<S extends StyleStyle, D extends ODDocument>
extends StyledNode<S, D> {
    private final D parent;

    private static final Set<Document> getDocuments(ODPackage pkg) {
        HashSet<Document> res = new HashSet<Document>();
        for (String entry : pkg.getEntries()) {
            ODPackageEntry e = pkg.getEntry(entry);
            if (!(e.getData() instanceof ODXMLDocument)) continue;
            res.add(pkg.getDocument(entry));
        }
        return res;
    }

    public ImmutableDocStyledNode(D parent, Element local, Class<S> styleClass) {
        this(parent, local, ImmutableDocStyledNode.getStyleDesc(local, styleClass));
    }

    protected ImmutableDocStyledNode(D parent, Element local, StyleDesc<S> styleDesc) {
        super(local, styleDesc);
        this.parent = parent;
        assert (ImmutableDocStyledNode.getDocuments(((ODDocument)this.parent).getPackage()).contains(local.getDocument())) : "Local not in parent: " + parent;
    }

    @Override
    public final D getODDocument() {
        return this.parent;
    }

    protected final ODXMLDocument getContent() {
        return ((ODDocument)this.getODDocument()).getPackage().getContent();
    }
}

