/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import bmsi.util.Diff;
import bmsi.util.DiffPrint;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.utils.FileUtils;

public class Diff {
    private static final XMLOutputter OUTPUTTER;
    private static final Pattern SPACES;
    final boolean recursive;
    final boolean ignoreSpaces;
    final boolean newFile;

    static {
        Format f = Format.getPrettyFormat();
        f.setLineSeparator("\n");
        OUTPUTTER = new XMLOutputter(f);
        SPACES = Pattern.compile(" +");
    }

    public static void main(String[] args) throws JDOMException, IOException {
        if (args.length < 2 || args.length > 5) {
            Diff.usage();
        } else {
            String filea = args[args.length - 2];
            String fileb = args[args.length - 1];
            boolean rec = false;
            boolean ignoreSpace = false;
            boolean newFile = false;
            int i = 0;
            while (i < args.length - 2) {
                String arg = args[i];
                if (arg.equals("-R")) {
                    rec = true;
                }
                if (arg.equals("-b")) {
                    ignoreSpace = true;
                }
                if (arg.equals("-N")) {
                    newFile = true;
                }
                ++i;
            }
            new Diff(rec, ignoreSpace, newFile).diff(filea, fileb);
        }
    }

    public Diff(boolean recursive, boolean ignoreSpaces, boolean newFile) {
        this.recursive = recursive;
        this.ignoreSpaces = ignoreSpaces;
        this.newFile = newFile;
    }

    private void diff(String filea, String fileb) throws JDOMException, IOException {
        if (this.recursive) {
            File dir1 = new File(filea);
            File dir2 = new File(fileb);
            HashSet<String> fileSet = new HashSet<String>(FileUtils.listR(dir1));
            fileSet.addAll(FileUtils.listR(dir2));
            for (String file : fileSet) {
                if (!file.endsWith(".sxw") && !file.endsWith(".odt")) continue;
                this.compare(String.valueOf(filea) + "/" + file, String.valueOf(fileb) + "/" + file);
            }
        } else {
            this.compare(filea, fileb);
        }
    }

    private void compare(String filea, String fileb) throws JDOMException, IOException {
        Object[] f1 = this.output(filea);
        Object[] f2 = this.output(fileb);
        if (f1 == null) {
            System.out.println(String.valueOf(filea) + " doesn't exist");
        } else if (f2 == null) {
            System.out.println(String.valueOf(fileb) + " doesn't exist");
        } else {
            bmsi.util.Diff d = new bmsi.util.Diff(f1, f2);
            Diff.change script = d.diff_2(false);
            if (script == null) {
                System.out.println("No differences between " + filea + " and " + fileb);
            } else {
                DiffPrint.UnifiedPrint p = new DiffPrint.UnifiedPrint(f1, f2);
                ((DiffPrint.ContextPrint)p).print_header(filea, fileb);
                p.print_script(script);
            }
        }
    }

    private String[] output(String file) throws JDOMException, IOException {
        File f = new File(file);
        if (f.exists()) {
            ODSingleXMLDocument oodoc = ODSingleXMLDocument.createFromFile(f);
            oodoc.getChild("settings").detach();
            String contentS = OUTPUTTER.outputString(oodoc.getDocument());
            if (this.ignoreSpaces) {
                contentS = SPACES.matcher(contentS).replaceAll(" ");
            }
            return contentS.split("\n");
        }
        if (this.newFile) {
            return new String[0];
        }
        return null;
    }

    private static void usage() {
        System.out.println("Usage: " + Diff.class.getName() + " file1 file2");
        System.out.println("\t" + Diff.class.getName() + " -R dir1 dir2");
    }
}

