/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.Arrays;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;

public class ContentTypeVersioned
extends Enum<ContentTypeVersioned> {
    public static final /* enum */ ContentTypeVersioned TEXT_V1 = new ContentTypeVersioned(ContentType.TEXT, XMLVersion.OOo, "application/vnd.sun.xml.writer", "text", "sxw"){};
    public static final /* enum */ ContentTypeVersioned GRAPHICS_V1 = new ContentTypeVersioned(ContentType.GRAPHICS, XMLVersion.OOo, "application/vnd.sun.xml.draw", "drawing", "sxd"){};
    public static final /* enum */ ContentTypeVersioned PRESENTATION_V1 = new ContentTypeVersioned(ContentType.PRESENTATION, XMLVersion.OOo, "application/vnd.sun.xml.impress", "presentation", "sxi"){};
    public static final /* enum */ ContentTypeVersioned SPREADSHEET_V1 = new ContentTypeVersioned(ContentType.SPREADSHEET, XMLVersion.OOo, "application/vnd.sun.xml.calc", "spreadsheet", "sxc"){};
    public static final /* enum */ ContentTypeVersioned TEXT = new ContentTypeVersioned(ContentType.TEXT, XMLVersion.OD, "application/vnd.oasis.opendocument.text", "text", "odt"){};
    public static final /* enum */ ContentTypeVersioned TEXT_TEMPLATE = new ContentTypeVersioned(ContentType.TEXT, XMLVersion.OD, "application/vnd.oasis.opendocument.text-template", "text", "ott"){};
    public static final /* enum */ ContentTypeVersioned GRAPHICS = new ContentTypeVersioned(ContentType.GRAPHICS, XMLVersion.OD, "application/vnd.oasis.opendocument.graphics", "drawing", "odg"){};
    public static final /* enum */ ContentTypeVersioned GRAPHICS_TEMPLATE = new ContentTypeVersioned(ContentType.GRAPHICS, XMLVersion.OD, "application/vnd.oasis.opendocument.graphics-template", "drawing", "otg"){};
    public static final /* enum */ ContentTypeVersioned PRESENTATION = new ContentTypeVersioned(ContentType.PRESENTATION, XMLVersion.OD, "application/vnd.oasis.opendocument.presentation", "presentation", "odp"){};
    public static final /* enum */ ContentTypeVersioned PRESENTATION_TEMPLATE = new ContentTypeVersioned(ContentType.PRESENTATION, XMLVersion.OD, "application/vnd.oasis.opendocument.presentation-template", "presentation", "otp"){};
    public static final /* enum */ ContentTypeVersioned SPREADSHEET = new ContentTypeVersioned(ContentType.SPREADSHEET, XMLVersion.OD, "application/vnd.oasis.opendocument.spreadsheet", "spreadsheet", "ods"){};
    public static final /* enum */ ContentTypeVersioned SPREADSHEET_TEMPLATE = new ContentTypeVersioned(ContentType.SPREADSHEET, XMLVersion.OD, "application/vnd.oasis.opendocument.spreadsheet-template", "spreadsheet", "ots"){};
    private final ContentType type;
    private final XMLVersion version;
    private final String mimeType;
    private final String shortName;
    private final String extension;
    private static final String TEMPLATE_SUFFIX = "-template";
    private static final /* synthetic */ ContentTypeVersioned[] ENUM$VALUES;

    static {
        ENUM$VALUES = new ContentTypeVersioned[]{TEXT_V1, GRAPHICS_V1, PRESENTATION_V1, SPREADSHEET_V1, TEXT, TEXT_TEMPLATE, GRAPHICS, GRAPHICS_TEMPLATE, PRESENTATION, PRESENTATION_TEMPLATE, SPREADSHEET, SPREADSHEET_TEMPLATE};
    }

    private ContentTypeVersioned(ContentType type, XMLVersion version, String mimeType, String bodyChildName, String extension) {
        this.type = type;
        this.mimeType = mimeType;
        this.version = version;
        this.shortName = bodyChildName;
        this.extension = extension;
    }

    public final XMLVersion getVersion() {
        return this.version;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getBodyPath() {
        return this.getVersion() == XMLVersion.OOo ? "./office:body" : "./office:body/office:" + this.getShortName();
    }

    public final Element getBody(Document doc) {
        Namespace officeNS = this.getVersion().getOFFICE();
        Element body = doc.getRootElement().getChild("body", officeNS);
        if (this.getVersion().equals((Object)XMLVersion.OOo)) {
            return body;
        }
        return body.getChild(this.getShortName(), officeNS);
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final ContentType getType() {
        return this.type;
    }

    public final String getExtension() {
        return this.extension;
    }

    public final boolean isTemplate() {
        return this.getMimeType().endsWith(TEMPLATE_SUFFIX);
    }

    public final ContentTypeVersioned getTemplate() {
        if (this.isTemplate()) {
            return this;
        }
        return ContentTypeVersioned.fromMime(String.valueOf(this.getMimeType()) + TEMPLATE_SUFFIX);
    }

    public final ContentTypeVersioned getNonTemplate() {
        if (this.isTemplate()) {
            return ContentTypeVersioned.fromMime(this.getMimeType().substring(0, this.getMimeType().length() - TEMPLATE_SUFFIX.length()));
        }
        return this;
    }

    public final Element createContent(XMLFormatVersion version) {
        return this.createContent(version, false);
    }

    public Element createContent(XMLFormatVersion version, boolean singleXML) {
        Element body;
        this.checkVersion(version);
        ODPackage.RootElement rootElement = singleXML ? ODPackage.RootElement.SINGLE_CONTENT : ODPackage.RootElement.CONTENT;
        Document doc = rootElement.createDocument(version);
        Namespace officeNS = this.getVersion().getOFFICE();
        this.setType(doc, rootElement, officeNS);
        doc.getRootElement().addContent(new Element("automatic-styles", officeNS));
        Element topBody = new Element("body", officeNS);
        if (this.getVersion().equals((Object)XMLVersion.OD)) {
            body = new Element(this.getShortName(), officeNS);
            topBody.addContent(body);
        } else {
            body = topBody;
        }
        doc.getRootElement().addContent(topBody);
        return body;
    }

    private final void checkVersion(XMLFormatVersion version) {
        if (version.getXMLVersion() != this.getVersion()) {
            throw new IllegalArgumentException("Version mismatch : " + (Object)((Object)version.getXMLVersion()));
        }
    }

    public void setType(Document doc) {
        this.setType(doc, ODPackage.RootElement.fromDocument(doc), this.getVersion().getOFFICE());
    }

    private void setType(Document doc, ODPackage.RootElement rootElem, Namespace officeNS) {
        Element root = doc.getRootElement();
        assert (root.getName().equals(rootElem.getElementName()));
        if (rootElem != ODPackage.RootElement.CONTENT && rootElem != ODPackage.RootElement.SINGLE_CONTENT) {
            throw new IllegalArgumentException("the document is not content : " + (Object)((Object)rootElem));
        }
        if (this.getVersion().equals((Object)XMLVersion.OOo)) {
            root.setAttribute("class", this.getShortName(), officeNS);
        } else if (this.getVersion().equals((Object)XMLVersion.OD) && rootElem == ODPackage.RootElement.SINGLE_CONTENT) {
            root.setAttribute("mimetype", this.getMimeType(), officeNS);
        }
    }

    public Document createStyles(XMLFormatVersion version) {
        this.checkVersion(version);
        Namespace officeNS = this.getVersion().getOFFICE();
        Document styles = ODPackage.RootElement.STYLES.createDocument(version);
        styles.getRootElement().addContent(Arrays.asList(new Element("styles", officeNS), new Element("automatic-styles", officeNS), new Element("master-styles", officeNS)));
        return styles;
    }

    public ODPackage createPackage(XMLFormatVersion version) {
        return ODPackage.createFromDocuments(this, this.createContent(version, false).getDocument(), this.createStyles(version), null, null);
    }

    static ContentTypeVersioned fromType(ContentType type, XMLVersion version, boolean template) {
        ContentTypeVersioned[] contentTypeVersionedArray = ContentTypeVersioned.values();
        int n = contentTypeVersionedArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentTypeVersioned t = contentTypeVersionedArray[n2];
            if (t.getType().equals((Object)type) && t.getVersion() == version && t.isTemplate() == template) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static ContentTypeVersioned fromMime(String mime) {
        ContentTypeVersioned[] contentTypeVersionedArray = ContentTypeVersioned.values();
        int n = contentTypeVersionedArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentTypeVersioned t = contentTypeVersionedArray[n2];
            if (t.getMimeType().equals(mime)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static ContentTypeVersioned fromMime(byte[] mime) {
        return ContentTypeVersioned.fromMime(new String(mime, ODPackage.MIMETYPE_ENC));
    }

    static ContentTypeVersioned fromContent(ODXMLDocument content) {
        ContentTypeVersioned res;
        XMLVersion vers = content.getVersion();
        if (vers.equals((Object)XMLVersion.OOo)) {
            Element contentRoot = content.getDocument().getRootElement();
            String docClass = contentRoot.getAttributeValue("class", contentRoot.getNamespace("office"));
            res = ContentTypeVersioned.fromClass(docClass);
        } else if (vers.equals((Object)XMLVersion.OD)) {
            Element bodyChild = (Element)content.getChild("body").getChildren().get(0);
            res = ContentTypeVersioned.fromBody(bodyChild.getName());
        } else {
            throw new IllegalStateException("Unknown content version : " + (Object)((Object)vers));
        }
        assert (!res.isTemplate()) : "template status cannot be inferred from content";
        return res;
    }

    static ContentTypeVersioned fromClass(String name) {
        return ContentTypeVersioned.fromShortName(XMLVersion.OOo, name);
    }

    static ContentTypeVersioned fromBody(String name) {
        return ContentTypeVersioned.fromShortName(XMLVersion.OD, name);
    }

    private static ContentTypeVersioned fromShortName(XMLVersion version, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        ContentTypeVersioned[] contentTypeVersionedArray = ContentTypeVersioned.values();
        int n = contentTypeVersionedArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentTypeVersioned t = contentTypeVersionedArray[n2];
            if (t.shortName.equals(name) && t.getVersion() == version) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static ContentTypeVersioned[] values() {
        ContentTypeVersioned[] contentTypeVersionedArray = ENUM$VALUES;
        int n = contentTypeVersionedArray.length;
        ContentTypeVersioned[] contentTypeVersionedArray2 = new ContentTypeVersioned[n];
        System.arraycopy(ENUM$VALUES, 0, contentTypeVersionedArray2, 0, n);
        return contentTypeVersionedArray2;
    }

    public static ContentTypeVersioned valueOf(String string) {
        return Enum.valueOf(ContentTypeVersioned.class, string);
    }

    /* synthetic */ ContentTypeVersioned(String string, int n, ContentType contentType, XMLVersion xMLVersion, String string2, String string3, String string4, ContentTypeVersioned contentTypeVersioned) {
        this(contentType, xMLVersion, string2, string3, string4);
    }
}

