/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate.statements;

import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.Processor;

public abstract class Statement {
    private final String name;
    public static final Namespace stmtNS = Namespace.getNamespace("jod", "http://www.jopendocument.org");

    public Statement(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public abstract boolean matches(Element var1);

    public abstract void prepare(Element var1) throws TemplateException;

    public abstract void execute(Processor<?> var1, Element var2, DataModel var3) throws TemplateException;

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName();
    }

    protected static Element getElement(String name) {
        return new Element(name, stmtNS);
    }

    protected static Element getAncestorByName(Element element, String name) {
        Element parent;
        while ((parent = element.getParentElement()) != null) {
            if (parent.getName().equals(name)) {
                return parent;
            }
            element = parent;
        }
        return null;
    }

    protected static void pullUp(Element elem) {
        List parentContent = elem.getParentElement().getContent();
        int index = parentContent.indexOf(elem);
        elem.detach();
        parentContent.addAll(index, elem.removeContent());
    }
}

