/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate.statements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.Processor;
import org.openconcerto.odtemplate.statements.BaseStatement;
import org.openconcerto.utils.ExceptionUtils;

public class ForEach
extends BaseStatement {
    private static Logger logger = Logger.getLogger(ForEach.class.getName());

    public ForEach() {
        super("forEach");
    }

    @Override
    public void prepare(Element script, Element command) throws TemplateException {
        int siblingsToAdd;
        int multiple;
        int alternate;
        String elementName = command.getAttributeValue("element");
        if (elementName == null) {
            throw new TemplateException("missing required attribute for forEach tag: element");
        }
        String itemsExpression = command.getAttributeValue("items");
        if (itemsExpression == null) {
            throw new TemplateException("missing required attribute for forEach tag: items");
        }
        String varName = command.getAttributeValue("var");
        if (varName == null) {
            throw new TemplateException("missing required attribute for forEach tag: var");
        }
        String alternateString = command.getAttributeValue("alternate");
        if (alternateString == null) {
            alternate = 1;
        } else {
            try {
                alternate = Integer.parseInt(alternateString);
            }
            catch (Throwable t) {
                throw new TemplateException("invalid alternate attribute for forEach tag: " + alternateString);
            }
        }
        String multipleString = command.getAttributeValue("multiple");
        if (multipleString == null) {
            multiple = 0;
        } else {
            try {
                multiple = Integer.parseInt(multipleString);
            }
            catch (Throwable t) {
                throw new TemplateException("invalid alternate attribute for forEach tag: " + multipleString);
            }
        }
        if (alternate > 1 && multiple > 0) {
            throw new TemplateException("both alternate and multiple have been specified");
        }
        Element element = ForEach.getAncestorByName(script, elementName);
        if (element == null) {
            throw new TemplateException("no such element enclosing forEach: " + elementName + " for expression: " + itemsExpression);
        }
        Element parent = element.getParentElement();
        Element forEachTag = ForEach.getElement("forEach").setAttribute("items", itemsExpression).setAttribute("var", varName);
        if (multiple > 0) {
            forEachTag.setAttribute("multiple", "yes");
            siblingsToAdd = multiple - 1;
        } else {
            siblingsToAdd = alternate - 1;
        }
        int index = parent.indexOf(element);
        ArrayList<Element> targets = new ArrayList<Element>();
        targets.add(element);
        if (siblingsToAdd > 0) {
            List siblings;
            try {
                XPath xpath = XPath.newInstance("following-sibling::*");
                siblings = xpath.selectNodes(element);
            }
            catch (JDOMException e) {
                throw ExceptionUtils.createExn(TemplateException.class, "xpath error", e);
            }
            if (siblingsToAdd > siblings.size()) {
                throw new TemplateException("alternate or multiple is greater (" + (siblingsToAdd + 1) + ") than actual table size (" + siblings.size() + ").");
            }
            int i = 0;
            while (i < siblingsToAdd) {
                Element sibling = (Element)siblings.get(i);
                targets.add(sibling);
                sibling.detach();
                ++i;
            }
        }
        element.detach();
        parent.getContent().add(index, forEachTag);
        int i = 0;
        while (i < targets.size()) {
            forEachTag.addContent((Content)targets.get(i));
            ++i;
        }
        script.detach();
    }

    public void execute(Processor processor, Element tag, DataModel model) throws TemplateException {
        String varName = tag.getAttributeValue("var");
        String itemsExpression = tag.getAttributeValue("items");
        boolean multiple = "yes".equals(tag.getAttributeValue("multiple"));
        Iterator value = model.eval(itemsExpression);
        if (value == null) {
            logger.info("forEach items: null expression: " + itemsExpression);
            return;
        }
        List<Object> items = value instanceof Collection ? (List<Object>)((Object)value) : (value instanceof Object[] ? Arrays.asList((Object[])value) : null);
        if (items == null && !(value instanceof Iterator)) {
            throw new TemplateException("forEach items neither a Collection nor an Iterator: " + itemsExpression + " => " + value.getClass() + ":" + value);
        }
        List<Element> targets = tag.getChildren();
        List parentContent = tag.getParentElement().getContent();
        int iterationCount = 0;
        int index = parentContent.indexOf(tag);
        ArrayList itemsList = items == null ? new ArrayList() : new ArrayList(items.size());
        ArrayList createdElems = items == null ? new ArrayList() : new ArrayList(items.size());
        Iterator itemsIter = items != null ? items.iterator() : value;
        while (itemsIter.hasNext()) {
            List<Element> toAdd;
            Object item = itemsIter.next();
            if (multiple) {
                toAdd = targets;
            } else {
                toAdd = Collections.singletonList(targets.get(iterationCount % targets.size()));
                ++iterationCount;
            }
            ArrayList<Element> added = new ArrayList<Element>(toAdd.size());
            for (Element target : toAdd) {
                Element newElement = (Element)target.clone();
                parentContent.add(index++, newElement);
                added.add(newElement);
            }
            itemsList.add(item);
            createdElems.add(added);
        }
        ListIterator i = itemsList.listIterator();
        while (i.hasNext()) {
            Object item = i.next();
            model.put(varName, item);
            for (Element newElement : (List)createdElems.get(i.previousIndex())) {
                processor.transform(newElement);
                ForEach.removeSection(newElement);
            }
        }
        tag.detach();
    }
}

