/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.xpath.XPath;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.Material;
import org.openconcerto.odtemplate.engine.Parsed;
import org.openconcerto.odtemplate.statements.Statement;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.OOXML;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.xml.JDOMUtils;

public class Processor<E> {
    public static final String OO_XML = "OOXML:";
    public static final String ENCODE = "%enc:";
    public static final String AS_STR = "%str:";
    private static Logger logger = Logger.getLogger(Processor.class.getName());
    private final Parsed<E> parsed;
    private final OOXML ns;
    private final XPath xp;
    private final DataModel model;
    private Material<E> material;

    Processor(Parsed<E> parsed, DataModel model) throws TemplateException {
        this.parsed = parsed;
        this.model = model;
        this.ns = this.parsed.getSource().getNS();
        try {
            this.xp = OOUtils.getXPath(".//text:span", this.ns.getVersion());
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(TemplateException.class, "xpath error", e);
        }
        this.material = null;
    }

    public final Parsed<E> getParsed() {
        return this.parsed;
    }

    public Material<E> getMaterial() {
        return this.material;
    }

    public Material<E> process() throws TemplateException {
        this.material = this.parsed.getSource().clone();
        this.transform(this.material.getRoot());
        Material<E> res = this.material;
        this.material = null;
        return res;
    }

    public void transform(Element element) throws TemplateException {
        String tagName = element.getName();
        if (tagName.equals("text-input")) {
            try {
                this.replaceField(element);
            }
            catch (Exception e) {
                throw new TemplateException("pb while replacing " + JDOMUtils.output(element), e);
            }
        } else if (element.getNamespace().equals(Statement.stmtNS)) {
            Statement tag = this.parsed.getStatement(tagName);
            if (tag != null) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("executing tag " + tagName);
                    }
                    tag.execute(this, element, this.model);
                }
                catch (Exception e) {
                    throw new TemplateException("pb while executing " + tag + " at " + JDOMUtils.output(element), e);
                }
            } else {
                logger.warning("unknown tag: " + tagName);
            }
        } else {
            for (Element child : new ArrayList(element.getChildren())) {
                this.transform(child);
            }
        }
    }

    private void replaceField(Element field) throws TemplateException {
        boolean encode;
        boolean isOOXML;
        String expression = field.getAttributeValue("description", this.ns.getVersion().getTEXT());
        boolean asString = expression.startsWith(AS_STR);
        if (asString) {
            expression = expression.substring(AS_STR.length());
        }
        if (isOOXML = expression.startsWith(OO_XML)) {
            expression = expression.substring(OO_XML.length());
        }
        if (encode = expression.startsWith(ENCODE)) {
            expression = expression.substring(ENCODE.length());
        }
        field.setName("span");
        field.setNamespace(this.ns.getVersion().getTEXT());
        Object value = this.model.eval(expression);
        if (value != null) {
            if (encode) {
                value = this.ns.encodeWS(value.toString());
            } else if (isOOXML) {
                try {
                    value = this.parse(value.toString());
                }
                catch (JDOMException e) {
                    throw ExceptionUtils.createExn(IllegalArgumentException.class, "invalid xml for : " + value, e);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("replacing field \"" + expression + "\" with \"" + value + "\"");
            }
            if (!asString && value instanceof Element) {
                field.setContent(this.getChildren((Element)value));
            } else {
                field.setText(this.display(value));
            }
        } else {
            logger.warning("missing value for field: " + expression);
            field.setText("");
        }
    }

    private String display(Object value) {
        String res = value instanceof Element ? JDOMUtils.output((Element)value) : value.toString();
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private List getChildren(Element xmlElem) {
        try {
            iter = this.xp.selectNodes(xmlElem).listIterator();
            if (true) ** GOTO lbl10
        }
        catch (JDOMException e1) {
            throw ExceptionUtils.createExn(RuntimeException.class, "xpath error", e1);
        }
        do {
            e = (Element)iter.next();
            parentContent = e.getParent().getContent();
            parentContent.add(parentContent.indexOf(e) + 1, new Text("\n"));
lbl10:
            // 2 sources

        } while (iter.hasNext());
        return xmlElem.removeContent();
    }

    private Element parse(String ooxml) throws JDOMException {
        return JDOMUtils.parseElementString("<dummy>" + ooxml + "</dummy>", this.ns.getVersion().getALL());
    }
}

