/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.Material;
import org.openconcerto.odtemplate.engine.Processor;
import org.openconcerto.odtemplate.statements.ForEach;
import org.openconcerto.odtemplate.statements.If;
import org.openconcerto.odtemplate.statements.Include;
import org.openconcerto.odtemplate.statements.SetStmt;
import org.openconcerto.odtemplate.statements.Statement;
import org.openconcerto.xml.JDOMUtils;

public class Parsed<E> {
    private final Material<E> src;
    private final Map<String, Statement> statements;

    private static Set<Statement> createDefaultStatements() {
        HashSet<Statement> res = new HashSet<Statement>();
        res.add(new ForEach());
        res.add(new If());
        res.add(new SetStmt());
        res.add(new Include());
        return res;
    }

    public Parsed(Material<E> src) throws TemplateException {
        this(src, Parsed.createDefaultStatements());
    }

    public Parsed(Material<E> src, Parsed<?> p) throws TemplateException {
        this(src, new HashSet<Statement>(p.statements.values()));
    }

    public Parsed(Material<E> src, Set<Statement> statements) throws TemplateException {
        this.src = src;
        this.statements = new HashMap<String, Statement>(statements.size());
        for (Statement stmt : statements) {
            this.statements.put(stmt.getName(), stmt);
        }
        this.prepare(statements);
    }

    private void prepare(Set<Statement> statementsDef) throws TemplateException {
        if (this.src.hasRoot()) {
            LinkedHashMap<Element, Statement> statements = new LinkedHashMap<Element, Statement>();
            Iterator iter = this.src.getRoot().getDescendants(new ElementFilter());
            block2: while (iter.hasNext()) {
                Element e = (Element)iter.next();
                for (Statement stmt : statementsDef) {
                    if (!stmt.matches(e)) continue;
                    statements.put(e, stmt);
                    continue block2;
                }
            }
            for (Element e : statements.keySet()) {
                try {
                    ((Statement)statements.get(e)).prepare(e);
                }
                catch (Exception exn) {
                    throw new TemplateException("Couldn't prepare " + JDOMUtils.output(e), exn);
                }
            }
        }
    }

    public Material<E> getSource() {
        return this.src;
    }

    public Statement getStatement(String name) {
        return this.statements.get(name);
    }

    public E execute(DataModel data) throws TemplateException {
        if (!this.getSource().hasRoot()) {
            return this.getSource().getWhole();
        }
        return new Processor(this, data).process().getWhole();
    }
}

