/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.Predicate;
import org.openconcerto.map.model.Ville;
import org.openconcerto.map.ui.ITextComboCacheVille;
import org.openconcerto.map.ui.MapViewerPanel;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.IComboCacheListModel;
import org.openconcerto.ui.component.combo.ISearchableTextCombo;
import org.openconcerto.ui.component.text.DocumentComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObject;
import org.openconcerto.utils.checks.EmptyObjectHelper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public class ITextComboVilleViewer
extends JPanel
implements ValueWrapper<String>,
DocumentComponent,
TextComponent,
EmptyObject {
    private static final long serialVersionUID = 3397210337907076649L;
    private final ISearchableTextCombo text;
    private final JButton button = new JButton("Afficher sur la carte");
    private Ville currentVille = null;
    private final EmptyObjectHelper emptyHelper;
    private final ValueChangeSupport<String> supp;
    private final ITextComboCacheVille cache;

    public ITextComboVilleViewer() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.supp = new ValueChangeSupport<String>(this);
        this.cache = new ITextComboCacheVille();
        this.text = new ISearchableTextCombo(ComboLockedMode.LOCKED_ITEMS_UNLOCKED, 0, 17){

            @Override
            protected String stringToT(String t) {
                Ville v = ITextComboVilleViewer.this.cache.createVilleFrom(t);
                if (v != null) {
                    return t;
                }
                throw new IllegalArgumentException("Format incorrect, la ville doit \u00eatre du format VILLE (CODEPOSTAL)\n Ex:  Abbeville (80100)");
            }
        };
        this.text.setMaxVisibleRows(20);
        this.text.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ITextComboVilleViewer.this.supp.fireValueChange();
            }
        });
        this.text.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                ITextComboVilleViewer.this.supp.fireValidChange();
            }
        });
        this.emptyHelper = new EmptyObjectHelper(this, new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return ITextComboVilleViewer.this.getValue() == null || ITextComboVilleViewer.this.getValue().trim().length() == 0;
            }
        });
        new IComboCacheListModel(this.cache).initCacheLater(this.text);
        this.add((Component)this.text, "Center");
        this.add((Component)this.button, "East");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame();
                MapViewerPanel mapViewerPanel = new MapViewerPanel(true);
                f.setContentPane(mapViewerPanel);
                f.setDefaultCloseOperation(2);
                f.setSize(600, 500);
                f.setMinimumSize(new Dimension(600, 500));
                File conf = new File(System.getProperty("user.home"), ".java" + File.separator + "ilm" + File.separator + "map" + File.separator);
                new WindowStateManager(f, new File(conf, "Configuration" + File.separator + "MapFrame.properties"), true).loadState();
                f.setVisible(true);
                if (ITextComboVilleViewer.this.currentVille != null) {
                    long x = ITextComboVilleViewer.this.currentVille.getXLambert();
                    long y = ITextComboVilleViewer.this.currentVille.getYLambert();
                    f.setTitle(ITextComboVilleViewer.this.currentVille.getName());
                    mapViewerPanel.getVilleRendererPanel().centerScreenXYLambert(x, y);
                    mapViewerPanel.getVilleRendererPanel().setHighlight(ITextComboVilleViewer.this.currentVille);
                    mapViewerPanel.getVilleRendererPanel().setAlwayVisible(ITextComboVilleViewer.this.currentVille);
                }
            }
        });
        this.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ITextComboVilleViewer.this.currentVille = evt.getNewValue() == null ? null : Ville.getVilleFromVilleEtCode(evt.getNewValue().toString());
                ITextComboVilleViewer.this.button.setEnabled(ITextComboVilleViewer.this.currentVille != null && ITextComboVilleViewer.this.isEnabled());
            }
        });
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.emptyHelper.addListener(l);
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public Document getDocument() {
        return this.text.getDocument();
    }

    @Override
    public JTextComponent getTextComp() {
        return this.text.getTextComp();
    }

    @Override
    public Object getUncheckedValue() {
        return this.getValue();
    }

    @Override
    public String getValue() {
        return (String)this.text.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.emptyHelper.isEmpty();
    }

    @Override
    public ValidState getValidState() {
        return this.text.getValidState();
    }

    @Override
    public void resetValue() {
        this.text.resetValue();
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    public void setButtonVisible(boolean b) {
        this.button.setVisible(b);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    @Override
    public void setValue(String val) {
        this.text.setValue(val);
    }
}

