/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ftp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.cc.ExnClosure;

public final class FTPUtils {
    private FTPUtils() {
    }

    public static final void saveR(FTPClient ftp, File local) throws IOException {
        local.mkdirs();
        FTPFile[] fTPFileArray = ftp.listFiles();
        int n = fTPFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile child = fTPFileArray[n2];
            String childName = child.getName();
            if (childName.indexOf(46) != 0) {
                if (child.isDirectory()) {
                    ftp.changeWorkingDirectory(childName);
                    FTPUtils.saveR(ftp, new File(local, childName));
                    ftp.changeToParentDirectory();
                } else {
                    FileOutputStream outs = new FileOutputStream(new File(local, childName));
                    ftp.retrieveFile(childName, outs);
                    ((OutputStream)outs).close();
                }
            }
            ++n2;
        }
    }

    public static final void rmR(final FTPClient ftp, String toRm) throws IOException {
        String cwd = ftp.printWorkingDirectory();
        if (ftp.changeWorkingDirectory(toRm)) {
            FTPUtils.recurse(ftp, new ExnClosure<FTPFile, IOException>(){

                @Override
                public void executeChecked(FTPFile input) throws IOException {
                    boolean res = input.isDirectory() ? ftp.removeDirectory(input.getName()) : ftp.deleteFile(input.getName());
                    if (!res) {
                        throw new IOException("unable to delete " + input);
                    }
                }
            }, RecursionType.DEPTH_FIRST);
        }
        ftp.changeWorkingDirectory(cwd);
        ftp.removeDirectory(toRm);
    }

    public static final void recurse(FTPClient ftp, ExnClosure<FTPFile, ?> c) throws IOException {
        FTPUtils.recurse(ftp, c, RecursionType.DEPTH_FIRST);
    }

    public static final void recurse(FTPClient ftp, ExnClosure<FTPFile, ?> c, RecursionType type) throws IOException {
        FTPFile[] fTPFileArray = ftp.listFiles();
        int n = fTPFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile child = fTPFileArray[n2];
            if (child.getName().indexOf(46) != 0) {
                if (type == RecursionType.BREADTH_FIRST) {
                    c.executeCheckedWithExn(child, IOException.class);
                }
                if (child.isDirectory()) {
                    ftp.changeWorkingDirectory(child.getName());
                    FTPUtils.recurse(ftp, c, type);
                    ftp.changeToParentDirectory();
                }
                if (type == RecursionType.DEPTH_FIRST) {
                    c.executeCheckedWithExn(child, IOException.class);
                }
            }
            ++n2;
        }
    }
}

