/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.GestionDevise;

public class ExportRelationExpertPanel
extends JPanel
implements ActionListener {
    private JDate du;
    private JDate au;
    private JButton buttonGen = new JButton("Exporter");
    private JButton buttonClose = new JButton("Fermer");
    private JFileChooser fileChooser = new JFileChooser();
    private JTextField textDestination = new JTextField();
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public ExportRelationExpertPanel() {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 10;
        this.add((Component)new JLabelBold("Export des \u00e9critures comptables"), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Fichier de destination"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textDestination, c);
        JButton buttonChoose = new JButton("...");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)buttonChoose, c);
        this.buttonGen.setEnabled(false);
        this.textDestination.setEditable(false);
        buttonChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer = ExportRelationExpertPanel.this.fileChooser.showSaveDialog(ExportRelationExpertPanel.this);
                if (answer == 0) {
                    ExportRelationExpertPanel.this.textDestination.setText(ExportRelationExpertPanel.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
                ExportRelationExpertPanel.this.buttonGen.setEnabled(answer == 0);
            }
        });
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        c.anchor = 17;
        this.add((Component)new JLabel("du"), c);
        ++c.gridx;
        this.du = new JDate(true);
        this.add((Component)this.du, c);
        ++c.gridx;
        this.add((Component)new JLabel("au"), c);
        ++c.gridx;
        this.au = new JDate(true);
        this.add((Component)this.au, c);
        ++c.gridy;
        c.gridx = 0;
        JPanel panelButton = new JPanel();
        panelButton.add(this.buttonGen);
        panelButton.add(this.buttonClose);
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 0.0;
        this.add((Component)panelButton, c);
        this.buttonGen.addActionListener(this);
        this.buttonClose.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonGen) {
            File fOut = this.fileChooser.getSelectedFile();
            try {
                BufferedOutputStream bufOut = new BufferedOutputStream(new FileOutputStream(String.valueOf(fOut.getAbsolutePath()) + ".xls"));
                SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                SQLSelect sel = new SQLSelect(base);
                SQLTable tableEcriture = base.getTable("ECRITURE");
                SQLTable tableMouvement = base.getTable("MOUVEMENT");
                SQLTable tableCompte = base.getTable("COMPTE_PCE");
                SQLTable tableJrnl = base.getTable("JOURNAL");
                sel.addSelect(tableEcriture.getField("NOM"));
                sel.addJoin("LEFT", "ECRITURE.ID_COMPTE_PCE");
                sel.addJoin("LEFT", "ECRITURE.ID_MOUVEMENT");
                sel.addJoin("LEFT", "ECRITURE.ID_JOURNAL");
                sel.addSelect(tableMouvement.getField("NUMERO"));
                sel.addSelect(tableCompte.getField("NUMERO"));
                sel.addSelect(tableEcriture.getField("DATE"));
                sel.addSelect(tableEcriture.getField("DEBIT"));
                sel.addSelect(tableEcriture.getField("CREDIT"));
                sel.addSelect(tableJrnl.getField("CODE"));
                sel.setWhere(new Where((FieldRef)tableEcriture.getField("DATE"), this.du.getDate(), (Object)this.au.getDate()).and(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "=", 3)));
                List l = (List)base.getDataSource().execute(sel.asString(), new ArrayListHandler());
                System.err.println(sel.asString());
                if (l != null) {
                    int i = 0;
                    while (i < l.size()) {
                        StringBuffer line = new StringBuffer();
                        Object[] tmp = (Object[])l.get(i);
                        Date d = (Date)tmp[3];
                        line.append(this.dateFormat.format(d));
                        line.append('\t');
                        line.append(tmp[6].toString().trim());
                        line.append('\t');
                        String cpt = tmp[2].toString().trim();
                        line.append(cpt);
                        line.append('\t');
                        line.append('\t');
                        line.append(tmp[0].toString().trim());
                        line.append('\t');
                        Long debit = new Long(tmp[4].toString().trim());
                        line.append(GestionDevise.currencyToString(debit));
                        line.append('\t');
                        Long credit = new Long(tmp[5].toString().trim());
                        line.append(GestionDevise.currencyToString(credit));
                        line.append('\t');
                        line.append('E');
                        line.append('\r');
                        line.append('\n');
                        bufOut.write(line.toString().getBytes());
                        ++i;
                    }
                }
                bufOut.close();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        ((JFrame)SwingUtilities.getRoot(this)).dispose();
    }
}

