/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import org.openconcerto.utils.CompareUtils;

public class ModuleVersion
implements Comparable<ModuleVersion> {
    public static final int MAX = 10000;
    private static final long MERGED_MAX = 100000000L;
    private final int major;
    private final int minor;
    private final long merged;

    public ModuleVersion(int major, int minor) {
        if (major >= 10000) {
            throw new IllegalArgumentException("Major too big " + major);
        }
        if (minor >= 10000) {
            throw new IllegalArgumentException("Minor too big " + minor);
        }
        this.major = major;
        this.minor = minor;
        this.merged = major * 10000 + minor;
    }

    public ModuleVersion(long merged) {
        if (merged >= 100000000L) {
            throw new IllegalArgumentException("Merged too big " + merged);
        }
        this.major = (int)(merged / 10000L);
        this.minor = (int)(merged % 10000L);
        this.merged = merged;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final long getMerged() {
        return this.merged;
    }

    @Override
    public int compareTo(ModuleVersion o) {
        return CompareUtils.compareLong(this.merged, o.merged);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.merged ^ this.merged >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.merged == ((ModuleVersion)obj).merged;
    }

    public String toString() {
        return "v" + this.getMajor() + "." + this.getMinor();
    }
}

