/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.openconcerto.erp.modules.InstalledModuleTableModel;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleFrame;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.IFactory;

public class InstalledModulesPanel
extends JPanel {
    private final InstalledModuleTableModel tm;

    InstalledModulesPanel(final ModuleFrame moduleFrame) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        IFactory<List<ModuleFactory>> rowSource = new IFactory<List<ModuleFactory>>(){

            @Override
            public List<ModuleFactory> createChecked() {
                ArrayList<ModuleFactory> l = new ArrayList<ModuleFactory>();
                ModuleManager mngr = ModuleManager.getInstance();
                for (String id : mngr.getModulesInstalledLocally()) {
                    ModuleFactory factory = mngr.getFactories().get(id);
                    if (factory == null) {
                        System.err.println("Erreur: pas de factory pour le module " + id);
                        continue;
                    }
                    l.add(factory);
                }
                return l;
            }
        };
        this.tm = new InstalledModuleTableModel((IFactory<? extends Collection<ModuleFactory>>)rowSource);
        final JTable t = new JTable(this.tm);
        t.setShowGrid(false);
        t.setShowVerticalLines(false);
        t.setFocusable(false);
        t.setRowSelectionAllowed(false);
        t.setColumnSelectionAllowed(false);
        t.setCellSelectionEnabled(false);
        t.getColumnModel().getColumn(0).setWidth(24);
        t.getColumnModel().getColumn(0).setPreferredWidth(24);
        t.getColumnModel().getColumn(0).setMaxWidth(24);
        t.getColumnModel().getColumn(0).setResizable(false);
        t.getColumnModel().getColumn(1).setMinWidth(148);
        t.getColumnModel().getColumn(2).setMinWidth(48);
        t.getColumnModel().getColumn(2).setPreferredWidth(48);
        t.getColumnModel().getColumn(3).setMinWidth(48);
        t.getColumnModel().getColumn(3).setPreferredWidth(48);
        t.getTableHeader().setReorderingAllowed(false);
        t.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    if (!e.getChanged().isDisplayable()) {
                        t.setModel(new DefaultTableModel());
                    } else if (t.getModel() != InstalledModulesPanel.this.tm) {
                        t.setModel(InstalledModulesPanel.this.tm);
                    }
                }
            }
        });
        JScrollPane scroll = new JScrollPane(t);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 4;
        c.fill = 1;
        this.add((Component)scroll, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridx;
        c.fill = 0;
        c.gridheight = 1;
        JButton activateButton = new JButton(new StartStopAction(this.tm.getPrefs(), true));
        activateButton.setOpaque(false);
        this.add((Component)activateButton, c);
        JButton desactivateButton = new JButton(new StartStopAction(this.tm.getPrefs(), false));
        desactivateButton.setOpaque(false);
        ++c.gridy;
        this.add((Component)desactivateButton, c);
        c.insets = new Insets(20, 3, 2, 2);
        JButton uninstallButton = new JButton(new AbstractAction("D\u00e9sinstaller"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleManager mngr = ModuleManager.getInstance();
                Collection<ModuleFactory> checkedRows = InstalledModulesPanel.this.tm.getCheckedRows();
                int answer = JOptionPane.showConfirmDialog(InstalledModulesPanel.this, "\u00cates-vous s\u00fbr de vouloir d\u00e9sinstaller ces modules ?\nToutes les donn\u00e9es seront irr\u00e9m\u00e9diablement effac\u00e9es.", "D\u00e9sinstallation de modules", 0, 2);
                if (answer == 1) {
                    return;
                }
                try {
                    int selectAnswer;
                    HashSet<String> ids = new HashSet<String>();
                    for (ModuleFactory f : checkedRows) {
                        ids.add(f.getID());
                    }
                    Set<String> dependentModules = mngr.getDependentModulesRecursively(ids);
                    if (!dependentModules.isEmpty() && (selectAnswer = JOptionPane.showConfirmDialog(InstalledModulesPanel.this, "Des modules non s\u00e9lectionn\u00e9s ont besoin de la s\u00e9lection : " + dependentModules + ".\nVoulez-vous \u00e9galement d\u00e9sinstaller ces modules ?", "D\u00e9sinstallation de modules", 0, 2)) == 1) {
                        return;
                    }
                    mngr.uninstall(ids, true);
                }
                catch (Exception e) {
                    ExceptionHandler.handle(InstalledModulesPanel.this, "Impossible de d\u00e9sinstaller les modules", e);
                }
                moduleFrame.reload();
            }
        });
        uninstallButton.setOpaque(false);
        ++c.gridy;
        this.add((Component)uninstallButton, c);
        JPanel space = new JPanel();
        space.setOpaque(false);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)space, c);
    }

    public final void reload() {
        this.tm.reload();
    }

    private final class StartStopAction
    extends AbstractAction {
        private final Preferences reqPrefs;
        private final boolean start;

        public StartStopAction(Preferences reqPrefs, boolean start) {
            super(start ? "Activer" : "D\u00e9sactiver");
            this.reqPrefs = reqPrefs;
            this.start = start;
            this.putValue("ShortDescription", start ? "D\u00e9marrer le(s) module(s), maintenir CTRL pour rendre obligatoire le d\u00e9marrage" : "Arr\u00eate le(s) module(s), maintenir CTRL pour rendre facultatif le d\u00e9marrage");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ModuleManager mngr = ModuleManager.getInstance();
            Collection<ModuleFactory> checkedRows = InstalledModulesPanel.this.tm.getCheckedRows();
            try {
                for (ModuleFactory f : checkedRows) {
                    boolean changeRequired;
                    if (this.start) {
                        mngr.startModule(f.getID(), true);
                    } else {
                        mngr.stopModuleRecursively(f.getID());
                    }
                    boolean bl = changeRequired = (evt.getModifiers() & 2) != 0;
                    if (!changeRequired) continue;
                    if (this.start) {
                        this.reqPrefs.put(f.getID(), "");
                        continue;
                    }
                    this.reqPrefs.remove(f.getID());
                }
                this.reqPrefs.sync();
            }
            catch (Exception e) {
                ExceptionHandler.handle(InstalledModulesPanel.this, "Impossible " + (this.start ? "d'activer" : "de d\u00e9sactiver") + " les modules", e);
            }
            InstalledModulesPanel.this.reload();
        }
    }
}

