/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.importer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.importer.RowValuesNavigatorMainPanel;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class RowValuesNavigatorPanel
extends JPanel
implements ActionListener {
    private JTabbedPane tabbedPane;
    private List<SQLRowValues> updateList = Collections.EMPTY_LIST;
    private List<SQLRowValues> insertList = Collections.EMPTY_LIST;
    private JProgressBar pBar;
    private JButton bImport;
    private JLabel pLabel = new JLabel("Pr\u00eat \u00e0 importer");
    final JLabel lNothing = new JLabel("  Pas de donn\u00e9es \u00e0 importer");
    int c = 0;

    public RowValuesNavigatorPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setMinimumSize(new Dimension(480, 640));
        this.tabbedPane.setPreferredSize(new Dimension(480, 640));
        this.tabbedPane.add("Donn\u00e9es \u00e0 importer", this.lNothing);
        this.add((Component)this.tabbedPane, c);
        c.gridwidth = 1;
        ++c.gridy;
        this.pBar = new JProgressBar();
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)this.pBar, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.pLabel.setMinimumSize(this.pLabel.getPreferredSize());
        this.add((Component)this.pLabel, c);
        ++c.gridx;
        this.bImport = new JButton("Importer les donn\u00e9es");
        this.bImport.addActionListener(this);
        this.add((Component)this.bImport, c);
    }

    public void setRowValuesToUpdate(List<SQLRowValues> list) {
        this.updateList = list;
        if (list.size() > 0) {
            this.tabbedPane.remove(this.lNothing);
            this.tabbedPane.add("Lignes \u00e0 modifier", new RowValuesNavigatorMainPanel(list));
        }
    }

    public void setRowValuesToInsert(List<SQLRowValues> list) {
        this.insertList = list;
        if (list.size() > 0) {
            this.tabbedPane.remove(this.lNothing);
            this.tabbedPane.add("Lignes \u00e0 ajouter", new RowValuesNavigatorMainPanel(list));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pBar.setMinimum(0);
        final int size = this.insertList.size() + this.updateList.size();
        this.pBar.setMaximum(size);
        this.bImport.setEnabled(false);
        Thread t = new Thread("Importer"){

            @Override
            public void run() {
                RowValuesNavigatorPanel.this.c = 0;
                try {
                    for (SQLRowValues row : RowValuesNavigatorPanel.this.insertList) {
                        row.insert();
                        this.updateBar();
                    }
                    for (SQLRowValues row : RowValuesNavigatorPanel.this.updateList) {
                        row.update();
                        this.updateBar();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowValuesNavigatorPanel.this.pBar.setValue(RowValuesNavigatorPanel.this.pBar.getMaximum());
                            RowValuesNavigatorPanel.this.pLabel.setText("Import termin\u00e9");
                        }
                    });
                    JOptionPane.showMessageDialog(RowValuesNavigatorPanel.this, "Import termin\u00e9");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(RowValuesNavigatorPanel.this, "Erreur pendant l'importation");
                }
            }

            private void updateBar() {
                ++RowValuesNavigatorPanel.this.c;
                if (RowValuesNavigatorPanel.this.c % 5 == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowValuesNavigatorPanel.this.pBar.setValue((this).RowValuesNavigatorPanel.this.c);
                            RowValuesNavigatorPanel.this.pLabel.setText(String.valueOf((this).RowValuesNavigatorPanel.this.c + 1) + "/" + size);
                        }
                    });
                }
            }
        };
        t.start();
    }
}

