/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.importer;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.importer.RowValuesPanel;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class RowValuesNavigatorMainPanel
extends JPanel
implements ActionListener {
    private List<SQLRowValues> list;
    private int currentIndex = -1;
    private GridBagConstraints pConstraint;
    JPanel currentPanel;
    JButton bFirst = new JButton("<<");
    JButton bPrevious = new JButton("<");
    JButton bNext = new JButton(">");
    JButton bLast = new JButton(">>");
    private JTextField indexText;

    public RowValuesNavigatorMainPanel(List<SQLRowValues> list) {
        this.setOpaque(false);
        this.list = list;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        buttons.setLayout(new FlowLayout());
        buttons.add(this.bFirst);
        buttons.add(this.bPrevious);
        buttons.add(this.bNext);
        buttons.add(this.bLast);
        this.indexText = new JTextField(6);
        this.indexText.setText("1");
        buttons.add(this.indexText);
        buttons.add(new JLabel(" / " + list.size()));
        this.add((Component)buttons, c);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        ++c.gridy;
        this.pConstraint = (GridBagConstraints)c.clone();
        this.currentPanel = new JPanel();
        this.add((Component)this.currentPanel, c);
        this.setCurrentIndex(0);
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)spacer, c);
        this.bFirst.setOpaque(false);
        this.bPrevious.setOpaque(false);
        this.bNext.setOpaque(false);
        this.bLast.setOpaque(false);
        this.bFirst.addActionListener(this);
        this.bPrevious.addActionListener(this);
        this.bNext.addActionListener(this);
        this.bLast.addActionListener(this);
    }

    private void setCurrentIndex(int i) {
        if (this.currentIndex == i) {
            return;
        }
        this.indexText.setText(String.valueOf(i + 1));
        this.currentIndex = i;
        this.remove(this.currentPanel);
        RowValuesPanel p = new RowValuesPanel(this.list.get(i));
        p.setOpaque(false);
        this.invalidate();
        this.currentPanel = p;
        this.add((Component)this.currentPanel, this.pConstraint);
        this.revalidate();
        this.repaint();
        this.bFirst.setEnabled(this.currentIndex > 0);
        this.bPrevious.setEnabled(this.currentIndex > 0);
        this.bNext.setEnabled(this.currentIndex < this.list.size() - 1);
        this.bLast.setEnabled(this.currentIndex < this.list.size() - 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.bFirst)) {
            this.setCurrentIndex(0);
        }
        if (e.getSource().equals(this.bPrevious)) {
            this.setCurrentIndex(this.currentIndex - 1);
        }
        if (e.getSource().equals(this.bNext)) {
            this.setCurrentIndex(this.currentIndex + 1);
        }
        if (e.getSource().equals(this.bLast)) {
            this.setCurrentIndex(this.list.size() - 1);
        }
    }
}

