/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.graph;

import java.util.Calendar;
import java.util.Date;
import org.jopenchart.DataModel1D;
import org.jopenchart.barchart.VerticalBarChart;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.RTInterruptedException;

public class MargeDayDataModel
extends DataModel1D {
    private VerticalBarChart chart;
    private Thread thread;
    private int size = 31;
    private int year;

    public MargeDayDataModel(VerticalBarChart chart, int year, int month) {
        this.chart = chart;
        this.loadYear(year, month);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public synchronized void loadYear(Object value, final int month) {
        if (!(value instanceof Number)) {
            return;
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.year = ((Number)value).intValue();
        this.thread = new Thread(){

            @Override
            public void run() {
                MargeDayDataModel.this.setState(0);
                MargeDayDataModel.this.clear();
                MargeDayDataModel.this.fireDataModelChanged();
                Calendar cal = Calendar.getInstance();
                cal.set(MargeDayDataModel.this.year, month, 1);
                MargeDayDataModel.this.size = cal.getMaximum(5);
                try {
                    int i = 0;
                    while (i < MargeDayDataModel.this.size) {
                        float value;
                        if (this.isInterrupted()) break;
                        Calendar c = cal;
                        c.set(MargeDayDataModel.this.year, month, i);
                        Date d1 = new Date(c.getTimeInMillis());
                        Date d2 = new Date(c.getTimeInMillis());
                        Thread.yield();
                        SQLElementDirectory directory = Configuration.getInstance().getDirectory();
                        SQLTable tableSaisieVenteF = directory.getElement("SAISIE_VENTE_FACTURE").getTable();
                        SQLTable tableSaisieVenteFElt = directory.getElement("SAISIE_VENTE_FACTURE_ELEMENT").getTable();
                        SQLSelect sel = new SQLSelect(tableSaisieVenteF.getBase());
                        sel.addSelect(tableSaisieVenteFElt.getField("T_PA_HT"), "SUM");
                        sel.addSelect(tableSaisieVenteFElt.getField("T_PV_HT"), "SUM");
                        Where w = new Where((FieldRef)tableSaisieVenteF.getField("DATE"), d1, (Object)d2);
                        Where w2 = new Where((FieldRef)tableSaisieVenteFElt.getField("ID_SAISIE_VENTE_FACTURE"), "=", tableSaisieVenteF.getKey());
                        sel.setWhere(w.and(w2));
                        long total = 0L;
                        Object[] o = tableSaisieVenteF.getBase().getDataSource().executeA1(sel.asString());
                        if (o != null && o[0] != null && o[1] != null && (Long.valueOf(o[0].toString()) != 0L || Long.valueOf(o[1].toString()) != 0L)) {
                            long ha = Long.valueOf(o[0].toString());
                            long vt = Long.valueOf(o[1].toString());
                            total = vt - ha;
                        }
                        if ((value = (float)(total / 100L)) > MargeDayDataModel.this.chart.getHigherRange().floatValue()) {
                            long euros = (long)value;
                            String currencyToString = GestionDevise.currencyToString(euros * 100L, true);
                            MargeDayDataModel.this.chart.getLeftAxis().getLabels().get(2).setLabel(String.valueOf(currencyToString.substring(0, currencyToString.length() - 3)) + " \u20ac");
                            currencyToString = GestionDevise.currencyToString(euros * 100L / 2L, true);
                            MargeDayDataModel.this.chart.getLeftAxis().getLabels().get(1).setLabel(String.valueOf(currencyToString.substring(0, currencyToString.length() - 3)) + " \u20ac");
                            MargeDayDataModel.this.chart.setHigherRange(Float.valueOf(value));
                        }
                        if ((int)value != 0) {
                            MargeDayDataModel.this.setValueAt(i, Float.valueOf(value));
                            MargeDayDataModel.this.fireDataModelChanged();
                            Thread.sleep(20L);
                        }
                        ++i;
                    }
                    if (!this.isInterrupted()) {
                        MargeDayDataModel.this.setState(1);
                        MargeDayDataModel.this.fireDataModelChanged();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (RTInterruptedException rTInterruptedException) {
                    // empty catch block
                }
            }
        };
        this.thread.setPriority(1);
        this.thread.start();
    }

    public int getYear() {
        return this.year;
    }
}

