/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jopenchart.Axis;
import org.jopenchart.AxisLabel;
import org.jopenchart.ChartPanel;
import org.jopenchart.barchart.VerticalGroupBarChart;
import org.openconcerto.erp.graph.CADataModel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class GraphCAPanel
extends JPanel
implements ChangeListener {
    private final JSpinner s1 = new JSpinner();
    private final JSpinner s2 = new JSpinner();
    private final JSpinner s3 = new JSpinner();
    private CADataModel model1;
    private CADataModel model2;
    private CADataModel model3;

    public GraphCAPanel() {
        int year = Calendar.getInstance().get(1);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.decode("#4A79A5"));
        colors.add(Color.decode("#639ACE"));
        colors.add(Color.decode("#94BAE7"));
        Axis axisY = new Axis("y");
        axisY.addLabel(new AxisLabel("0"));
        axisY.addLabel(new AxisLabel("500 \u20ac"));
        axisY.addLabel(new AxisLabel("1000 \u20ac"));
        final Axis axisX = new Axis("x");
        axisX.addLabel(new AxisLabel("Janvier", 1));
        axisX.addLabel(new AxisLabel("F\u00e9vrier", 2));
        axisX.addLabel(new AxisLabel("Mars", 3));
        axisX.addLabel(new AxisLabel("Avril", 4));
        axisX.addLabel(new AxisLabel("Mai", 5));
        axisX.addLabel(new AxisLabel("Juin", 6));
        axisX.addLabel(new AxisLabel("Juillet", 7));
        axisX.addLabel(new AxisLabel("Ao\u00fbt", 8));
        axisX.addLabel(new AxisLabel("Septembre", 9));
        axisX.addLabel(new AxisLabel("Octobre", 10));
        axisX.addLabel(new AxisLabel("Novembre", 11));
        axisX.addLabel(new AxisLabel("D\u00e9cembre", 12));
        final VerticalGroupBarChart chart = new VerticalGroupBarChart();
        chart.setBottomAxis(axisX);
        chart.setLeftAxis(axisY);
        chart.setBarWidth(14);
        chart.setColors(colors);
        chart.setDimension(new Dimension(800, 400));
        this.model1 = new CADataModel(chart, year - 2);
        chart.addModel(this.model1);
        this.model2 = new CADataModel(chart, year - 1);
        chart.addModel(this.model2);
        this.model3 = new CADataModel(chart, year);
        chart.addModel(this.model3);
        chart.setLowerRange(0);
        chart.setHigherRange(1000);
        ++c.gridy;
        ChartPanel panel = new ChartPanel(chart){

            @Override
            public String getToolTipTextFrom(Number n) {
                if (n == null) {
                    return null;
                }
                CADataModel m = (CADataModel)chart.getHighlight().getModel();
                return String.valueOf(axisX.getLabels().get(chart.getHighlight().getIndexOnModel()).getLabel()) + " " + m.getYear() + ": " + n.longValue() + " \u20ac";
            }
        };
        this.add((Component)panel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        this.add((Component)new JSeparator(0), c);
        this.s1.setValue(year - 2);
        this.s2.setValue(year - 1);
        this.s3.setValue(year);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 5, 5));
        p1.add(new JLabel("Ann\u00e9es: "));
        p1.add(this.createColorPanel((Color)colors.get(0)));
        p1.add(this.s1);
        p1.add(this.createSpacer());
        p1.add(this.createColorPanel((Color)colors.get(1)));
        p1.add(this.s2);
        p1.add(this.createSpacer());
        p1.add(this.createColorPanel((Color)colors.get(2)));
        p1.add(this.s3);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 18;
        this.add((Component)p1, c);
        this.s1.addChangeListener(this);
        this.s2.addChangeListener(this);
        this.s3.addChangeListener(this);
    }

    private Component createColorPanel(Color color) {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        p.setMinimumSize(new Dimension(40, 16));
        p.setPreferredSize(new Dimension(40, 16));
        p.setOpaque(true);
        p.setBackground(color);
        return p;
    }

    private Component createSpacer() {
        JPanel p = new JPanel();
        p.setMinimumSize(new Dimension(16, 16));
        p.setPreferredSize(new Dimension(16, 16));
        p.setOpaque(false);
        return p;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.s1) {
            this.model1.loadYear(this.s1.getValue());
        } else if (e.getSource() == this.s2) {
            this.model2.loadYear(this.s2.getValue());
        } else if (e.getSource() == this.s3) {
            this.model3.loadYear(this.s3.getValue());
        }
    }
}

