/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationReglementVente
extends GenerationEcritures {
    private static final Integer journalCaisse = 5;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationReglementVente(int idEncaisseRegl) {
        SQLRow encaisseMontantRow = base.getTable("ENCAISSER_MONTANT").getRow(idEncaisseRegl);
        int idEchCli = encaisseMontantRow.getInt("ID_ECHEANCE_CLIENT");
        SQLRow modeRegRow = base.getTable("MODE_REGLEMENT").getRow(encaisseMontantRow.getInt("ID_MODE_REGLEMENT"));
        SQLRow typeRegRow = base.getTable("TYPE_REGLEMENT").getRow(modeRegRow.getInt("ID_TYPE_REGLEMENT"));
        PrixTTC prixTTC = new PrixTTC((Long)encaisseMontantRow.getObject("MONTANT"));
        this.date = (Date)encaisseMontantRow.getObject("DATE");
        String s = encaisseMontantRow.getString("NOM");
        this.nom = "R\u00e8glement vente " + (s == null ? "" : s) + " (" + typeRegRow.getString("NOM") + ")";
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", 4);
        this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        if (modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(this.date, idEncaisseRegl);
            } else {
                this.setDateReglement(idEncaisseRegl, idEchCli, this.date);
                if (typeRegRow.getID() == 4) {
                    this.mEcritures.put("ID_JOURNAL", journalCaisse);
                }
                SQLRow echeanceRow = null;
                int idCompteClient = -1;
                if (idEchCli > 1) {
                    echeanceRow = base.getTable("ECHEANCE_CLIENT").getRow(idEchCli);
                    SQLRow clientRow = base.getTable("CLIENT").getRow(echeanceRow.getInt("ID_CLIENT"));
                    idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
                    SQLRow rowMvt = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
                    this.idMvt = this.getNewMouvement("ENCAISSER_MONTANT", idEncaisseRegl, rowMvt.getID(), rowMvt.getInt("ID_PIECE"));
                } else {
                    this.idMvt = this.getNewMouvement("ENCAISSER_MONTANT", idEncaisseRegl, 1, "");
                }
                if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                    try {
                        idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
                    this.mEcritures.put("DEBIT", 0L);
                    this.mEcritures.put("CREDIT", prixTTC.getLongValue());
                    this.ajoutEcriture();
                    int idCompteRegl = typeRegRow.getInt("ID_COMPTE_PCE_CLIENT");
                    if (idCompteRegl <= 1) {
                        try {
                            idCompteRegl = ComptePCESQLElement.getIdComptePceDefault("VenteCB");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteRegl);
                    this.mEcritures.put("DEBIT", prixTTC.getLongValue());
                    this.mEcritures.put("CREDIT", 0L);
                    this.ajoutEcriture();
                }
                catch (IllegalArgumentException e) {
                    ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
                    e.printStackTrace();
                }
            }
        } else {
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(dateEch, idEncaisseRegl);
            } else {
                System.out.println("Ech\u00e9ance client");
                SQLRowValues valEcheance = new SQLRowValues(base.getTable("ECHEANCE_CLIENT"));
                SQLRow echeanceRow = base.getTable("ECHEANCE_CLIENT").getRow(idEchCli);
                SQLRow rowMouv = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
                this.idMvt = this.getNewMouvement("ECHEANCE_CLIENT", 1, rowMouv.getID(), rowMouv.getInt("ID_PIECE"));
                valEcheance.put("ID_MOUVEMENT", (Object)this.idMvt);
                valEcheance.put("DATE", dateEch);
                valEcheance.put("MONTANT", prixTTC.getLongValue());
                if (idEchCli > 1) {
                    valEcheance.put("ID_CLIENT", (Object)echeanceRow.getInt("ID_CLIENT"));
                }
                try {
                    if (valEcheance.getInvalid() == null) {
                        SQLRow row = valEcheance.insert();
                        SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                        rowVals.put("IDSOURCE", row.getID());
                        rowVals.update(this.idMvt);
                    }
                }
                catch (SQLException e) {
                    System.err.println("Error insert in Table " + valEcheance.getTable().getName());
                }
            }
        }
    }

    private void setDateReglement(int idEncaisseRegl, int idEchCli, Date d) {
        if (idEchCli > 1) {
            SQLRow echeanceRow = Configuration.getInstance().getBase().getTable("ECHEANCE_CLIENT").getRow(idEchCli);
            SQLRow encaisseRow = Configuration.getInstance().getBase().getTable("ENCAISSER_MONTANT").getRow(idEncaisseRegl);
            long montant = (Long)encaisseRow.getObject("MONTANT");
            if (montant >= (Long)echeanceRow.getObject("MONTANT")) {
                int sourceId = MouvementSQLElement.getSourceId(echeanceRow.getInt("ID_MOUVEMENT"));
                SQLRow rowMvt = Configuration.getInstance().getBase().getTable("MOUVEMENT").getRow(sourceId);
                if (rowMvt.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                    SQLElement eltFacture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                    SQLRow saisieRow = eltFacture.getTable().getRow(rowMvt.getInt("IDSOURCE"));
                    SQLRowValues rowValsUpdateVF = saisieRow.createEmptyUpdateRow();
                    rowValsUpdateVF.put("DATE_REGLEMENT", new Timestamp(d.getTime()));
                    try {
                        rowValsUpdateVF.update();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private void paiementCheque(Date dateEch, int idEncaisseRegl) {
        SQLRow encaisseMontantRow = base.getTable("ENCAISSER_MONTANT").getRow(idEncaisseRegl);
        int idEchCli = encaisseMontantRow.getInt("ID_ECHEANCE_CLIENT");
        SQLRow echeanceRow = base.getTable("ECHEANCE_CLIENT").getRow(idEchCli);
        PrixTTC prixTTC = new PrixTTC((Long)encaisseMontantRow.getObject("MONTANT"));
        SQLRowValues valCheque = new SQLRowValues(base.getTable("CHEQUE_A_ENCAISSER"));
        if (idEchCli > 1) {
            valCheque.put("ID_CLIENT", (Object)echeanceRow.getInt("ID_CLIENT"));
        }
        valCheque.put("DATE_VENTE", this.date);
        SQLRow rowMvtPere = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
        this.idMvt = this.getNewMouvement("CHEQUE_A_ENCAISSER", 1, rowMvtPere.getID(), rowMvtPere.getInt("ID_PIECE"));
        valCheque.put("DATE_MIN_DEPOT", dateEch);
        valCheque.put("ID_MOUVEMENT", (Object)this.idMvt);
        valCheque.put("MONTANT", prixTTC.getLongValue());
        try {
            if (valCheque.getInvalid() == null) {
                SQLRow row = valCheque.insert();
                SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                rowVals.put("IDSOURCE", row.getID());
                rowVals.update(this.idMvt);
            }
        }
        catch (SQLException e) {
            System.err.println("Error insert in Table " + valCheque.getTable().getName());
            ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du ch\u00e9que.");
        }
    }
}

