/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ChequeAEncaisserSQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtReglementVenteComptoir
extends GenerationEcritures
implements Runnable {
    private int idSaisieVenteComptoir;
    private static final Integer journalCaisse = new Integer(5);
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private int idPere = 1;

    @Override
    public void run() {
        System.out.println("g\u00e9n\u00e9ration des ecritures de r\u00e8glement vente comptoir");
        SQLRow saisieRow = base.getTable("SAISIE_VENTE_COMPTOIR").getRow(this.idSaisieVenteComptoir);
        SQLRow clientRow = base.getTable("CLIENT").getRow(saisieRow.getInt("ID_CLIENT"));
        SQLRow modeRegRow = base.getTable("MODE_REGLEMENT").getRow(saisieRow.getInt("ID_MODE_REGLEMENT"));
        SQLRow typeRegRow = base.getTable("TYPE_REGLEMENT").getRow(modeRegRow.getInt("ID_TYPE_REGLEMENT"));
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("MONTANT_TTC"));
        this.date = (Date)saisieRow.getObject("DATE");
        String string = "Vente comptoir ";
        String rowLib = saisieRow.getObject("NOM").toString();
        string = rowLib != null && rowLib.trim().length() > 0 ? String.valueOf(string) + rowLib.trim() : String.valueOf(string) + saisieRow.getForeignRow("ID_ARTICLE").getString("NOM");
        this.nom = String.valueOf(string) + " (" + typeRegRow.getString("NOM") + ")";
        if (modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(this.date);
            } else {
                this.idMvt = this.idPere;
                this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
                this.mEcritures.put("NOM", this.nom);
                this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
                if (typeRegRow.getID() == 4) {
                    this.mEcritures.put("ID_JOURNAL", journalCaisse);
                } else {
                    this.mEcritures.put("ID_JOURNAL", 4);
                }
                int idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
                if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                    try {
                        idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteClient));
                    this.mEcritures.put("DEBIT", new Long(0L));
                    this.mEcritures.put("CREDIT", new Long(prixTTC.getLongValue()));
                    this.ajoutEcriture();
                    int idCompteRegl = typeRegRow.getInt("ID_COMPTE_PCE_CLIENT");
                    if (idCompteRegl <= 1) {
                        try {
                            idCompteRegl = ComptePCESQLElement.getIdComptePceDefault("VenteCB");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteRegl));
                    this.mEcritures.put("DEBIT", new Long(prixTTC.getLongValue()));
                    this.mEcritures.put("CREDIT", new Long(0L));
                    this.ajoutEcriture();
                }
                catch (IllegalArgumentException e) {
                    ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
                    e.printStackTrace();
                }
            }
        } else {
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(dateEch);
            } else {
                System.err.println("Ech\u00e9ance client");
                SQLTable tableEchCli = base.getTable("ECHEANCE_CLIENT");
                SQLRowValues valEcheance = new SQLRowValues(tableEchCli);
                SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
                this.idMvt = this.getNewMouvement("ECHEANCE_CLIENT", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
                valEcheance.put("ID_MOUVEMENT", new Integer(this.idMvt));
                valEcheance.put("DATE", new java.sql.Date(dateEch.getTime()));
                valEcheance.put("MONTANT", new Long(prixTTC.getLongValue()));
                valEcheance.put("ID_CLIENT", new Integer(saisieRow.getInt("ID_CLIENT")));
                try {
                    if (valEcheance.getInvalid() == null) {
                        SQLRow row = valEcheance.insert();
                        SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                        rowVals.put("IDSOURCE", row.getID());
                        rowVals.update(this.idMvt);
                    }
                }
                catch (SQLException e) {
                    System.err.println("Error insert in Table " + valEcheance.getTable().getName());
                    e.printStackTrace();
                }
            }
        }
    }

    private void paiementCheque(Date dateEch) {
        SQLRow saisieRow = base.getTable("SAISIE_VENTE_COMPTOIR").getRow(this.idSaisieVenteComptoir);
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("MONTANT_TTC"));
        ChequeAEncaisserSQLElement chqAEncaisserElt = (ChequeAEncaisserSQLElement)Configuration.getInstance().getDirectory().getElement("CHEQUE_A_ENCAISSER");
        SQLRowValues valEncaisse = new SQLRowValues(chqAEncaisserElt.getTable());
        valEncaisse.put("ID_CLIENT", new Integer(saisieRow.getInt("ID_CLIENT")));
        valEncaisse.put("DATE_VENTE", new java.sql.Date(this.date.getTime()));
        valEncaisse.put("DATE_MIN_DEPOT", new java.sql.Date(dateEch.getTime()));
        valEncaisse.put("DATE_DEPOT", new java.sql.Date(this.date.getTime()));
        valEncaisse.put("MONTANT", new Long(prixTTC.getLongValue()));
        SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
        this.idMvt = this.getNewMouvement("CHEQUE_A_ENCAISSER", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
        valEncaisse.put("ID_MOUVEMENT", new Integer(this.idMvt));
        try {
            if (valEncaisse.getInvalid() == null) {
                SQLRow row = valEncaisse.insert();
                SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                rowVals.put("IDSOURCE", row.getID());
                rowVals.update(this.idMvt);
            }
        }
        catch (SQLException e) {
            System.err.println("Error insert in Table " + valEncaisse.getTable().getName());
            e.printStackTrace();
        }
    }

    public GenerationMvtReglementVenteComptoir(int idSaisieVenteComptoir, int idMvt) {
        this.idPere = idMvt;
        this.idSaisieVenteComptoir = idSaisieVenteComptoir;
        new Thread(this).start();
    }
}

