/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtReglementChequeClient
extends GenerationEcritures {
    private long montant;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private int idCheque;

    public void genere() {
        System.err.println("g\u00e9n\u00e9ration des ecritures de r\u00e8glement d'un cheque client du mouvement " + this.idMvt);
        SQLRow chequeRow = base.getTable("CHEQUE_A_ENCAISSER").getRow(this.idCheque);
        SQLRow clientRow = base.getTable("CLIENT").getRow(chequeRow.getInt("ID_CLIENT"));
        this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", 4);
        this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
        this.setDateReglement(this.idCheque, this.date);
        int idCompteClient = -1;
        if (clientRow != null) {
            idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
        }
        if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
            try {
                idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            int idPce = base.getTable("TYPE_REGLEMENT").getRow(2).getInt("ID_COMPTE_PCE_CLIENT");
            if (idPce <= 1) {
                try {
                    idPce = ComptePCESQLElement.getIdComptePceDefault("VenteCheque");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteClient));
            this.mEcritures.put("DEBIT", new Long(0L));
            this.mEcritures.put("CREDIT", new Long(this.montant));
            this.ajoutEcriture();
            System.err.println("First ECriture for mvt " + this.idMvt);
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idPce));
            this.mEcritures.put("DEBIT", new Long(this.montant));
            this.mEcritures.put("CREDIT", new Long(0L));
            this.ajoutEcriture();
            System.err.println("Ecritures g\u00e9n\u00e9r\u00e9es pour le mouvement " + this.idMvt);
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }

    private void setDateReglement(int idCheque, Date d) {
        if (idCheque > 1) {
            SQLRow chequeRow = Configuration.getInstance().getBase().getTable("CHEQUE_A_ENCAISSER").getRow(idCheque);
            int sourceId = MouvementSQLElement.getSourceId(chequeRow.getInt("ID_MOUVEMENT"));
            SQLRow rowMvt = Configuration.getInstance().getBase().getTable("MOUVEMENT").getRow(sourceId);
            if (rowMvt.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                SQLElement eltFacture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                SQLRow saisieRow = eltFacture.getTable().getRow(rowMvt.getInt("IDSOURCE"));
                SQLRowValues rowValsUpdateVF = saisieRow.createEmptyUpdateRow();
                rowValsUpdateVF.put("DATE_REGLEMENT", new Timestamp(d.getTime()));
                try {
                    rowValsUpdateVF.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public GenerationMvtReglementChequeClient(int idMvt, long montant, Date d, int idCheque, String s) {
        this.montant = montant;
        this.date = d;
        this.idMvt = idMvt;
        this.idCheque = idCheque;
        this.nom = s != null && s.trim().length() > 0 ? s : "Reglement cheque client";
    }
}

