/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class PointageXmlSheet
extends AbstractListeSheetXml {
    public static final String TEMPLATE_ID = "Pointage";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private Map<Integer, List<Map<String, Object>>> listAllSheetValues;
    private Map<Integer, Map<Integer, String>> styleAllSheetValues;
    private Map<Integer, Map<String, Object>> mapAllSheetValues;
    private Calendar c = Calendar.getInstance();
    private Date date = new Date();
    private final long MILLIS_IN_HOUR = 3600000L;

    public PointageXmlSheet(int mois, int year) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.mapAllSheetValues = new HashMap<Integer, Map<String, Object>>();
        this.c.set(5, 1);
        this.c.set(1, year);
        this.c.set(2, mois);
        this.c.set(11, 0);
        this.c.set(12, 0);
        this.c.set(13, 0);
        this.c.set(14, 1);
    }

    @Override
    public String getName() {
        return TEMPLATE_ID + this.date;
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected void createListeValues() {
        SQLElement eltPointage = Configuration.getInstance().getDirectory().getElement("POINTAGE");
        SQLElement eltUser = Configuration.getInstance().getDirectory().getElement("USER_COMMON");
        int user = 0;
        int actualMaximum = this.c.getActualMaximum(5);
        this.listAllSheetValues = new HashMap<Integer, List<Map<String, Object>>>();
        this.styleAllSheetValues = new HashMap<Integer, Map<Integer, String>>();
        SimpleDateFormat format = new SimpleDateFormat("EEEE dd MMMM");
        SimpleDateFormat formatMonth = new SimpleDateFormat("MMMM");
        SimpleDateFormat formatMonthYear = new SimpleDateFormat("MMMM yyyy");
        SimpleDateFormat formatHour = new SimpleDateFormat("HH:mm");
        Date d1 = this.c.getTime();
        Calendar endOfMonth = Calendar.getInstance();
        endOfMonth.setTime(d1);
        endOfMonth.set(5, this.c.getActualMaximum(5));
        endOfMonth.set(11, 23);
        endOfMonth.set(12, 59);
        endOfMonth.set(13, 59);
        endOfMonth.set(14, 59);
        Date d2 = endOfMonth.getTime();
        SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
        SQLTable tableUser = eltUser.getTable();
        AliasedTable tablePointage = new AliasedTable(eltPointage.getTable(), "POINTAGE");
        sel.addSelect(tableUser.getKey());
        sel.addSelect(tableUser.getField("NOM"));
        sel.addSelect(tableUser.getField("PRENOM"));
        sel.addSelect(tableUser.getField("HEURE_MATIN_A"));
        sel.addSelect(tableUser.getField("HEURE_MATIN_D"));
        sel.addSelect(tableUser.getField("MINUTE_MATIN_A"));
        sel.addSelect(tableUser.getField("MINUTE_MATIN_D"));
        sel.addSelect(tableUser.getField("HEURE_MIDI_A"));
        sel.addSelect(tableUser.getField("HEURE_MIDI_D"));
        sel.addSelect(tableUser.getField("MINUTE_MIDI_A"));
        sel.addSelect(tableUser.getField("MINUTE_MIDI_D"));
        Where w = new Where((FieldRef)tableUser.getField("ID"), "=", tablePointage.getField("ID_USER_COMMON"));
        w = w.and(new Where((FieldRef)tablePointage.getField("DATE"), d1, (Object)d2));
        sel.setWhere(w);
        sel.addGroupBy(tableUser.getKey());
        sel.addGroupBy(tableUser.getField("NOM"));
        sel.addGroupBy(tableUser.getField("PRENOM"));
        sel.addGroupBy(tableUser.getField("HEURE_MATIN_A"));
        sel.addGroupBy(tableUser.getField("HEURE_MATIN_D"));
        sel.addGroupBy(tableUser.getField("MINUTE_MATIN_A"));
        sel.addGroupBy(tableUser.getField("MINUTE_MATIN_D"));
        sel.addGroupBy(tableUser.getField("HEURE_MIDI_A"));
        sel.addGroupBy(tableUser.getField("HEURE_MIDI_D"));
        sel.addGroupBy(tableUser.getField("MINUTE_MIDI_A"));
        sel.addGroupBy(tableUser.getField("MINUTE_MIDI_D"));
        sel.setHaving(Where.createRaw("COUNT (\"POINTAGE\".\"ID_USER_COMMON\") > 0", tablePointage.getField("ID_USER_COMMON")));
        sel.addFieldOrder(tableUser.getField("NOM"));
        System.err.println(sel.asString());
        List listUser = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, tableUser));
        String entete = "Horaires de travail du mois de " + formatMonth.format(d1);
        String pied = "Total " + formatMonthYear.format(d1);
        for (SQLRow row : listUser) {
            int semaine = -1;
            String userName = String.valueOf(row.getString("NOM")) + " " + row.getString("PRENOM");
            this.sheetNames.add(userName);
            System.err.println(userName);
            HashMap<String, String> mapSheetValue = new HashMap<String, String>();
            mapSheetValue.put("A1", userName);
            mapSheetValue.put("F1", entete);
            long tempsDePause = 3600000L;
            if (row.getObject("HEURE_MATIN_D") != null && row.getObject("MINUTE_MATIN_D") != null && row.getObject("HEURE_MIDI_A") != null && row.getObject("MINUTE_MIDI_A") != null) {
                int heureD = row.getInt("HEURE_MATIN_D") * 60;
                int minuteD = row.getInt("MINUTE_MATIN_D");
                int heureA = row.getInt("HEURE_MIDI_A") * 60;
                int minuteA = row.getInt("MINUTE_MIDI_A");
                tempsDePause = (heureA + minuteA - heureD - minuteD) * 60000;
            }
            System.err.println("Temps de pause " + tempsDePause);
            long heureTotalSemaine = 0L;
            long heureTotalMois = 0L;
            ArrayList listValues = new ArrayList();
            HashMap<Integer, String> styleValues = new HashMap<Integer, String>();
            int error = 0;
            int i = 1;
            while (i <= actualMaximum) {
                HashMap<String, String> mValues = new HashMap<String, String>();
                this.c.set(5, i);
                if (semaine > 0 && semaine != this.c.get(3)) {
                    HashMap<String, String> mValues2 = new HashMap<String, String>();
                    long hour = heureTotalSemaine / 3600000L;
                    long minute = heureTotalSemaine % 3600000L / 60000L;
                    mValues2.put("HEURE_TOTAL", String.valueOf(hour) + "h" + minute);
                    heureTotalSemaine = 0L;
                    listValues.add(mValues2);
                    styleValues.put(listValues.size() - 1, "Titre 2");
                }
                semaine = this.c.get(3);
                mValues.put("JOUR", format.format(this.c.getTime()));
                this.c.set(11, 0);
                this.c.set(12, 0);
                this.c.set(13, 0);
                this.c.set(14, 1);
                Date debutJournee = this.c.getTime();
                this.c.set(11, 23);
                this.c.set(12, 59);
                this.c.set(13, 59);
                this.c.set(14, 59);
                Date finJournee = this.c.getTime();
                SQLSelect sel2 = new SQLSelect(Configuration.getInstance().getBase());
                SQLTable table2 = eltPointage.getTable();
                sel2.addSelectStar(table2);
                Where wDay = new Where((FieldRef)table2.getField("ID_USER_COMMON"), "=", row.getID());
                wDay = wDay.and(new Where((FieldRef)table2.getField("DATE"), debutJournee, (Object)finJournee));
                sel2.setWhere(wDay);
                sel2.addFieldOrder(table2.getField("DATE"));
                List list2 = (List)Configuration.getInstance().getBase().getDataSource().execute(sel2.asString(), SQLRowListRSH.createFromSelect(sel2, table2));
                if (list2.size() > 2) {
                    boolean dehors = true;
                    Calendar dateSortie = null;
                    long timeOut = 0L;
                    String heurePointe = "";
                    for (SQLRow rowPointage : list2) {
                        Calendar date = rowPointage.getDate("DATE");
                        date.set(13, 0);
                        date.set(14, 0);
                        if (dehors) {
                            if (dateSortie != null) {
                                System.err.println(String.valueOf(row.getString("PRENOM")) + "  " + (timeOut += date.getTimeInMillis() - dateSortie.getTimeInMillis()));
                            }
                            dehors = false;
                        } else {
                            dehors = true;
                            dateSortie = date;
                        }
                        heurePointe = String.valueOf(heurePointe) + formatHour.format(date.getTime()) + ", ";
                    }
                    if (list2.size() % 2 == 1) {
                        heurePointe = String.valueOf(heurePointe) + "Erreur de pointage";
                        ++error;
                    }
                    mValues.put("HEURE_POINTE", heurePointe);
                    timeOut = Math.max(timeOut, tempsDePause);
                    Calendar dateOutDay = ((SQLRow)list2.get(list2.size() - 1)).getDate("DATE");
                    dateOutDay.set(13, 0);
                    dateOutDay.set(14, 0);
                    Calendar dateInDay = ((SQLRow)list2.get(0)).getDate("DATE");
                    dateInDay.set(13, 0);
                    dateInDay.set(14, 0);
                    System.err.println("Date Out " + formatHour.format(dateOutDay.getTime()));
                    System.err.println("Date In " + formatHour.format(dateInDay.getTime()));
                    long time = dateOutDay.getTimeInMillis() - dateInDay.getTimeInMillis();
                    long timeWorked = time - timeOut;
                    if (time < timeOut) {
                        timeWorked = time;
                    }
                    System.err.println("time " + time + " Worked :" + timeWorked);
                    heureTotalSemaine += timeWorked;
                    heureTotalMois += timeWorked;
                    long hour = timeWorked / 3600000L;
                    long minute = timeWorked % 3600000L / 60000L;
                    mValues.put("HEURE_TOTAL", String.valueOf(hour) + "h" + minute);
                } else {
                    mValues.put("HEURE_TOTAL", "0h0");
                    if (list2.size() == 1) {
                        ++error;
                        SQLRow rowPointage = (SQLRow)list2.get(0);
                        Calendar date = rowPointage.getDate("DATE");
                        mValues.put("HEURE_POINTE", String.valueOf(formatHour.format(date.getTime())) + ", erreur de pointage");
                    }
                }
                listValues.add(mValues);
                styleValues.put(listValues.size() - 1, "Titre 1");
                ++i;
            }
            HashMap<String, String> mValues2 = new HashMap<String, String>();
            long hour = heureTotalSemaine / 3600000L;
            long minute = heureTotalSemaine % 3600000L / 60000L;
            mValues2.put("HEURE_TOTAL", String.valueOf(hour) + "h" + minute);
            heureTotalSemaine = 0L;
            listValues.add(mValues2);
            styleValues.put(listValues.size() - 1, "Titre 2");
            this.listAllSheetValues.put(user, listValues);
            this.styleAllSheetValues.put(user, styleValues);
            HashMap<String, String> mValuesMois = new HashMap<String, String>();
            hour = heureTotalMois / 3600000L;
            minute = heureTotalMois % 3600000L / 60000L;
            mValuesMois.put("HEURE_TOTAL", String.valueOf(hour) + "h" + minute);
            heureTotalMois = 0L;
            if (error > 0) {
                if (error == 1) {
                    mValuesMois.put("JOUR", String.valueOf(pied) + " dont une erreur de pointage");
                } else {
                    mValuesMois.put("JOUR", String.valueOf(pied) + " dont " + error + " erreurs de pointage");
                }
            } else {
                mValuesMois.put("JOUR", pied);
            }
            listValues.add(mValuesMois);
            styleValues.put(listValues.size() - 1, "Titre 3");
            this.listAllSheetValues.put(user, listValues);
            this.styleAllSheetValues.put(user, styleValues);
            this.mapAllSheetValues.put(user, mapSheetValue);
            ++user;
        }
    }
}

