/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationDoc.OOXMLElement;
import org.openconcerto.erp.generationDoc.OOXMLTableElement;
import org.openconcerto.erp.generationDoc.OOXMLTableField;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.StreamUtils;

public class OOgenerationXML {
    private static DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private static Map<Sheet, Map<String, Map<Integer, String>>> cacheStyle = new HashMap<Sheet, Map<String, Map<Integer, String>>>();
    private static Map<String, List<? extends SQLRowAccessor>> rowsEltCache = new HashMap<String, List<? extends SQLRowAccessor>>();
    private static int answer = 1;
    static Map<SQLRowAccessor, Map<String, Object>> taxe = new HashMap<SQLRowAccessor, Map<String, Object>>();
    private static Map<String, Map<Integer, SQLRowAccessor>> cacheForeign = new HashMap<String, Map<Integer, SQLRowAccessor>>();

    public static synchronized File createDocument(String templateId, File outputDirectory, final String expectedFileName, SQLRow row, SQLRow rowLanguage) {
        String langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
        cacheStyle.clear();
        OOXMLCache.clearCache();
        rowsEltCache.clear();
        taxe.clear();
        cacheForeign.clear();
        File fDest = new File(outputDirectory, expectedFileName);
        if (fDest.exists()) {
            if (SwingUtilities.isEventDispatchThread()) {
                answer = JOptionPane.showConfirmDialog(null, "Voulez vous reg\u00e9n\u00e9rer et \u00e9craser l'ancien document?", "G\u00e9n\u00e9ration du document", 0);
                Thread.dumpStack();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            answer = JOptionPane.showConfirmDialog(null, "Voulez vous reg\u00e9n\u00e9rer et \u00e9craser l'ancien document?", "G\u00e9n\u00e9ration du document", 0);
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (answer != 0) {
                return fDest;
            }
        }
        Date d = new Date();
        SAXBuilder builder = new SAXBuilder();
        try {
            if (OOgenerationXML.needAnnexe(templateId, row, rowLanguage)) {
                String annexeTemplateId = String.valueOf(templateId) + "_annexe";
                InputStream annexeStream = TemplateManager.getInstance().getTemplate(annexeTemplateId, langage, null);
                if (annexeStream != null) {
                    templateId = annexeTemplateId;
                    System.err.println("modele With annexe " + templateId);
                }
            }
            System.err.println("Using template id: " + templateId);
            InputStream xmlConfiguration = TemplateManager.getInstance().getTemplateConfiguration(templateId, langage, null);
            Document doc = builder.build(xmlConfiguration);
            Element racine = doc.getRootElement();
            List listElts = racine.getChildren("element");
            InputStream template = TemplateManager.getInstance().getTemplate(templateId, langage, null);
            SpreadSheet spreadSheet = new ODPackage(template).getSpreadSheet();
            try {
                OOgenerationXML.parseElementsXML(listElts, row, spreadSheet);
                List listTable = racine.getChildren("table");
                for (Element tableChild : listTable) {
                    OOgenerationXML.parseTableauXML(tableChild, row, spreadSheet, rowLanguage);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de remplir le document " + templateId + " " + (rowLanguage == null ? "" : rowLanguage.getString("CHEMIN")), e);
            }
            return OOgenerationXML.saveSpreadSheet(spreadSheet, outputDirectory, expectedFileName, templateId, rowLanguage);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration du fichier " + expectedFileName, e);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du fichier " + expectedFileName, e);
                }
            });
        }
        return null;
    }

    private static void parseTableauXML(Element tableau, SQLRow row, SpreadSheet spreadsheet, SQLRow rowLanguage) {
        if (tableau == null) {
            return;
        }
        String o = tableau.getAttributeValue("sheet");
        int idSheet = o == null ? 0 : Integer.valueOf(o.toString().trim());
        Sheet sheet = spreadsheet.getSheet(idSheet);
        String oLastColTmp = tableau.getAttributeValue("lastColumn");
        int lastColumn = -1;
        int endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        if (oLastColTmp != null) {
            lastColumn = sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)oLastColTmp.toString())).append((int)1).toString()).x + 1;
        }
        Map<String, Map<Integer, String>> mapStyle = OOgenerationXML.searchStyle(sheet, lastColumn, endPageLine);
        if (tableau.getAttributeValue("table").equalsIgnoreCase("TVA")) {
            OOgenerationXML.fillTaxe(tableau, sheet, mapStyle, false);
            return;
        }
        int nbPage = OOgenerationXML.fillTable(tableau, row, sheet, mapStyle, true, rowLanguage);
        int firstLine = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        int endLine = Integer.valueOf(tableau.getAttributeValue("endLine"));
        Object printRangeObj = sheet.getPrintRanges();
        System.err.println("Nombre de page == " + nbPage);
        if (nbPage == 1) {
            OOgenerationXML.fillTable(tableau, row, sheet, mapStyle, false, rowLanguage);
        } else {
            String pageRef;
            if (printRangeObj != null) {
                String s = printRangeObj.toString();
                String[] range = s.split(":");
                int i = 0;
                while (i < range.length) {
                    String string = range[i];
                    range[i] = string.subSequence(string.indexOf(46) + 1, string.length()).toString();
                    ++i;
                }
                int rowEnd = -1;
                if (range.length > 1) {
                    rowEnd = sheet.resolveHint((String)range[1]).y + 1;
                    int rowEndNew = rowEnd * nbPage;
                    String sNew = s.replaceAll(String.valueOf(rowEnd), String.valueOf(rowEndNew));
                    sheet.setPrintRanges(sNew);
                    System.err.println(" ******  Replace print ranges; Old:" + rowEnd + "--" + s + " New:" + rowEndNew + "--" + sNew);
                }
            }
            sheet.duplicateFirstRows(endLine, 1);
            int lineToAdd = endPageLine - endLine;
            String repeatedCount = tableau.getAttributeValue("repeatedCount");
            if (repeatedCount != null && repeatedCount.trim().length() > 0) {
                int count = Integer.valueOf(repeatedCount);
                sheet.duplicateRows(firstLine, lineToAdd / count, count);
                int rest = lineToAdd % count;
                if (rest != 0) {
                    sheet.insertDuplicatedRows(firstLine + lineToAdd - rest, rest);
                }
            } else {
                sheet.insertDuplicatedRows(firstLine, lineToAdd);
            }
            System.err.println("nbPage == " + nbPage);
            if (nbPage > 2) {
                sheet.duplicateFirstRows(endPageLine, nbPage - 2);
            }
            if ((pageRef = tableau.getAttributeValue("pageRef")) != null && pageRef.trim().length() > 0) {
                MutableCell cell = sheet.getCellAt(pageRef);
                cell.setValue("Page 1/" + nbPage);
                int i = 1;
                while (i < nbPage) {
                    MutableCell cell2 = sheet.getCellAt(cell.getX(), cell.getY() + endPageLine * i);
                    cell2.setValue("Page " + (i + 1) + "/" + nbPage);
                    ++i;
                }
            }
            OOgenerationXML.fillTable(tableau, row, sheet, mapStyle, false, rowLanguage);
        }
    }

    protected static SQLRowAccessor getForeignRow(SQLRowAccessor row, SQLField field) {
        Map<Integer, SQLRowAccessor> c = cacheForeign.get(field.getName());
        int i = row.getInt(field.getName());
        if (c != null && c.get(i) != null) {
            System.err.println("get foreign row From Cache ");
            return c.get(i);
        }
        SQLRowAccessor foreign = row.getForeign(field.getName());
        if (c == null) {
            HashMap<Integer, SQLRowAccessor> map = new HashMap<Integer, SQLRowAccessor>();
            map.put(i, foreign);
            cacheForeign.put(field.getName(), map);
        } else {
            c.put(i, foreign);
        }
        return foreign;
    }

    /*
     * WARNING - void declaration
     */
    private static int fillTable(Element tableau, SQLRow row, Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test, SQLRow rowLanguage) {
        void var16_24;
        if (tableau == null) {
            return 1;
        }
        int nbPage = 1;
        int nbCellules = 0;
        OOXMLTableElement tableElement = new OOXMLTableElement(tableau, row);
        int currentLineTmp = tableElement.getFirstLine();
        int currentLine = tableElement.getFirstLine();
        SQLElement styleElt = Configuration.getInstance().getDirectory().getElement("STYLE");
        boolean cache = false;
        String ref = String.valueOf(tableau.getAttributeValue("table")) + "_" + row.getTable().getName() + row.getID();
        if (rowsEltCache.get(ref) == null) {
            rowsEltCache.put(ref, tableElement.getRows());
        } else {
            cache = true;
        }
        List listElts = tableau.getChildren("element");
        int numeroRef = 0;
        for (SQLRowAccessor sQLRowAccessor : rowsEltCache.get(ref)) {
            OOXMLTableField tableField;
            ++numeroRef;
            if (!cache && sQLRowAccessor.getTable().getFieldRaw("ID_TAXE") != null) {
                SQLRowAccessor rowTaxe = OOgenerationXML.getForeignRow(sQLRowAccessor, sQLRowAccessor.getTable().getField("ID_TAXE"));
                long ht = 0L;
                if (sQLRowAccessor.getTable().getFieldRaw("T_PV_HT") != null) {
                    ht = sQLRowAccessor.getLong("T_PV_HT");
                }
                if (taxe.get(rowTaxe) != null) {
                    Object object = taxe.get(rowTaxe).get("MONTANT_HT");
                    long montant = object == null ? 0L : (Long)object;
                    taxe.get(rowTaxe).put("MONTANT_HT", montant + ht);
                } else {
                    HashMap<String, Long> m = new HashMap<String, Long>();
                    m.put("MONTANT_HT", ht);
                    taxe.put(rowTaxe, m);
                }
            }
            HashMap<String, Integer> mapNbCel = new HashMap<String, Integer>();
            boolean included = OOgenerationXML.isIncluded(tableElement.getFilterId(), tableElement.getForeignTableWhere(), tableElement.getFilterId(), tableElement.getFieldWhere(), sQLRowAccessor);
            if (!included && !tableElement.getTypeStyleWhere()) continue;
            String styleName = null;
            if (tableElement.getSQLElement().getTable().contains("ID_STYLE")) {
                styleName = styleElt.getTable().getRow(sQLRowAccessor.getInt("ID_STYLE")).getString("NOM");
            }
            if (included && tableElement.getTypeStyleWhere()) {
                styleName = "Titre 1";
            }
            if (!included) {
                styleName = "Normal";
            }
            int nbCellule = 1;
            String tmp = styleName != null && tableElement.getListBlankLineStyle().contains(styleName) ? null : styleName;
            boolean first = true;
            int tableLine = 1;
            int toAdd = 0;
            HashMap<Element, Object> mapValues = new HashMap<Element, Object>();
            for (Element e : listElts) {
                tableField = new OOXMLTableField(e, sQLRowAccessor, tableElement.getSQLElement(), sQLRowAccessor.getID(), tableElement.getTypeStyleWhere() ? -1 : tableElement.getFilterId(), rowLanguage, numeroRef);
                Object value = tableField.getValue();
                mapValues.put(e, value);
                OOgenerationXML.fill("A1", value, sheet, false, null, tmp, true, tableField.isMultilineAuto());
                int fill = OOgenerationXML.fill("A1", value, sheet, false, null, tmp, true, tableField.isMultilineAuto());
                if (currentLine + fill <= tableElement.getEndPageLine() * nbPage) continue;
                currentLineTmp = currentLine = currentLineTmp + tableElement.getEndPageLine();
                ++nbPage;
            }
            for (Element e : listElts) {
                tableField = new OOXMLTableField(e, sQLRowAccessor, tableElement.getSQLElement(), sQLRowAccessor.getID(), tableElement.getTypeStyleWhere() ? -1 : tableElement.getFilterId(), rowLanguage, numeroRef);
                if (!test && styleName != null && tableElement.getListBlankLineStyle().contains(styleName) && first) {
                    ++toAdd;
                    ++currentLine;
                    first = false;
                }
                nbCellule = mapNbCel.get(e.getAttributeValue("location").trim()) != null ? (Integer)mapNbCel.get(e.getAttributeValue("location").trim()) : 1;
                int line = tableField.getLine();
                if (tableField.getLine() > 1) {
                    line = Math.max(nbCellule + (tableLine == tableField.getLine() ? 0 : 1), tableField.getLine());
                }
                tableLine = tableField.getLine();
                String loc = String.valueOf(e.getAttributeValue("location").trim()) + (currentLine + (line - 1));
                List<String> listBlankStyle = tableField.getBlankStyle();
                if (styleName == null || !listBlankStyle.contains(styleName)) {
                    try {
                        Object value = mapValues.get(e);
                        if (tableField.isNeeding2Lines() && tableField.getLine() == 1) {
                            loc = String.valueOf(e.getAttributeValue("location").trim()) + (currentLine + 1);
                            styleName = null;
                        }
                        Point resolveHint = sheet.resolveHint(loc);
                        if (test || sheet.isCellValid(resolveHint.x, resolveHint.y)) {
                            String styleNameTmp = styleName;
                            if (tableField.getStyle().trim().length() > 0) {
                                styleNameTmp = tableField.getStyle();
                            }
                            Map<Integer, String> mTmp = styleName == null ? null : mapStyle.get(styleNameTmp);
                            String styleOO = null;
                            if (mTmp != null) {
                                String oTmp = mTmp.get(resolveHint.x);
                                styleOO = oTmp == null ? null : oTmp.toString();
                            }
                            int tmpCelluleAffect = OOgenerationXML.fill(test ? "A1" : loc, value, sheet, tableField.isTypeReplace(), null, styleOO, test, tableField.isMultilineAuto());
                            if (tableField.getLine() != 1 && (!tableField.isLineOption() || value != null && value.toString().trim().length() > 0)) {
                                tmpCelluleAffect = nbCellule >= tableField.getLine() ? (tmpCelluleAffect += nbCellule) : (tmpCelluleAffect += tableField.getLine() - 1);
                            }
                            nbCellule = tableField.isNeeding2Lines() ? Math.max(nbCellule, 2) : Math.max(nbCellule, tmpCelluleAffect);
                        } else {
                            System.err.println("Cell not valid at " + loc);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOut) {
                        System.err.println("Cell not valid at " + loc);
                    }
                }
                mapNbCel.put(e.getAttributeValue("location").trim(), nbCellule);
            }
            for (String s : mapNbCel.keySet()) {
                nbCellule = Math.max(nbCellule, (Integer)mapNbCel.get(s));
            }
            currentLine += nbCellule;
            nbCellules += nbCellule + toAdd;
        }
        int n = nbCellules / (tableElement.getEndPageLine() - tableElement.getFirstLine());
        int r = nbCellules % (tableElement.getEndPageLine() - tableElement.getFirstLine());
        if (n == 0) {
            void var16_20;
            ++var16_20;
            if (nbCellules > tableElement.getEndLine() - tableElement.getFirstLine() + 1) {
                void var16_21;
                ++var16_21;
            }
        } else if (r > tableElement.getEndLine() - tableElement.getFirstLine() + 1) {
            var16_22 += 2;
        } else {
            void var16_23;
            ++var16_23;
        }
        return (int)var16_24;
    }

    private static void fillTaxe(Element tableau, Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test) {
        int line = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        List listElts = tableau.getChildren("element");
        for (SQLRowAccessor rowTaxe : taxe.keySet()) {
            Map<String, Object> m = taxe.get(rowTaxe);
            for (Element e : listElts) {
                String loc = String.valueOf(e.getAttributeValue("location").trim()) + line;
                String name = e.getAttributeValue("name");
                String typeComp = e.getAttributeValue("type");
                if (name == null) {
                    System.err.println("OOgenerationXML.fillTaxe() --> name == null");
                    continue;
                }
                Object value = m.get(name);
                if (name.equalsIgnoreCase("MONTANT_TVA")) {
                    value = Math.round((double)((float)((Long)m.get("MONTANT_HT")).longValue() * rowTaxe.getFloat("TAUX")) / 100.0);
                } else if (name.equalsIgnoreCase("NOM")) {
                    String suffix;
                    value = rowTaxe.getString("NOM");
                    String prefix = e.getAttributeValue("prefix");
                    if (prefix != null) {
                        value = String.valueOf(prefix) + value;
                    }
                    if ((suffix = e.getAttributeValue("suffix")) != null) {
                        value = String.valueOf(value) + suffix;
                    }
                }
                if (typeComp != null && typeComp.equalsIgnoreCase("Devise")) {
                    value = Double.valueOf(GestionDevise.currencyToString((Long)value, false));
                }
                OOgenerationXML.fill(test ? "A1" : loc, value, sheet, false, null, null, test, false);
            }
            ++line;
        }
    }

    private static void parseElementsXML(List<Element> elts, SQLRow row, SpreadSheet spreadSheet) {
        SQLElement sqlElt = Configuration.getInstance().getDirectory().getElement(row.getTable());
        for (Element elt : elts) {
            OOXMLElement OOElt = new OOXMLElement(elt, sqlElt, row.getID(), row);
            Object result = OOElt.getValue();
            if (result == null) continue;
            String o = elt.getAttributeValue("sheet");
            int sheet = o == null ? 0 : Integer.valueOf(o.toString().trim());
            OOgenerationXML.fill(elt.getAttributeValue("location"), result, spreadSheet.getSheet(sheet), OOElt.isTypeReplace(), OOElt.getReplacePattern(), null, false, OOElt.isMultilineAuto());
        }
    }

    private static boolean isIncluded(int filterID, String foreignTable, int id, String fieldWhere, SQLRowAccessor rowElt) {
        if (filterID <= 1) {
            return true;
        }
        if (foreignTable != null) {
            boolean b = false;
            SQLTable table = Configuration.getInstance().getRoot().findTable(foreignTable);
            Collection<? extends SQLRowAccessor> set = rowElt.getReferentRows(table);
            for (SQLRowAccessor sQLRowAccessor : set) {
                boolean bl = b = b || sQLRowAccessor.getInt(fieldWhere) == filterID;
            }
            return b;
        }
        return filterID == id;
    }

    private static int fill(String location, Object value, Sheet sheet, boolean replace, String replacePattern, String styleOO, boolean test, boolean controleMultiline) {
        int nbCellule;
        int n = nbCellule = test && styleOO == null ? 2 : 1;
        if (test || sheet.isCellValid(sheet.resolveHint((String)location).x, sheet.resolveHint((String)location).y)) {
            MutableCell cell = sheet.getCellAt(location);
            if (controleMultiline && value != null && value.toString().indexOf(10) >= 0) {
                String[] values = value.toString().split("\n");
                if (!test) {
                    Point p = sheet.resolveHint(location);
                    int y = 0;
                    String[] stringArray = values;
                    int n2 = values.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string = stringArray[n3];
                        if (string != null && string.trim().length() != 0) {
                            try {
                                MutableCell c = sheet.getCellAt(p.x, p.y + y);
                                OOgenerationXML.setCellValue(c, string, replace, replacePattern);
                                if (styleOO != null) {
                                    c.setStyleName(styleOO);
                                }
                                ++y;
                            }
                            catch (IllegalArgumentException e) {
                                JOptionPane.showMessageDialog(null, "La cellule " + location + " n'existe pas ou est fusionn\u00e9e.", "Erreur pendant la g\u00e9n\u00e9ration", 0);
                            }
                        }
                        ++n3;
                    }
                }
                nbCellule = values.length;
            } else if (!test) {
                OOgenerationXML.setCellValue(cell, value, replace, replacePattern);
                if (styleOO != null) {
                    cell.setStyleName(styleOO);
                }
            }
        }
        return nbCellule;
    }

    private static void setCellValue(MutableCell cell, Object value, boolean replace, String replacePattern) {
        if (value == null) {
            return;
        }
        if (replace) {
            if (replacePattern != null) {
                cell.replaceBy(replacePattern, value.toString());
            } else {
                cell.replaceBy("_", value.toString());
            }
        } else {
            cell.setValue(value);
        }
    }

    private static File saveSpreadSheet(SpreadSheet ssheet, File pathDest, String fileName, String templateId, SQLRow rowLanguage) throws IOException {
        String langage;
        String string = langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
        if (ssheet == null || pathDest == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        File fDest = new File(pathDest, String.valueOf(fileName) + ".ods");
        if (!pathDest.exists()) {
            pathDest.mkdirs();
        }
        fDest = SheetUtils.convertToOldFile(fileName, pathDest, fDest);
        try {
            ssheet.saveAs(fDest);
        }
        catch (FileNotFoundException e) {
            final File file = fDest;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JOptionPane.showMessageDialog(null, "Le fichier " + file.getCanonicalPath() + " n'a pu \u00eatre cr\u00e9\u00e9. \n V\u00e9rifiez qu'il n'est pas d\u00e9j\u00e0 ouvert.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            e.printStackTrace();
        }
        try {
            File odspOut = new File(pathDest, String.valueOf(fileName) + ".odsp");
            InputStream odspIn = TemplateManager.getInstance().getTemplatePrintConfiguration(templateId, langage, null);
            if (odspIn != null) {
                StreamUtils.copy(odspIn, odspOut);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Le fichier odsp n'existe pas.");
        }
        return fDest;
    }

    private static Map<String, Map<Integer, String>> searchStyle(Sheet sheet, int colEnd, int rowEnd) {
        if (cacheStyle.get(sheet) != null) {
            return cacheStyle.get(sheet);
        }
        Map<String, Map<Integer, String>> mapStyleDef = StyleSQLElement.getMapAllStyle();
        int columnCount = colEnd == -1 ? sheet.getColumnCount() : colEnd + 1;
        System.err.println("End column search : " + columnCount);
        int rowCount = rowEnd > 0 ? rowEnd : sheet.getRowCount();
        System.err.println("End row search : " + rowCount);
        int i = 0;
        while (i < rowCount) {
            int x = 0;
            HashMap<Integer, String> mapCellStyle = new HashMap<Integer, String>();
            String style = "";
            int j = 0;
            while (j < columnCount) {
                block11: {
                    try {
                        if (!sheet.isCellValid(j, i)) break block11;
                        MutableCell c = sheet.getCellAt(j, i);
                        String cellStyle = c.getStyleName();
                        try {
                            if (mapStyleDef.containsKey(c.getValue().toString())) {
                                style = c.getValue().toString();
                            }
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                        mapCellStyle.put(x, cellStyle);
                        if (style.trim().length() != 0) {
                            String styleCell;
                            c.clearValue();
                            if (!style.trim().equalsIgnoreCase("Normal") && mapStyleDef.get("Normal") != null && (styleCell = mapStyleDef.get("Normal").get(x)) != null && styleCell.length() != 0) {
                                c.setStyleName(styleCell);
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.err.println("Index out of bounds Exception");
                    }
                }
                ++x;
                ++j;
            }
            if (style.length() > 0) {
                mapStyleDef.put(style, mapCellStyle);
            }
            ++i;
        }
        cacheStyle.put(sheet, mapStyleDef);
        return mapStyleDef;
    }

    public static boolean needAnnexe(String templateId, SQLRow row, SQLRow rowLanguage) {
        List listTable;
        SpreadSheet spreadSheet;
        block6: {
            String langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
            SAXBuilder builder = new SAXBuilder();
            InputStream xmlConfiguration = TemplateManager.getInstance().getTemplateConfiguration(templateId, langage, null);
            Document doc = builder.build(xmlConfiguration);
            InputStream template = TemplateManager.getInstance().getTemplate(templateId, langage, null);
            spreadSheet = new ODPackage(template).getSpreadSheet();
            Element racine = doc.getRootElement();
            listTable = racine.getChildren("table");
            if (listTable.size() != 0) break block6;
            return false;
        }
        try {
            Map<String, Map<Integer, String>> mapStyle;
            int nbPage;
            Element tableau = ((Element)listTable.get(0)).getAttributeValue("table").equalsIgnoreCase("TVA") ? (Element)listTable.get(1) : (Element)listTable.get(0);
            Sheet sheet = spreadSheet.getSheet(0);
            String oLastColTmp = tableau.getAttributeValue("lastColumn");
            int lastColumn = -1;
            int endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
            if (oLastColTmp != null) {
                lastColumn = sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)oLastColTmp.toString())).append((int)1).toString()).x + 1;
            }
            return (nbPage = OOgenerationXML.fillTable(tableau, row, sheet, mapStyle = OOgenerationXML.searchStyle(sheet, lastColumn, endPageLine), true, rowLanguage)) > 1;
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected static String getStringProposition(SQLRow rowProp) {
        return "Notre proposition " + rowProp.getString("NUMERO") + " du " + dateFormat.format(rowProp.getObject("DATE"));
    }

    public static void main(String[] args) {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        System.err.println("Conf created");
        Configuration.setInstance(conf);
        conf.setUpSocieteDataBaseConnexion(36);
        System.err.println("Connection Set up");
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("DEVIS");
        System.err.println("Start Genere");
        System.err.println("Stop genere");
    }
}

