/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import org.openconcerto.erp.generationDoc.AbstractLocalTemplateProvider;

public class DefaultLocalTemplateProvider
extends AbstractLocalTemplateProvider {
    private File baseDirectory = new File("Configuration/Template/Default");

    public void setBaseDirectory(File dir) {
        this.baseDirectory = dir;
    }

    @Override
    public File getTemplateFile(String templateId, String langage, String type) {
        File file = this.getFile(templateId, langage, type);
        if (!file.exists()) {
            file = this.getFile(String.valueOf(templateId) + ".ods", langage, type);
        }
        return file;
    }

    private File getFile(String templateId, String langage, String type) {
        File file;
        String path = templateId;
        if (type != null) {
            path = String.valueOf(path) + type;
        }
        if (langage != null && langage.trim().length() > 0) {
            path = String.valueOf(langage) + File.separatorChar + path;
        }
        if (!(file = new File(this.baseDirectory, path)).exists()) {
            file = new File("Configuration/Template/Default", path);
        }
        return file;
    }

    @Override
    public String getTemplatePath(String templateId, String langage, String type) {
        String path = "Configuration/Template/Default";
        if (type != null) {
            path = String.valueOf(path) + type;
        }
        if (langage != null) {
            path = String.valueOf(langage) + '/' + path;
        }
        return path;
    }
}

