/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.openconcerto.erp.generationDoc.TemplateProvider;

public abstract class AbstractLocalTemplateProvider
implements TemplateProvider {
    @Override
    public InputStream getTemplate(String templateId, String langage, String type) {
        File templateFile;
        block3: {
            try {
                templateFile = this.getTemplateFile(templateId, langage, type);
                if (templateFile != null && templateFile.exists()) break block3;
                return null;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return new FileInputStream(templateFile);
    }

    @Override
    public InputStream getTemplatePrintConfiguration(String templateId, String langage, String type) {
        File t = this.getTemplateFile(templateId, langage, type);
        String name = t.getName();
        if (name.toLowerCase().endsWith(".ods")) {
            File file = new File(t.getParent(), String.valueOf(name.substring(0, name.length() - 4)) + ".odsp");
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                System.err.println("No print configuration " + file.getAbsolutePath() + " for template id: " + templateId);
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public InputStream getTemplateConfiguration(String templateId, String langage, String type) {
        File t = this.getTemplateFile(templateId, langage, type);
        String name = t.getName();
        if (name.toLowerCase().endsWith(".ods")) {
            File file = new File(t.getParent(), String.valueOf(name.substring(0, name.length() - 4)) + ".xml");
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                System.err.println("No template configuration " + file.getAbsolutePath() + " for template id: " + templateId);
                e.printStackTrace();
            }
        }
        return null;
    }

    public abstract File getTemplateFile(String var1, String var2, String var3);

    @Override
    public abstract String getTemplatePath(String var1, String var2, String var3);
}

