/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jopendocument.link.Component;
import org.jopendocument.link.OOConnexion;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.map.model.Ville;
import org.openconcerto.odtemplate.Template;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.OGNLDataModel;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public abstract class AbstractJOOReportsSheet {
    private static final String defaultLocationTemplate = "/Configuration/Template/Default/";
    protected static final DateFormat dateFormat = new SimpleDateFormat("dd MMMM yyyy");
    protected static final DateFormat dateFormat2 = new SimpleDateFormat("dd/MM/yy");
    protected static final DateFormat yearFormat = new SimpleDateFormat("yyyy");
    private String year;
    protected String locationTemplate = TemplateNXProps.getInstance().getStringProperty("LocationTemplate");
    protected String templateId;
    private String printer;
    protected boolean askOverwriting = false;

    protected abstract Map createMap();

    public abstract String getFileName();

    protected void init(String year, String templateId, String attributePrinter) {
        this.year = year;
        this.templateId = templateId;
        this.printer = PrinterNXProps.getInstance().getStringProperty(attributePrinter);
    }

    public final void generate(boolean print, boolean show, String printer) {
        this.generate(print, show, printer, false);
    }

    public void generate(boolean print, boolean show, String printer, boolean overwrite2) {
        if (this.locationTemplate.trim().length() == 0) {
            this.locationTemplate = defaultLocationTemplate;
        }
        try {
            String fileName = this.getFileName();
            InputStream fileTemplate = TemplateManager.getInstance().getTemplate(this.templateId);
            File outputDir = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory(this.templateId);
            File fileOutOO = this.getDocumentFile();
            if (fileOutOO.exists() && overwrite2) {
                if (this.askOverwriting) {
                    int answer = JOptionPane.showConfirmDialog(null, "Voulez vous \u00e9craser le document ?", "Remplacement d'un document", 0);
                    if (answer == 0) {
                        SheetUtils.convertToOldFile(fileName, outputDir, fileOutOO, ".odt");
                    }
                } else {
                    SheetUtils.convertToOldFile(fileName, outputDir, fileOutOO, ".odt");
                }
            }
            if (!fileOutOO.exists()) {
                fileOutOO.getParentFile().mkdirs();
                Template template = new Template(new BufferedInputStream(fileTemplate));
                Map createMap = this.createMap();
                OGNLDataModel model = new OGNLDataModel(createMap);
                model.putAll(createMap);
                template.createDocument(model).saveAs(fileOutOO);
            }
            if (show || print) {
                try {
                    OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                    if (ooConnexion == null) {
                        return;
                    }
                    Component doc = ooConnexion.loadDocument(fileOutOO, !show);
                    if (this.savePDF()) {
                        File pdfOutputDir = DocumentLocalStorageManager.getInstance().getPDFOutputDirectory(this.templateId);
                        doc.saveToPDF(new File(pdfOutputDir, String.valueOf(fileName) + ".pdf"), "writer_pdf_Export");
                    }
                    if (print) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("Name", printer);
                        doc.printDocument(map);
                    }
                    doc.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            ExceptionHandler.handle("Impossible de trouver le mod\u00e9le.", e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    protected boolean savePDF() {
        return false;
    }

    public void showDocument() {
        File fileOutOO = this.getDocumentFile();
        if (fileOutOO.exists()) {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                ooConnexion.loadDocument(fileOutOO, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        } else {
            this.generate(false, true, "");
        }
    }

    private File getDocumentFile() {
        File outputDir = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory(this.templateId);
        return new File(outputDir, String.valueOf(this.getFileName()) + ".odt");
    }

    public void printDocument() {
        File fileOutOO = this.getDocumentFile();
        if (fileOutOO.exists()) {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                Component doc = ooConnexion.loadDocument(fileOutOO, true);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Name", this.printer);
                doc.printDocument(map);
                doc.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        } else {
            this.generate(true, false, this.printer);
        }
    }

    public void fastPrintDocument() {
        File f = this.getDocumentFile();
        if (!f.exists()) {
            this.generate(true, false, this.printer);
        } else {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                Component doc = ooConnexion.loadDocument(f, true);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Name", this.printer);
                HashMap<String, Integer> map2 = new HashMap<String, Integer>();
                map2.put("CopyCount", 1);
                doc.printDocument(map, map2);
                doc.close();
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de charger le document OpentOffice", e);
                e.printStackTrace();
            }
        }
    }

    protected String getInitiales(SQLRow row) {
        String init = "";
        if (row != null) {
            String stringNom;
            String stringPrenom = row.getString("PRENOM");
            if (stringPrenom != null && stringPrenom.trim().length() != 0) {
                init = String.valueOf(init) + stringPrenom.trim().charAt(0);
            }
            if ((stringNom = row.getString("NOM")) != null && stringNom.trim().length() != 0) {
                init = String.valueOf(init) + stringNom.trim().charAt(0);
            }
        }
        return init;
    }

    public void exportToPdf() {
        String fileName = this.getFileName();
        File fileOutOO = this.getDocumentFile();
        File outputPDFDirectory = DocumentLocalStorageManager.getInstance().getPDFOutputDirectory(this.templateId);
        File fileOutPDF = new File(outputPDFDirectory, String.valueOf(fileName) + ".pdf");
        if (!fileOutOO.exists()) {
            this.generate(false, false, "");
        }
        try {
            OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
            if (ooConnexion == null) {
                return;
            }
            Component doc = ooConnexion.loadDocument(fileOutOO, true);
            doc.saveToPDF(fileOutPDF, "writer_pdf_Export");
            doc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
        }
        int result = JOptionPane.showOptionDialog(null, "Ouvrir le pdf ?", "Ouverture du PDF", 0, 3, null, null, null);
        if (result == 0) {
            Gestion.openPDF(fileOutPDF);
        } else {
            try {
                FileUtils.openFile(fileOutPDF.getParentFile());
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Impossible d'ouvrir le dossier : " + fileOutPDF.getParentFile() + ".");
            }
        }
    }

    protected static String getVille(final String name) {
        Ville ville = Ville.getVilleFromVilleEtCode(name);
        if (ville == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "La ville \"" + name + "\"" + " est introuvable! Veuillez corriger l'erreur!");
                }
            });
            return null;
        }
        return ville.getName();
    }

    protected static String getVilleCP(String name) {
        Ville ville = Ville.getVilleFromVilleEtCode(name);
        if (ville == null) {
            return null;
        }
        return ville.getCodepostal();
    }
}

