/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.order.report.CommandeClientXmlSheet;
import org.openconcerto.erp.core.sales.order.ui.CommandeClientRenderer;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ListeDesCommandesClientAction
extends CreateFrameAbstractAction {
    public ListeDesCommandesClientAction() {
        this.putValue("Name", "Liste des commandes clients");
    }

    @Override
    public JFrame createFrame() {
        IListFrame frame = new IListFrame(new ListeAddPanel(Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT")){

            @Override
            protected GridBagConstraints createConstraints() {
                GridBagConstraints c = super.createConstraints();
                ++c.gridy;
                return c;
            }
        });
        CommandeClientRenderer rend = CommandeClientRenderer.getInstance();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JPanel legendePanel = rend.getLegendePanel();
        legendePanel.setBorder(BorderFactory.createTitledBorder("L\u00e9gende"));
        legendePanel.setOpaque(true);
        c.fill = 0;
        frame.getPanel().add((Component)legendePanel, c);
        JTable table = frame.getPanel().getListe().getJTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(rend);
            ++i;
        }
        frame.getPanel().getListe().addIListeActions(new MouseSheetXmlListeListener(CommandeClientXmlSheet.class){

            @Override
            public List<RowAction> addToMenu() {
                RowAction.PredicateRowAction bonAction = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers BL"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesCommandesClientAction.this.transfertBonLivraisonClient(IListe.get(e).getSelectedRow());
                    }
                }, false);
                RowAction.PredicateRowAction factureAction = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers facture"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesCommandesClientAction.this.transfertFactureClient(IListe.get(e).getSelectedRow());
                    }
                }, false);
                RowAction.PredicateRowAction cmdAction = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers commande fournisseur"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CommandeClientSQLElement elt = (CommandeClientSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
                        elt.transfertCommande(IListe.get(e).getSelectedId());
                    }
                }, false);
                cmdAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
                factureAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
                bonAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
                ArrayList<RowAction> l = new ArrayList<RowAction>();
                l.add(bonAction);
                l.add(factureAction);
                l.add(cmdAction);
                return l;
            }
        }.getRowActions());
        return frame;
    }

    private void transfertBonLivraisonClient(SQLRow row) {
        CommandeClientSQLElement elt = (CommandeClientSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        elt.transfertBonLivraison(row.getID());
    }

    private void transfertFactureClient(SQLRow row) {
        CommandeClientSQLElement elt = (CommandeClientSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        elt.transfertFacture(row.getID());
    }
}

