/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.supplychain.order.element.CommandeSQLElement;
import org.openconcerto.erp.generationDoc.gestcomm.CommandeXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;

public class ListeDesCommandesAction
extends CreateFrameAbstractAction {
    public ListeDesCommandesAction() {
        this.putValue("Name", "Liste des commandes fournisseurs");
    }

    @Override
    public JFrame createFrame() {
        IListFrame frame = new IListFrame(new ListeAddPanel(Configuration.getInstance().getDirectory().getElement("COMMANDE")));
        frame.getPanel().getListe().addIListeActions(new MouseSheetXmlListeListener(CommandeXmlSheet.class){

            @Override
            public List<RowAction> addToMenu() {
                RowAction.PredicateRowAction bonAction = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers BR"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesCommandesAction.this.transfertBonReceptionClient(IListe.get(e).getSelectedRow());
                    }
                }, false);
                bonAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
                RowAction.PredicateRowAction factureAction = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers facture"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListeDesCommandesAction.this.transfertFactureFournisseur(IListe.get(e).getSelectedRow());
                    }
                }, false);
                factureAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
                ArrayList<RowAction> l = new ArrayList<RowAction>();
                l.add(bonAction);
                l.add(factureAction);
                return l;
            }
        }.getRowActions());
        return frame;
    }

    private void transfertBonReceptionClient(SQLRow row) {
        CommandeSQLElement elt = (CommandeSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE");
        elt.transfertBR(row.getID());
    }

    private void transfertFactureFournisseur(SQLRow row) {
        CommandeSQLElement elt = (CommandeSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE");
        elt.transfertFacture(row.getID());
    }
}

