/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.report;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.erp.generationDoc.AbstractJOOReportsSheet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.GestionDevise;

public class DevisTextSheet
extends AbstractJOOReportsSheet {
    private SQLRow row;

    @Override
    protected Map createMap() {
        SQLRow clientRowNX;
        HashMap<String, Object> m = new HashMap<String, Object>();
        SQLRow rowClient = clientRowNX = this.row.getForeignRow("ID_CLIENT");
        SQLRow rowAdresse = rowClient.getForeignRow("ID_ADRESSE");
        SQLRow rowCompteClient = clientRowNX.getForeignRow("ID_COMPTE_PCE");
        String numero = rowCompteClient.getString("NUMERO");
        m.put("ClientNumeroCompte", numero);
        m.put("ClientType", rowClient.getString("FORME_JURIDIQUE"));
        m.put("ClientNom", rowClient.getString("NOM"));
        m.put("ClientTel", rowClient.getString("TEL"));
        m.put("ClientTelP", rowClient.getString("TEL_P"));
        m.put("ClientFax", rowClient.getString("FAX"));
        m.put("ClientMail", rowClient.getString("MAIL"));
        String villeCli = DevisTextSheet.getVille(rowAdresse.getString("VILLE"));
        Object cedexCli = rowAdresse.getObject("CEDEX");
        boolean hasCedexCli = rowAdresse.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        String adr = String.valueOf(rowAdresse.getString("RUE")) + "\n" + DevisTextSheet.getVilleCP(rowAdresse.getString("VILLE")) + " " + villeCli;
        m.put("ClientAdresse", adr);
        if (this.row.getBoolean("ADRESSE_IDENTIQUE").booleanValue()) {
            m.put("ClientInterv", "");
        } else {
            SQLRow rowIntervention = this.row.getForeignRow("ID_ADRESSE");
            String villeInter = DevisTextSheet.getVille(rowIntervention.getString("VILLE"));
            Object cedexInter = rowIntervention.getObject("CEDEX");
            boolean hasCedexInter = rowIntervention.getBoolean("HAS_CEDEX");
            if (hasCedexInter) {
                villeInter = String.valueOf(villeInter) + " CEDEX";
                if (cedexInter != null && cedexInter.toString().trim().length() > 0) {
                    villeInter = String.valueOf(villeInter) + " " + cedexInter.toString().trim();
                }
            }
            String adrInter = String.valueOf(rowIntervention.getString("RUE")) + "\n" + DevisTextSheet.getVilleCP(rowIntervention.getString("VILLE")) + " " + villeInter;
            m.put("ClientInterv", adrInter);
        }
        SQLRow rowContact = this.row.getForeignRow("ID_CONTACT");
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        m.put("Date", format.format(this.row.getDate("DATE").getTime()));
        if (rowContact != null && rowContact.getID() > 1) {
            m.put("RespNom", rowContact.getObject("NOM"));
            m.put("RespPrenom", rowContact.getObject("PRENOM"));
            m.put("RespMobile", rowContact.getObject("TEL_MOBILE"));
            m.put("RespTel", rowContact.getObject("TEL_DIRECT"));
            m.put("RespFax", rowContact.getObject("FAX"));
            m.put("RespMail", rowContact.getObject("EMAIL"));
        }
        m.put("MontantHT", GestionDevise.currencyToString(this.row.getLong("T_HT")));
        m.put("MontantTTC", GestionDevise.currencyToString(this.row.getLong("T_TTC")));
        m.put("TVA", this.row.getForeignRow("ID_TAXE").getString("TAUX"));
        m.put("Numero", this.row.getString("NUMERO"));
        m.put("R\u00e9f\u00e9rence", this.row.getString("OBJET"));
        SQLRow foreignRow = this.row.getForeignRow("ID_COMMERCIAL");
        m.put("Technicien", String.valueOf(foreignRow.getString("PRENOM")) + " " + foreignRow.getString("NOM"));
        return m;
    }

    public DevisTextSheet(SQLRow row) {
        this.row = row;
        this.askOverwriting = true;
        Date d = (Date)this.row.getObject("DATE");
        String year = yearFormat.format(d);
        this.init(year, "Devis.odt", "DevisPrinter");
    }

    @Override
    protected boolean savePDF() {
        return true;
    }

    @Override
    public String getFileName() {
        String fileName = "Devis_" + this.row.getString("NUMERO");
        return fileName;
    }

    public String getTemplateId() {
        return "sales.quote.text";
    }
}

