/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.ArticleDesignationTable;
import org.openconcerto.erp.core.sales.product.ui.ArticleTarifTable;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ReferenceArticleSQLComponent
extends BaseSQLComponent {
    private DeviseField textPVHT;
    private DeviseField textPVTTC;
    private DeviseField textPAHT;
    private DeviseField textMetrique1VT;
    private DeviseField textMetrique1HA;
    final JCheckBox boxService = new JCheckBox(this.getLabelFor("SERVICE"));
    final JCheckBox checkObs = new JCheckBox(this.getLabelFor("OBSOLETE"));
    private JTextField textNom;
    private JTextField textCode;
    private JTextField textPoids;
    private JTextField textValMetrique1;
    private JTextField textValMetrique2;
    private JTextField textValMetrique3;
    private DocumentListener htDocListener;
    private DocumentListener ttcDocListener;
    private DocumentListener detailsListener;
    PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener taxeListener;
    final ElementComboBox comboSelTaxe = new ElementComboBox(false, 25);
    final ElementComboBox comboSelModeVente = new ElementComboBox(false, 25);
    private JLabel labelMetriqueHA1 = new JLabel(this.getLabelFor("PRIX_METRIQUE_HA_1"));
    private JLabel labelMetriqueVT1 = new JLabel(this.getLabelFor("PRIX_METRIQUE_VT_1"));
    ArticleDesignationTable tableDes = new ArticleDesignationTable();
    ArticleTarifTable tableTarifVente = new ArticleTarifTable(this);
    private DocumentListener pieceHAArticle = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            ReferenceArticleSQLComponent.this.textMetrique1HA.setText(ReferenceArticleSQLComponent.this.textPAHT.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            ReferenceArticleSQLComponent.this.textMetrique1HA.setText(ReferenceArticleSQLComponent.this.textPAHT.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            ReferenceArticleSQLComponent.this.textMetrique1HA.setText(ReferenceArticleSQLComponent.this.textPAHT.getText());
        }
    };
    private DocumentListener pieceVTArticle = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            ReferenceArticleSQLComponent.this.textMetrique1VT.setText(ReferenceArticleSQLComponent.this.textPVHT.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            ReferenceArticleSQLComponent.this.textMetrique1VT.setText(ReferenceArticleSQLComponent.this.textPVHT.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            ReferenceArticleSQLComponent.this.textMetrique1VT.setText(ReferenceArticleSQLComponent.this.textPVHT.getText());
        }
    };
    final DeviseField textMarge = new DeviseField();
    private DocumentListener listenerMargeTextMarge = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ReferenceArticleSQLComponent.this.textPVHT.getDocument().removeDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
            ReferenceArticleSQLComponent.this.updateVtFromMarge();
            ReferenceArticleSQLComponent.this.textPVHT.getDocument().addDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
        }
    };
    private DocumentListener listenerMargeTextVT = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ReferenceArticleSQLComponent.this.textMarge.getDocument().removeDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextMarge);
            if (ReferenceArticleSQLComponent.this.textPVHT.getText().trim().length() > 0 && ReferenceArticleSQLComponent.this.textPAHT.getText().trim().length() > 0) {
                Long vt = (Long)ReferenceArticleSQLComponent.this.textPVHT.getUncheckedValue();
                Long ha = (Long)ReferenceArticleSQLComponent.this.textPAHT.getUncheckedValue();
                if (vt != null && ha != null && vt != 0L && ha != 0L) {
                    long margeHT = vt - ha;
                    double value = DefaultNXProps.getInstance().getBooleanValue(TotalPanel.MARGE_MARQUE, false) ? (vt > 0L ? (double)Math.round((double)margeHT / (double)vt.longValue() * 10000.0) : 0.0) : (double)Math.round((double)margeHT / (double)ha.longValue() * 10000.0);
                    if (value > 0.0) {
                        ReferenceArticleSQLComponent.this.textMarge.setText(GestionDevise.currencyToString(Double.valueOf(value).longValue()));
                    } else {
                        ReferenceArticleSQLComponent.this.textMarge.setText("0");
                    }
                }
            }
            ReferenceArticleSQLComponent.this.textMarge.getDocument().addDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextMarge);
        }
    };
    private DocumentListener listenerMargeTextHA = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ReferenceArticleSQLComponent.this.textPVHT.getDocument().removeDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
            ReferenceArticleSQLComponent.this.updateVtFromMarge();
            ReferenceArticleSQLComponent.this.textPVHT.getDocument().addDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
        }
    };

    private void updateVtFromMarge() {
        Long ha;
        if (this.textMarge.getText().trim().length() > 0 && (ha = (Long)this.textPAHT.getUncheckedValue()) != null && this.textMarge.getText().trim().length() > 0) {
            String replaceAll = this.textMarge.getText().replaceAll(",", ".");
            double d = Double.parseDouble(replaceAll.replaceAll(" ", ""));
            if (DefaultNXProps.getInstance().getBooleanValue(TotalPanel.MARGE_MARQUE, false)) {
                double e = 1.0 - d / 100.0;
                if (e == 0.0) {
                    this.textPVHT.setText("0");
                } else {
                    this.textPVHT.setText(GestionDevise.currencyToString(Math.round((double)ha.longValue() / e)));
                }
            } else {
                this.textPVHT.setText(GestionDevise.currencyToString(Math.round((double)ha.longValue() * (d / 100.0 + 1.0))));
            }
        }
    }

    public ReferenceArticleSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r != null && r.getID() > this.getTable().getUndefinedID()) {
            this.checkObs.setVisible(true);
            this.tableTarifVente.setArticleValues(r);
            this.tableTarifVente.insertFrom("ID_ARTICLE", r.getID());
            this.tableDes.insertFrom("ID_ARTICLE", r.getID());
        }
    }

    @Override
    public void addViews() {
        boolean modeVenteAvance;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.textPVHT = new DeviseField();
        this.textPVTTC = new DeviseField();
        this.textPAHT = new DeviseField();
        this.textPVHT.getDocument().addDocumentListener(this.listenerMargeTextVT);
        this.textMetrique1HA = new DeviseField();
        this.textMetrique1VT = new DeviseField();
        this.textValMetrique1 = new JTextField();
        this.textValMetrique2 = new JTextField();
        this.textValMetrique3 = new JTextField();
        this.textCode = new JTextField();
        this.textNom = new JTextField();
        this.textPoids = new JTextField(6);
        JLabel codelabel = new JLabel(this.getLabelFor("CODE"));
        codelabel.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(codelabel);
        this.add((Component)codelabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        DefaultGridBagConstraints.lockMinimumSize(this.textCode);
        this.add((Component)this.textCode, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelFamille = new JLabel(this.getLabelFor("ID_FAMILLE_ARTICLE"));
        labelFamille.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelFamille);
        this.add((Component)labelFamille, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        ElementComboBox comboSelFamille = new ElementComboBox(false, 25);
        DefaultGridBagConstraints.lockMinimumSize(comboSelFamille);
        this.add((Component)comboSelFamille, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
        labelNom.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelNom);
        this.add((Component)labelNom, c);
        ++c.gridx;
        c.weightx = 1.0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNom);
        this.add((Component)this.textNom, c);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel labelCodeBarre = new JLabel(this.getLabelFor("CODE_BARRE"));
        labelCodeBarre.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelCodeBarre);
        this.add((Component)labelCodeBarre, c);
        ++c.gridx;
        c.weightx = 1.0;
        JTextField fieldCodeBarre = new JTextField();
        DefaultGridBagConstraints.lockMinimumSize(fieldCodeBarre);
        this.add((Component)fieldCodeBarre, c);
        this.addView(fieldCodeBarre, "CODE_BARRE");
        DefaultProps props = DefaultNXProps.getInstance();
        String modeVente = props.getStringProperty("ArticleModeVenteAvance");
        Boolean bModeVente = Boolean.valueOf(modeVente);
        boolean bl = modeVenteAvance = bModeVente == null || bModeVente != false;
        if (modeVenteAvance) {
            this.addModeVenteAvance(c);
        }
        this.getMontantPanel(c, props);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = new JPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        JTabbedPane pane = new JTabbedPane();
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.7;
        pane.add("Tarifs de vente", this.createTarifPanel());
        pane.add("Exportation", this.createExportationPanel());
        pane.add("Achat", this.createAchatPanel());
        pane.add("Stock", this.createStockPanel());
        pane.add("Descriptif", this.createDescriptifPanel());
        pane.add("D\u00e9signations multilingues", this.createDesignationPanel());
        c.fill = 1;
        this.add((Component)pane, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)new TitledSeparator("Informations compl\u00e9mentaires"), c);
        ++c.gridy;
        c.weighty = 0.3;
        JTextArea infos = new JTextArea();
        c.fill = 1;
        this.add((Component)infos, c);
        this.addSQLObject(infos, "INFOS");
        this.addSQLObject(this.textMetrique1HA, "PRIX_METRIQUE_HA_1");
        this.addSQLObject(this.textMetrique1VT, "PRIX_METRIQUE_VT_1");
        this.addSQLObject(this.textValMetrique1, "VALEUR_METRIQUE_1");
        this.addSQLObject(this.textValMetrique2, "VALEUR_METRIQUE_2");
        this.addSQLObject(this.textValMetrique3, "VALEUR_METRIQUE_3");
        this.addSQLObject(this.comboSelModeVente, "ID_MODE_VENTE_ARTICLE");
        this.addSQLObject(this.boxService, "SERVICE");
        this.addSQLObject(comboSelFamille, "ID_FAMILLE_ARTICLE");
        this.addRequiredSQLObject(this.textNom, "NOM");
        this.addRequiredSQLObject(this.textCode, "CODE");
        this.addSQLObject(this.textPoids, "POIDS");
        this.comboSelTaxe.setButtonsVisible(false);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(ReferenceArticleSQLComponent.this.comboSelModeVente.getSelectedId());
                ReferenceArticleSQLComponent.this.selectModeVente(ReferenceArticleSQLComponent.this.comboSelModeVente.getSelectedId());
            }
        };
        this.setListenerModeVenteActive(true);
        this.comboSelModeVente.setValue(5);
    }

    private Component createDescriptifPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.checkObs.setOpaque(false);
        panel.add((Component)this.checkObs, c);
        this.checkObs.setVisible(false);
        this.addView(this.checkObs, "OBSOLETE");
        if (this.getTable().getFieldsName().contains("COLORIS")) {
            JTextField fieldColoris = new JTextField();
            ++c.gridy;
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            panel.add((Component)new JLabel(this.getLabelFor("COLORIS")), c);
            c.weightx = 1.0;
            ++c.gridx;
            panel.add((Component)fieldColoris, c);
            this.addView(fieldColoris, "COLORIS");
        }
        ITextArea area = new ITextArea();
        JLabel sep = new JLabel("Descriptif complet");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 2;
        panel.add((Component)sep, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)area, c);
        this.addView(area, "DESCRIPTIF");
        return panel;
    }

    private Component createDesignationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter une d\u00e9signation "), c);
        final ElementComboBox boxDes = new ElementComboBox();
        boxDes.init(Configuration.getInstance().getDirectory().getElement("LANGUE"));
        ++c.gridx;
        panel.add((Component)boxDes, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouterDes = new JButton("Ajouter");
        buttonAjouterDes.setOpaque(false);
        panel.add((Component)buttonAjouterDes, c);
        ++c.gridx;
        JButton buttonSupprimerDes = new JButton("Supprimer");
        buttonSupprimerDes.setOpaque(false);
        panel.add((Component)buttonSupprimerDes, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.tableDes.setOpaque(false);
        panel.add((Component)this.tableDes, c);
        buttonAjouterDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int id = boxDes.getSelectedId();
                if (id <= 1) {
                    return;
                }
                int nbRows = ReferenceArticleSQLComponent.this.tableDes.getModel().getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = ReferenceArticleSQLComponent.this.tableDes.getModel().getRowValuesAt(i);
                    int idLangue = Integer.parseInt(rowVals.getObject("ID_LANGUE").toString());
                    if (idLangue == id) {
                        JOptionPane.showMessageDialog(null, "Impossible d'ajouter.\nLa langue est d\u00e9j\u00e0 pr\u00e9sente dans la liste!");
                        return;
                    }
                    ++i;
                }
                SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("ARTICLE_DESIGNATION"));
                if (ReferenceArticleSQLComponent.this.getSelectedID() > 1) {
                    rowVals.put("ID_ARTICLE", ReferenceArticleSQLComponent.this.getSelectedID());
                }
                rowVals.put("ID_LANGUE", id);
                rowVals.put("NOM", "");
                ReferenceArticleSQLComponent.this.tableDes.getModel().addRow(rowVals);
            }
        });
        buttonSupprimerDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.tableDes.removeSelectedRow();
            }
        });
        return panel;
    }

    private Component createStockPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        DefaultProps props = DefaultNXProps.getInstance();
        String stockMin = props.getStringProperty("ArticleStockMin");
        Boolean bStockMin = !stockMin.equalsIgnoreCase("false");
        boolean gestionStockMin = bStockMin == null || bStockMin != false;
        c.gridx = 0;
        ++c.gridy;
        final JCheckBox boxStock = new JCheckBox(this.getLabelFor("GESTION_STOCK"));
        boxStock.setOpaque(false);
        panel.add((Component)boxStock, c);
        this.addView(boxStock, "GESTION_STOCK");
        final JTextField fieldQteMin = new JTextField();
        final JTextField fieldQteAchat = new JTextField();
        boxStock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fieldQteMin.setEnabled(boxStock.isSelected());
                fieldQteAchat.setEnabled(boxStock.isSelected());
            }
        });
        boxStock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        c.gridwidth = 1;
        if (gestionStockMin) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            panel.add((Component)new JLabel(this.getLabelFor("QTE_MIN")), c);
            ++c.gridx;
            c.weightx = 1.0;
            panel.add((Component)fieldQteMin, c);
            this.addView(fieldQteMin, "QTE_MIN");
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            panel.add((Component)new JLabel(this.getLabelFor("QTE_ACHAT")), c);
            ++c.gridx;
            c.weightx = 1.0;
            panel.add((Component)fieldQteAchat, c);
            this.addView(fieldQteAchat, "QTE_ACHAT");
        }
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        panel.add((Component)spacer, c);
        return panel;
    }

    private Component createAchatPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelFournisseur = new JLabel(this.getLabelFor("ID_FOURNISSEUR"));
        labelFournisseur.setHorizontalAlignment(4);
        panel.add((Component)labelFournisseur, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        ElementComboBox comboSelFournisseur = new ElementComboBox(false, 25);
        panel.add((Component)comboSelFournisseur, c);
        this.addView(comboSelFournisseur, "ID_FOURNISSEUR");
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        panel.add((Component)spacer, c);
        return panel;
    }

    private JPanel createExportationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelCodeD = new JLabel(this.getLabelFor("CODE_DOUANIER"));
        labelCodeD.setHorizontalAlignment(4);
        panel.add((Component)labelCodeD, c);
        ++c.gridx;
        JTextField fieldCodeDouanier = new JTextField();
        c.weightx = 1.0;
        panel.add((Component)fieldCodeDouanier, c);
        this.addView(fieldCodeDouanier, "CODE_DOUANIER");
        ++c.gridx;
        c.weightx = 0.0;
        JLabel labelPays = new JLabel(this.getLabelFor("ID_PAYS"));
        labelPays.setHorizontalAlignment(4);
        panel.add((Component)labelPays, c);
        ++c.gridx;
        c.weightx = 1.0;
        ElementComboBox comboSelPays = new ElementComboBox(false);
        panel.add((Component)comboSelPays, c);
        this.addView(comboSelPays, "ID_PAYS");
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        panel.add((Component)spacer, c);
        return panel;
    }

    private JPanel createTarifPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter le tarif "), c);
        final ElementComboBox boxTarif = new ElementComboBox();
        boxTarif.init(Configuration.getInstance().getDirectory().getElement("TARIF"));
        ++c.gridx;
        panel.add((Component)boxTarif, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouter = new JButton("Ajouter");
        buttonAjouter.setOpaque(false);
        panel.add((Component)buttonAjouter, c);
        ++c.gridx;
        JButton buttonSupprimer = new JButton("Supprimer");
        buttonSupprimer.setOpaque(false);
        panel.add((Component)buttonSupprimer, c);
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        this.tableTarifVente.setOpaque(false);
        panel.add((Component)this.tableTarifVente, c);
        buttonAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowTarif = boxTarif.getSelectedRow();
                if (rowTarif == null || rowTarif.isUndefined()) {
                    return;
                }
                int nbRows = ReferenceArticleSQLComponent.this.tableTarifVente.getModel().getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = ReferenceArticleSQLComponent.this.tableTarifVente.getModel().getRowValuesAt(i);
                    int idTarif = Integer.parseInt(rowVals.getObject("ID_TARIF").toString());
                    if (idTarif == rowTarif.getID()) {
                        JOptionPane.showMessageDialog(null, "Impossible d'ajouter.\nLe tarif est d\u00e9j\u00e0 pr\u00e9sent dans la liste!");
                        return;
                    }
                    ++i;
                }
                SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("ARTICLE_TARIF"));
                if (ReferenceArticleSQLComponent.this.getSelectedID() > 1) {
                    rowVals.put("ID_ARTICLE", ReferenceArticleSQLComponent.this.getSelectedID());
                }
                rowVals.put("ID_TARIF", rowTarif.getID());
                rowVals.put("ID_DEVISE", rowTarif.getInt("ID_DEVISE"));
                rowVals.put("ID_TAXE", rowTarif.getInt("ID_TAXE"));
                rowVals.put("PRIX_METRIQUE_VT_1", 0L);
                rowVals.put("PV_HT", 0L);
                rowVals.put("PV_TTC", 0L);
                ReferenceArticleSQLComponent.this.tableTarifVente.getModel().addRow(rowVals);
            }
        });
        buttonSupprimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.tableTarifVente.removeSelectedRow();
            }
        });
        return panel;
    }

    protected void getMontantPanel(GridBagConstraints c, DefaultProps props) {
        JPanel pDevise = new JPanel();
        pDevise.add(new JLabel("Devise du fournisseur"));
        final ElementComboBox boxDevise = new ElementComboBox();
        pDevise.add(boxDevise);
        this.addView(boxDevise, "ID_DEVISE_HA");
        pDevise.add(new JLabel("Prix d'achat devise"));
        final DeviseField fieldHAD = new DeviseField();
        pDevise.add(fieldHAD);
        this.addView(fieldHAD, "PA_DEVISE");
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)pDevise, c);
        fieldHAD.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                Long ha = (Long)fieldHAD.getUncheckedValue();
                if (ha != null && fieldHAD.getText().trim().length() > 0) {
                    BigDecimal taux = BigDecimal.ONE;
                    if (boxDevise != null && boxDevise.getSelectedRow() != null && !boxDevise.getSelectedRow().isUndefined()) {
                        taux = (BigDecimal)boxDevise.getSelectedRow().getObject("TAUX");
                        ReferenceArticleSQLComponent.this.textPAHT.setValue(GestionDevise.currencyToString(taux.multiply(new BigDecimal(ha)).longValue()));
                    }
                }
            }
        });
        JPanel p = new JPanel();
        p.add(new JLabel(this.getLabelFor("PA_HT")));
        p.add(this.textPAHT);
        this.textPAHT.getDocument().addDocumentListener(this.listenerMargeTextHA);
        p.add(new JLabel("Marge"));
        HashSet<SQLField> set = new HashSet<SQLField>();
        set.add(this.getTable().getField("PA_HT"));
        this.textMarge.init("Marge", set);
        p.add(this.textMarge);
        this.textMarge.getDocument().addDocumentListener(this.listenerMargeTextMarge);
        p.add(new JLabel("%           "));
        JLabel labelPds = new JLabel(this.getLabelFor("POIDS"));
        p.add(labelPds);
        labelPds.setHorizontalAlignment(4);
        p.add(this.textPoids);
        String sService = props.getStringProperty("ArticleService");
        Boolean bService = Boolean.valueOf(sService);
        if (bService != null && bService.booleanValue()) {
            p.add(this.boxService);
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)p, c);
        JPanel p2 = new JPanel();
        p2.add(new JLabel(this.getLabelFor("PV_HT")));
        p2.add(this.textPVHT);
        JLabel labelTaxe = new JLabel(this.getLabelFor("ID_TAXE"));
        p2.add(labelTaxe);
        labelTaxe.setHorizontalAlignment(4);
        p2.add(this.comboSelTaxe);
        p2.add(new JLabel(this.getLabelFor("PV_TTC")));
        p2.add(this.textPVTTC);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)p2, c);
        this.addRequiredSQLObject(this.textPAHT, "PA_HT");
        this.addRequiredSQLObject(this.textPVHT, "PV_HT");
        this.addRequiredSQLObject(this.comboSelTaxe, "ID_TAXE");
        this.addRequiredSQLObject(this.textPVTTC, "PV_TTC");
        this.ttcDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextHT();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextHT();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextHT();
            }
        };
        this.htDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextTTC();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextTTC();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextTTC();
            }
        };
        this.detailsListener = new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.updatePiece();
            }
        };
        this.taxeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ReferenceArticleSQLComponent.this.textPVHT.getText().trim().length() > 0) {
                    ReferenceArticleSQLComponent.this.setTextTTC();
                } else {
                    ReferenceArticleSQLComponent.this.setTextHT();
                }
                ReferenceArticleSQLComponent.this.tableTarifVente.fireModification();
            }
        };
        this.textPVHT.getDocument().addDocumentListener(this.htDocListener);
        this.textPVTTC.getDocument().addDocumentListener(this.ttcDocListener);
        this.comboSelTaxe.addValueListener(this.taxeListener);
        this.textMetrique1HA.getDocument().addDocumentListener(this.detailsListener);
        this.textMetrique1VT.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique1.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique2.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique3.getDocument().addDocumentListener(this.detailsListener);
    }

    private void setListenerModeVenteActive(boolean b) {
        if (b) {
            this.comboSelModeVente.addValueListener(this.propertyChangeListener);
        } else {
            this.comboSelModeVente.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void addModeVenteAvance(GridBagConstraints c) {
        DefaultProps props = DefaultNXProps.getInstance();
        JSeparator sep = new JSeparator();
        JLabel labelDetails = new JLabel("Article d\u00e9taill\u00e9");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelDetails, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)sep, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(this.getLabelFor("ID_MODE_VENTE_ARTICLE")), c);
        ++c.gridx;
        this.add((Component)this.comboSelModeVente, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.labelMetriqueHA1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textMetrique1HA, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.labelMetriqueVT1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textMetrique1VT, c);
        c.weightx = 0.0;
        JLabel labelMetrique1 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_1"));
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)labelMetrique1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique1, c);
        ++c.gridx;
        c.weightx = 0.0;
        Boolean bMetrique1 = Boolean.valueOf(props.getStringProperty("ArticleLongueur"));
        labelMetrique1.setVisible(bMetrique1 == null || bMetrique1 != false);
        this.textValMetrique1.setVisible(bMetrique1 == null || bMetrique1 != false);
        JLabel labelMetrique2 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_2"));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelMetrique2, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique2, c);
        ++c.gridx;
        c.weightx = 0.0;
        Boolean bMetrique2 = Boolean.valueOf(props.getStringProperty("ArticleLargeur"));
        labelMetrique2.setVisible(bMetrique2 == null || bMetrique2 != false);
        this.textValMetrique2.setVisible(bMetrique2 == null || bMetrique2 != false);
        JLabel labelMetrique3 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_3"));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelMetrique3, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique3, c);
        ++c.gridx;
        Boolean bMetrique3 = Boolean.valueOf(props.getStringProperty("ArticlePoids"));
        labelMetrique3.setVisible(bMetrique3 == null || bMetrique3 != false);
        this.textValMetrique3.setVisible(bMetrique3 == null || bMetrique3 != false);
        JSeparator sep2 = new JSeparator();
        JLabel labelPiece = new JLabel("Article pi\u00e8ce");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelPiece, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)sep2, c);
    }

    @Override
    public void update() {
        super.update();
        this.tableTarifVente.updateField("ID_ARTICLE", this.getSelectedID());
        this.tableDes.updateField("ID_ARTICLE", this.getSelectedID());
    }

    private void selectModeVente(int id) {
        this.labelMetriqueHA1.setEnabled(true);
        this.labelMetriqueVT1.setEnabled(true);
        this.textMetrique1HA.setEnabled(true);
        this.textMetrique1VT.setEnabled(true);
        this.textPAHT.getDocument().removeDocumentListener(this.pieceHAArticle);
        this.textPVHT.getDocument().removeDocumentListener(this.pieceVTArticle);
        switch (id) {
            case 3: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au m\u00e8tre carr\u00e9");
                this.labelMetriqueVT1.setText("Prix de vente HT au m\u00e8tre carr\u00e9");
                break;
            }
            case 2: 
            case 6: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au m\u00e8tre");
                this.labelMetriqueVT1.setText("Prix de vente HT au m\u00e8tre");
                break;
            }
            case 4: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au kilo");
                this.labelMetriqueVT1.setText("Prix de vente HT au kilo");
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.labelMetriqueHA1.setEnabled(false);
                this.labelMetriqueVT1.setEnabled(false);
                this.textMetrique1HA.setEnabled(false);
                this.textMetrique1VT.setEnabled(false);
                this.textMetrique1HA.setValue(this.textPAHT.getText().trim());
                this.textMetrique1VT.setValue(this.textPVHT.getText().trim());
                this.textPAHT.getDocument().addDocumentListener(this.pieceHAArticle);
                this.textPVHT.getDocument().addDocumentListener(this.pieceVTArticle);
            }
        }
        this.tableTarifVente.fireModification();
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        this.tableTarifVente.updateField("ID_ARTICLE", id);
        this.tableDes.updateField("ID_ARTICLE", id);
        return id;
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        SQLRow row = this.getTable().getRow(this.getTable().getUndefinedID());
        rowVals.put("ID_TAXE", row.getInt("ID_TAXE"));
        rowVals.put("ID_MODE_VENTE_ARTICLE", 5);
        this.selectModeVente(5);
        rowVals.put("VALEUR_METRIQUE_1", Float.valueOf("1.0"));
        rowVals.put("PA_HT", 0L);
        rowVals.put("POIDS", Float.valueOf(0.0f));
        return rowVals;
    }

    private void setTextHT() {
        this.textPVHT.getDocument().removeDocumentListener(this.htDocListener);
        String textTTC = this.textPVTTC.getText().trim();
        PrixTTC ttc = new PrixTTC(GestionDevise.parseLongCurrency(textTTC));
        int id = this.comboSelTaxe.getSelectedId();
        if (id > 1) {
            Float resultTaux = TaxeCache.getCache().getTauxFromId(id);
            float taux = resultTaux == null ? 0.0f : resultTaux.floatValue() / 100.0f;
            this.textPVHT.setText(GestionDevise.currencyToString(ttc.calculLongHT(taux)));
        }
        this.textPVHT.getDocument().addDocumentListener(this.htDocListener);
    }

    private void setTextTTC() {
        System.out.println("setTTC");
        this.textPVTTC.getDocument().removeDocumentListener(this.ttcDocListener);
        String textHT = this.textPVHT.getText().trim();
        PrixHT ht = new PrixHT(GestionDevise.parseLongCurrency(textHT));
        int id = this.comboSelTaxe.getSelectedId();
        if (id > 1) {
            Float resultTaux = TaxeCache.getCache().getTauxFromId(id);
            float taux = resultTaux == null ? 0.0f : resultTaux.floatValue() / 100.0f;
            this.textPVTTC.setText(GestionDevise.currencyToString(ht.calculLongTTC(taux)));
        }
        this.textPVTTC.getDocument().addDocumentListener(this.ttcDocListener);
    }

    private void updatePiece() {
        if (this.comboSelModeVente.getSelectedId() > 1 && this.comboSelModeVente.getSelectedId() != 5) {
            SQLRowValues rowVals = this.getDetailsRowValues();
            float poidsTot = ReferenceArticleSQLElement.getPoidsFromDetails(rowVals);
            this.textPoids.setText(String.valueOf(poidsTot));
            this.textPAHT.setText(GestionDevise.currencyToString(ReferenceArticleSQLElement.getPrixHAFromDetails(rowVals)));
            this.textPVHT.setText(GestionDevise.currencyToString(ReferenceArticleSQLElement.getPrixVTFromDetails(rowVals)));
            this.tableTarifVente.fireModification();
        }
    }

    public int getSelectedTaxe() {
        return this.comboSelTaxe.getSelectedId();
    }

    public SQLRowValues getDetailsRowValues() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put(this.textMetrique1HA.getField().getName(), this.textMetrique1HA.getUncheckedValue());
        rowVals.put(this.textMetrique1VT.getField().getName(), this.textMetrique1VT.getUncheckedValue());
        this.put(rowVals, this.textValMetrique1);
        this.put(rowVals, this.textValMetrique2);
        this.put(rowVals, this.textValMetrique3);
        System.err.println("Unchecked value " + this.comboSelModeVente.getSelectedId());
        rowVals.put("ID_MODE_VENTE_ARTICLE", this.comboSelModeVente.getSelectedId());
        return rowVals;
    }

    private void put(SQLRowValues rowVals, JTextField comp) {
        Float f = Float.valueOf(comp.getText() == null || comp.getText().trim().length() == 0 ? 0.0f : Float.valueOf(comp.getText()).floatValue());
        rowVals.put(this.getView(comp).getField().getName(), f);
    }
}

