/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.order.component.CommandeClientSQLComponent;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.shipment.component.BonDeLivraisonSQLComponent;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.utils.CollectionMap;

public class CommandeClientSQLElement
extends ComptaSQLConfElement {
    public CommandeClientSQLElement() {
        super("COMMANDE_CLIENT", "une commande client", "commandes clients");
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("ID_COMMERCIAL");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("NOM");
        l.add("INFOS");
        return l;
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("COMMANDE_CLIENT_ELEMENT");
        return set;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("ID_DEVIS");
        return s;
    }

    @Override
    public SQLComponent createComponent() {
        return new CommandeClientSQLComponent();
    }

    public void transfertBonLivraison(int commandeID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        EditFrame editBonFrame = new EditFrame(elt);
        editBonFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        BonDeLivraisonSQLComponent comp = (BonDeLivraisonSQLComponent)editBonFrame.getSQLComponent();
        comp.loadCommande(commandeID);
        editBonFrame.pack();
        editBonFrame.setState(0);
        editBonFrame.setVisible(true);
    }

    public void transfertFacture(int commandeID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieVenteFactureSQLComponent comp = (SaisieVenteFactureSQLComponent)editFactureFrame.getSQLComponent();
        comp.loadCommande(commandeID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }

    public void transfertCommande(int commandeID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
        SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
        SQLRow rowCmd = this.getTable().getRow(commandeID);
        Collection rows = rowCmd.getReferentRows(elt.getTable());
        CollectionMap<SQLRow, List<SQLRowValues>> map = new CollectionMap<SQLRow, List<SQLRowValues>>();
        for (SQLRow sqlRow : rows) {
            SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
            for (SQLField field : eltArticle.getTable().getFields()) {
                if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
            }
            int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
            SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
            SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
            rowValsElt.put("ID_STYLE", sqlRow.getObject("ID_STYLE"));
            rowValsElt.put("QTE", sqlRow.getObject("QTE"));
            rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_HT", rowValsElt.getLong("PA_HT") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_TTC", (double)rowValsElt.getLong("T_PA_HT") * ((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0));
            map.put((Object)rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
        }
        MouvementStockSQLElement.createCommandeF(map, rowCmd.getForeignRow("ID_TARIF").getForeignRow("ID_DEVISE"));
    }
}

