/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.sales.invoice.ui.ListEcheanceClientRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSource;

public class ListPanelEcheancesClients
extends ListeAddPanel {
    private EditFrame editFrame;
    private boolean showRegCompta = false;

    public ListPanelEcheancesClients() {
        this(Configuration.getInstance().getDirectory().getElement("ECHEANCE_CLIENT"));
    }

    private ListPanelEcheancesClients(SQLElement elem) {
        super(elem, new IListe(elem.getTableSource(true)));
        this.setListe();
    }

    public JTable getJTable() {
        return this.getListe().getJTable();
    }

    public void setShowRegCompta(boolean b) {
        this.showRegCompta = b;
        this.setListe();
    }

    @Override
    protected void handleAction(JButton source, ActionEvent e) {
        if (source == this.buttonModifier) {
            if (this.editFrame == null) {
                this.editFrame = new EditFrame(this.element, EditFrame.MODIFICATION);
            }
            this.editFrame.selectionId(this.getListe().getSelectedId());
            this.editFrame.pack();
            this.editFrame.setVisible(true);
            SQLRow ecritureRow = new EcritureSQLElement().getTable().getRow(this.getListe().getSelectedId());
            MouvementSQLElement.showSource(ecritureRow.getInt("ID_MOUVEMENT"));
        } else {
            super.handleAction(source, e);
        }
    }

    private void setListe() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLTable elementEchT = ListPanelEcheancesClients.this.getListe().getSource().getPrimaryTable();
                Where wNotRegle = new Where((FieldRef)elementEchT.getField("REGLE"), "=", (Object)Boolean.FALSE);
                if (!ListPanelEcheancesClients.this.showRegCompta) {
                    wNotRegle = wNotRegle.and(new Where((FieldRef)elementEchT.getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
                }
                ListPanelEcheancesClients.this.getListe().getRequest().setWhere(wNotRegle);
                ListEcheanceClientRenderer rend = new ListEcheanceClientRenderer();
                int i = 0;
                while (i < ListPanelEcheancesClients.this.getListe().getJTable().getColumnCount()) {
                    if (ListPanelEcheancesClients.this.getListe().getJTable().getColumnClass(i) != Boolean.class) {
                        ListPanelEcheancesClients.this.getListe().getJTable().getColumnModel().getColumn(i).setCellRenderer(rend);
                    }
                    ++i;
                }
                ListPanelEcheancesClients.this.buttonAjouter.setVisible(false);
                ListPanelEcheancesClients.this.buttonEffacer.setVisible(false);
                ListPanelEcheancesClients.this.buttonModifier.setVisible(false);
                SQLTableModelSource src = ListPanelEcheancesClients.this.getListe().getSource();
                ListPanelEcheancesClients.this.getListe().setSQLEditable(true);
                for (SQLTableModelColumn column : src.getColumns()) {
                    if (!column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) continue;
                    ((SQLTableModelColumnPath)column).setEditable(false);
                }
                ((SQLTableModelColumnPath)src.getColumns(ListPanelEcheancesClients.this.getElement().getTable().getField("INFOS")).iterator().next()).setEditable(true);
            }
        });
    }

    @Override
    public SQLComponent getModifComp() {
        return null;
    }
}

