/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.generationDoc.gestcomm.EtatVentesXmlSheet;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.Tuple2;

public class EtatVentesPanel
extends JPanel
implements ActionListener {
    private JDate du;
    private JDate au;
    private JButton buttonGen = new JButton("Cr\u00e9er");
    private JButton buttonClose = new JButton("Fermer");

    public EtatVentesPanel() {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 10;
        this.add((Component)new JLabelBold("Etat des Ventes"), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.anchor = 17;
        final Map<String, Tuple2<Date, Date>> map = IListFilterDatePanel.getDefaultMap();
        if (map != null && map.keySet().size() > 0) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            model.addElement("Tous");
            for (String s : map.keySet()) {
                model.addElement(s);
            }
            final JComboBox combo = new JComboBox(model);
            c.weightx = 0.0;
            this.add(combo, c);
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = (String)combo.getSelectedItem();
                    EtatVentesPanel.this.setPeriode((Tuple2)map.get(s));
                }
            });
        }
        ++c.gridx;
        this.add((Component)new JLabel("du"), c);
        ++c.gridx;
        this.du = new JDate(true);
        this.add((Component)this.du, c);
        ++c.gridx;
        this.add((Component)new JLabel("au"), c);
        ++c.gridx;
        this.au = new JDate(true);
        this.add((Component)this.au, c);
        ++c.gridy;
        c.gridx = 0;
        JPanel panelButton = new JPanel();
        panelButton.add(this.buttonGen);
        panelButton.add(this.buttonClose);
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 0.0;
        this.add((Component)panelButton, c);
        this.buttonGen.addActionListener(this);
        this.buttonClose.addActionListener(this);
    }

    public void setPeriode(Tuple2<Date, Date> t) {
        if (t == null) {
            this.setPeriode(null, null);
        } else {
            this.setPeriode(t.get0(), t.get1());
        }
    }

    public void setDateDu(Date d) {
        d.setHours(0);
        d.setMinutes(0);
        this.du.setValue(d);
    }

    public void setDateAu(Date d) {
        d.setHours(23);
        d.setMinutes(59);
        this.au.setValue(d);
    }

    private void setPeriode(Date du, Date au) {
        this.setDateAu(au);
        this.setDateDu(du);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonGen) {
            EtatVentesXmlSheet sheet = new EtatVentesXmlSheet(this.du.getDate(), this.au.getDate());
            try {
                sheet.createDocumentAsynchronous().get();
                sheet.openDocument(false);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ((JFrame)SwingUtilities.getRoot(this)).dispose();
    }
}

