/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.reports.history.ui;

import java.awt.GridLayout;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;

public class HistoriqueClientBilanPanel
extends JPanel {
    private final JLabel labelVentesComptoir = new JLabel();
    private final JLabel labelVentesFacture = new JLabel();
    private final JLabel labelPropositions = new JLabel();
    private final JLabel labelCheques = new JLabel();
    private final JLabel labelEcheances = new JLabel();
    private final JLabel labelRelances = new JLabel();
    private final JLabel labelTotalVente = new JLabel();
    private long nbVentesCompoir;
    private long totalVentesCompoir;
    private long nbVentesFacture;
    private long totalVentesFacture;
    private long nbTotalCheques;
    private long totalCheques;
    private long nbChequesNonEncaisses;
    private long nbRelances;
    private int delaiPaiementMoyen;
    private long nbPropositions;
    private long totalPropositions;
    private long nbFacturesImpayees;
    private long totalFacturesImpayees;
    private int poucentageVentes;
    SwingWorker<String, Object> workerTotalVente;

    public HistoriqueClientBilanPanel() {
        this.setLayout(new GridLayout(4, 2));
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        if (bModeVenteComptoir.booleanValue()) {
            this.add(this.labelVentesComptoir);
        }
        this.add(this.labelVentesFacture);
        this.add(this.labelPropositions);
        this.add(this.labelCheques);
        this.add(this.labelEcheances);
        this.add(this.labelRelances);
        this.add(this.labelTotalVente);
    }

    public synchronized void updateRelance(List<Integer> listId) {
        int nb = listId.size();
        if (this.nbRelances != (long)nb) {
            this.setRelances(nb);
            this.updateLabels();
        }
    }

    public synchronized void updateTotalVente(final int idClient) {
        if (this.workerTotalVente != null && !this.workerTotalVente.isDone()) {
            this.workerTotalVente.cancel(true);
        }
        this.workerTotalVente = new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                long totalAllVC;
                SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
                SQLTable tableVF = base.getTable("SAISIE_VENTE_FACTURE");
                SQLTable tableVC = base.getTable("SAISIE_VENTE_COMPTOIR");
                SQLSelect selVF = new SQLSelect(base);
                selVF.addSelect(tableVF.getField("T_HT"), "SUM");
                if (idClient > 1) {
                    selVF.setWhere("SAISIE_VENTE_FACTURE.ID_CLIENT", "=", idClient);
                }
                String req = selVF.asString();
                Object o = base.getDataSource().executeScalar(req);
                long totalVF = o == null ? 0L : ((Number)o).longValue();
                SQLSelect selVC = new SQLSelect(base);
                selVC.addSelect(tableVC.getField("MONTANT_HT"), "SUM");
                if (idClient > 1) {
                    selVC.setWhere("SAISIE_VENTE_COMPTOIR.ID_CLIENT", "=", idClient);
                }
                String reqVC = selVC.asString();
                Object oVC = base.getDataSource().executeScalar(reqVC);
                long totalVC = oVC == null ? 0L : ((Number)oVC).longValue();
                SQLSelect selAllVF = new SQLSelect(base);
                selAllVF.addSelect(tableVF.getField("T_HT"), "SUM");
                Object o2 = base.getDataSource().executeScalar(selAllVF.asString());
                long totalAllVF = o2 == null ? 0L : ((Number)o2).longValue();
                SQLSelect selAllVC = new SQLSelect(base);
                selAllVC.addSelect(tableVC.getField("MONTANT_HT"), "SUM");
                Object oVCA = base.getDataSource().executeScalar(selAllVC.asString());
                long l = totalAllVC = oVCA == null ? 0L : ((Number)oVCA).longValue();
                if (totalAllVC + totalAllVF == 0L) {
                    HistoriqueClientBilanPanel.this.setPoucentageVentes(0);
                } else {
                    double pourCentage = (double)(totalVF + totalVC) / (double)(totalAllVC + totalAllVF) * 100.0;
                    HistoriqueClientBilanPanel.this.setPoucentageVentes((int)Math.round(pourCentage * 100.0) / 100);
                }
                return null;
            }

            @Override
            protected void done() {
                HistoriqueClientBilanPanel.this.updateLabels();
                super.done();
            }
        };
        this.workerTotalVente.execute();
    }

    public synchronized void updateEcheance(List<Integer> listId) {
        SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
        SQLTable tableEch = base.getTable("ECHEANCE_CLIENT");
        long valueTotal = 0L;
        if (listId != null) {
            Iterator<Integer> i = listId.iterator();
            while (i.hasNext()) {
                SQLRow row = tableEch.getRow(i.next());
                if (row == null) continue;
                Object montantO = row.getObject("MONTANT");
                valueTotal += Long.parseLong(montantO.toString());
            }
        }
        this.setNbFacturesImpayees(listId == null ? 0 : listId.size());
        this.setTotalFacturesImpayees(valueTotal);
        this.updateLabels();
    }

    public synchronized void updateVFData(List<Integer> listId, int idClient) {
        SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
        SQLTable tableVF = base.getTable("SAISIE_VENTE_FACTURE");
        long valueTotal = 0L;
        if (listId != null) {
            Iterator<Integer> i = listId.iterator();
            while (i.hasNext()) {
                SQLRow rowTmp = tableVF.getRow(i.next());
                if (rowTmp == null) continue;
                Object montantO = rowTmp.getObject("T_HT");
                valueTotal += new Long(montantO.toString()).longValue();
            }
        }
        HashMap mapDateFact = new HashMap();
        SQLSelect selDateFacture = new SQLSelect(base);
        SQLTable tableFacture = base.getTable("SAISIE_VENTE_FACTURE");
        SQLTable tableEncaisse = base.getTable("ENCAISSER_MONTANT");
        SQLTable tableEcheance = base.getTable("ECHEANCE_CLIENT");
        SQLTable tableMvt = base.getTable("MOUVEMENT");
        selDateFacture.addSelect(tableFacture.getField("DATE"));
        selDateFacture.addSelect(tableMvt.getField("ID_PIECE"));
        Where w = new Where((FieldRef)tableFacture.getField("ID_MOUVEMENT"), "=", tableMvt.getKey());
        if (idClient > 1) {
            w = w.and(new Where((FieldRef)tableFacture.getField("ID_CLIENT"), "=", idClient));
        }
        selDateFacture.setWhere(w);
        this.addDatesToMap(base, selDateFacture, mapDateFact);
        SQLSelect selDateFactureC = new SQLSelect(base);
        SQLTable tableComptoir = base.getTable("SAISIE_VENTE_COMPTOIR");
        selDateFactureC.addSelect(tableComptoir.getField("DATE"));
        selDateFactureC.addSelect(tableMvt.getField("ID_PIECE"));
        Where wC = new Where((FieldRef)tableComptoir.getField("ID_MOUVEMENT"), "=", tableMvt.getKey());
        if (idClient > 1) {
            wC = wC.and(new Where((FieldRef)tableComptoir.getField("ID_CLIENT"), "=", idClient));
        }
        selDateFactureC.setWhere(wC);
        this.addDatesToMap(base, selDateFactureC, mapDateFact);
        SQLSelect selDateEncaisse = new SQLSelect(base);
        selDateEncaisse.addSelect(tableEncaisse.getField("DATE"));
        selDateEncaisse.addSelect(tableMvt.getField("ID_PIECE"));
        selDateEncaisse.addSelect(tableEcheance.getField("ID"));
        Where wEncaisse = new Where((FieldRef)tableEcheance.getField("ID"), "=", tableEncaisse.getField("ID_ECHEANCE_CLIENT"));
        wEncaisse = wEncaisse.and(new Where((FieldRef)tableEcheance.getField("ID_MOUVEMENT"), "=", tableMvt.getField("ID")));
        wEncaisse = wEncaisse.and(new Where((FieldRef)tableEcheance.getArchiveField(), "=", 1));
        if (idClient > 1) {
            wEncaisse = wEncaisse.and(new Where((FieldRef)tableEcheance.getField("ID_CLIENT"), "=", idClient));
        }
        selDateEncaisse.setWhere(wEncaisse);
        selDateEncaisse.setArchivedPolicy(SQLSelect.BOTH);
        List lDateEncaisse = (List)base.getDataSource().execute(selDateEncaisse.asString(), new ArrayListHandler());
        HashMap<Object, Date> mapDateEncaisse = new HashMap<Object, Date>();
        int i = 0;
        while (i < lDateEncaisse.size()) {
            Object[] tmp = (Object[])lDateEncaisse.get(i);
            Date d2 = (Date)tmp[0];
            Object d = mapDateEncaisse.get(tmp[1]);
            if (d != null) {
                Date d1 = (Date)d;
                if (d1.before(d2)) {
                    mapDateEncaisse.put(tmp[1], d2);
                }
            } else {
                mapDateEncaisse.put(tmp[1], d2);
            }
            ++i;
        }
        int cpt = 0;
        int day = 0;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        for (Object key : mapDateFact.keySet()) {
            Date dFact = (Date)mapDateFact.get(key);
            Date dEncaisse = (Date)mapDateEncaisse.get(key);
            if (dFact == null || dEncaisse == null) continue;
            ++cpt;
            cal1.setTime(dFact);
            cal2.setTime(dEncaisse);
            cal1.set(10, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
            cal1.set(14, 0);
            cal2.set(10, 0);
            cal2.set(12, 0);
            cal2.set(13, 0);
            cal2.set(14, 0);
            day = (int)((long)day + (cal2.getTime().getTime() - cal1.getTime().getTime()) / 86400000L);
        }
        this.setPoucentageVentes(cpt == 0 ? 0 : day / cpt);
        this.setTotalVentesFacture(valueTotal);
        this.setNbVentesFacture(listId == null ? 0 : listId.size());
        this.updateLabels();
    }

    private void addDatesToMap(SQLBase base, SQLSelect selDateFacture, Map mapDateFact) {
        List lDateFact = (List)base.getDataSource().execute(selDateFacture.asString(), new ArrayListHandler());
        int size = lDateFact.size();
        int i = 0;
        while (i < size) {
            Object[] tmp = (Object[])lDateFact.get(i);
            mapDateFact.put(tmp[1], tmp[0]);
            ++i;
        }
    }

    public synchronized void updateVCData(List<Integer> listId) {
        SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
        SQLTable tableVC = base.getTable("SAISIE_VENTE_COMPTOIR");
        long valueTotal = 0L;
        if (listId != null) {
            Iterator<Integer> i = listId.iterator();
            while (i.hasNext()) {
                SQLRow rowTmp = tableVC.getRow(i.next());
                if (rowTmp == null) continue;
                Object montantO = rowTmp.getObject("MONTANT_HT");
                valueTotal += new Long(montantO.toString()).longValue();
            }
        }
        this.setNbVentesComptoir(listId == null ? 0 : listId.size());
        this.setTotalVentesComptoir(valueTotal);
        this.updateLabels();
    }

    public synchronized void updateChequeData(List<Integer> listId) {
        SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
        SQLTable tableC = base.getTable("CHEQUE_A_ENCAISSER");
        long valueTotalTmp = 0L;
        long valueNonEncaisseTmp = 0L;
        if (listId != null) {
            Iterator<Integer> i = listId.iterator();
            while (i.hasNext()) {
                SQLRow row = tableC.getRow(i.next());
                if (row == null) continue;
                Object montantO = row.getObject("MONTANT");
                valueTotalTmp += Long.parseLong(montantO.toString());
                if (row.getBoolean("ENCAISSE").booleanValue()) continue;
                ++valueNonEncaisseTmp;
            }
        }
        this.setNbTotalCheques(listId == null ? 0 : listId.size());
        this.setNbChequesNonEncaisses(valueNonEncaisseTmp);
        this.setTotalCheques(valueTotalTmp);
        this.updateLabels();
    }

    public void setNbVentesComptoir(long nb) {
        this.nbVentesCompoir = nb;
    }

    public void setTotalVentesComptoir(long totalInCents) {
        this.totalVentesCompoir = totalInCents;
    }

    public void setNbVentesFacture(long nb) {
        this.nbVentesFacture = nb;
    }

    public void setTotalVentesFacture(long totalInCents) {
        this.totalVentesFacture = totalInCents;
    }

    public void setNbTotalCheques(long nb) {
        this.nbTotalCheques = nb;
    }

    public void setTotalCheques(long totalInCents) {
        this.totalCheques = totalInCents;
    }

    public void setNbChequesNonEncaisses(long nb) {
        this.nbChequesNonEncaisses = nb;
    }

    public void setRelances(long nb) {
        this.nbRelances = nb;
    }

    public void setDelaiPaiementMoyen(int nb) {
        this.delaiPaiementMoyen = nb;
    }

    public void setNbPropositions(long nb) {
        this.nbPropositions = nb;
    }

    public void setTotalPropositions(long totalInCents) {
        this.totalPropositions = totalInCents;
    }

    public void setNbFacturesImpayees(long nb) {
        this.nbFacturesImpayees = nb;
    }

    public void setTotalFacturesImpayees(long totalInCents) {
        this.totalFacturesImpayees = totalInCents;
    }

    public void setPoucentageVentes(int pourCent) {
        this.poucentageVentes = pourCent;
    }

    private void updateLabels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalVentesCompoir, true);
                long nb = HistoriqueClientBilanPanel.this.nbVentesCompoir;
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelVentesComptoir.setText(" pas de vente comptoir");
                } else if (nb == 1L) {
                    HistoriqueClientBilanPanel.this.labelVentesComptoir.setText(" une vente comptoir d'un montant de " + total + " \u20ac HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelVentesComptoir.setText(" " + nb + " ventes comptoir d'un montant total de " + total + " \u20ac HT");
                }
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalVentesFacture, true);
                nb = HistoriqueClientBilanPanel.this.nbVentesFacture;
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelVentesFacture.setText(" pas de vente avec facture");
                } else if (nb == 1L) {
                    HistoriqueClientBilanPanel.this.labelVentesFacture.setText(" une vente avec facture d'un montant de " + total + " \u20ac HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelVentesFacture.setText(" " + nb + " ventes avec facture d'un montant total de " + total + " \u20ac HT");
                }
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalPropositions, true);
                nb = HistoriqueClientBilanPanel.this.nbPropositions;
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelPropositions.setText(" pas de proposition commerciale");
                } else if (nb == 1L) {
                    HistoriqueClientBilanPanel.this.labelPropositions.setText(" une proposition commerciale d'un montant de " + total + " \u20ac HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelPropositions.setText(" " + nb + " propositions commerciales d'un montant total de " + total + " \u20ac HT");
                }
                nb = HistoriqueClientBilanPanel.this.nbTotalCheques;
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalCheques, true);
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelCheques.setText(" pas de ch\u00e8que");
                } else if (nb == 1L) {
                    if (HistoriqueClientBilanPanel.this.nbChequesNonEncaisses == 0L) {
                        HistoriqueClientBilanPanel.this.labelCheques.setText(" un ch\u00e8que d'un montant de " + total + " \u20ac HT");
                    } else {
                        HistoriqueClientBilanPanel.this.labelCheques.setText(" un ch\u00e8que non encaiss\u00e9 d'un montant de " + total + " \u20ac HT");
                    }
                } else if (HistoriqueClientBilanPanel.this.nbChequesNonEncaisses == 0L) {
                    HistoriqueClientBilanPanel.this.labelCheques.setText(" " + nb + " ch\u00e8ques d'un montant total de " + total + " \u20ac HT");
                } else if (HistoriqueClientBilanPanel.this.nbChequesNonEncaisses == nb) {
                    HistoriqueClientBilanPanel.this.labelCheques.setText(" " + nb + " ch\u00e8ques non encaiss\u00e9s d'un montant total de " + total + " \u20ac HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelCheques.setText(" " + nb + " ch\u00e8ques non d'un montant total de " + total + " \u20ac HT dont " + HistoriqueClientBilanPanel.this.nbChequesNonEncaisses + " non encaiss\u00e9s");
                }
                nb = HistoriqueClientBilanPanel.this.nbFacturesImpayees;
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalFacturesImpayees, true);
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelEcheances.setText(" pas de facture impay\u00e9e");
                } else if (nb == 1L) {
                    HistoriqueClientBilanPanel.this.labelEcheances.setText(" une facture impay\u00e9e d'un montant de " + total + " \u20ac HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelEcheances.setText(" " + nb + " factures impay\u00e9es d'un montant total de " + total + " \u20ac HT");
                }
                nb = HistoriqueClientBilanPanel.this.nbRelances;
                String txt = nb == 0L ? " pas de relance effectu\u00e9e" : (nb == 1L ? " une relance effectu\u00e9e" : " " + nb + " relances effectu\u00e9es");
                if (nb > 0L) {
                    if (HistoriqueClientBilanPanel.this.delaiPaiementMoyen == 1) {
                        txt = String.valueOf(txt) + ", d\u00e9lai moyen de paiment d'une journ\u00e9e";
                    } else if (HistoriqueClientBilanPanel.this.delaiPaiementMoyen > 1) {
                        txt = String.valueOf(txt) + ", d\u00e9lai moyen de paiment de " + HistoriqueClientBilanPanel.this.delaiPaiementMoyen + " jours";
                    }
                }
                HistoriqueClientBilanPanel.this.labelRelances.setText(txt);
                long cents = HistoriqueClientBilanPanel.this.totalVentesCompoir + HistoriqueClientBilanPanel.this.totalVentesFacture;
                total = GestionDevise.currencyToString(cents, true);
                if (cents == 0L) {
                    HistoriqueClientBilanPanel.this.labelTotalVente.setText(" pas de vente");
                } else if (HistoriqueClientBilanPanel.this.poucentageVentes <= 0) {
                    HistoriqueClientBilanPanel.this.labelTotalVente.setText(" ventes de " + total + " \u20ac HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelTotalVente.setText(" ventes de " + total + " \u20ac HT, soit " + HistoriqueClientBilanPanel.this.poucentageVentes + "% des ventes totales");
                }
            }
        });
    }
}

