/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;

public class ListeGestCommEltPanel
extends ListeAddPanel {
    private EditFrame editModifyFrame;
    private EditFrame editReadOnlyFrame;

    private ListeGestCommEltPanel(SQLElement elem, boolean showAdd, Where w, String variant) {
        this(elem, new IListe(elem.createTableSource(w)), showAdd);
    }

    public ListeGestCommEltPanel(SQLElement elem, IListe l) {
        this(elem, l, false);
    }

    public ListeGestCommEltPanel(SQLElement elem, IListe l, boolean showAdd) {
        super(elem, l);
        this.setAddVisible(showAdd);
        this.setOpaque(false);
    }

    public ListeGestCommEltPanel(SQLElement elem, boolean showAdd) {
        this(elem, showAdd, null, null);
    }

    public ListeGestCommEltPanel(SQLElement elem) {
        this(elem, false);
    }

    public ListeGestCommEltPanel(SQLElement elem, Where w, String variant) {
        this(elem, false, w, variant);
    }

    public ListeGestCommEltPanel(SQLElement elem, Where w) {
        this(elem, false, w, null);
    }

    @Override
    protected void handleAction(JButton source, ActionEvent evt) {
        SQLRow row = this.getElement().getTable().getRow(this.getListe().getSelectedId());
        if (row != null && row.getID() > 1) {
            int idMvt = row.getInt("ID_MOUVEMENT");
            if (source == this.buttonEffacer) {
                if (idMvt > 1) {
                    PanelFrame frame = new PanelFrame(new SuppressionEcrituresPanel(idMvt), "Suppression");
                    frame.pack();
                    frame.setLocationRelativeTo(null);
                    frame.setResizable(false);
                    frame.setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            } else if (source == this.buttonModifier) {
                if (MouvementSQLElement.isEditable(idMvt)) {
                    if (this.editModifyFrame == null) {
                        this.editModifyFrame = new EditFrame(this.element, EditPanel.MODIFICATION);
                    }
                    this.editModifyFrame.selectionId(this.getListe().getSelectedId());
                    this.editModifyFrame.setVisible(true);
                } else {
                    if (this.editReadOnlyFrame == null) {
                        this.editReadOnlyFrame = new EditFrame(this.element, EditPanel.READONLY);
                    }
                    this.editReadOnlyFrame.selectionId(this.getListe().getSelectedId());
                    this.editReadOnlyFrame.setVisible(true);
                }
            } else {
                super.handleAction(source, evt);
            }
        } else {
            super.handleAction(source, evt);
        }
    }
}

