/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.GrandLivreSheet;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorCompta;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorListener;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;

public class ImpressionGrandLivrePanel
extends JPanel
implements SpreadSheetGeneratorListener {
    private final JDate dateDeb;
    private final JDate dateEnd;
    private JButton valid;
    private JButton annul;
    private JCheckBox checkImpr;
    private JCheckBox checkVisu;
    private JTextField compteDeb;
    private JTextField compteEnd;
    private int mode = GrandLivreSheet.MODEALL;
    private JProgressBar bar = new JProgressBar(0, 3);

    public ImpressionGrandLivrePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        this.dateDeb = new JDate();
        this.dateEnd = new JDate();
        c.weightx = 0.0;
        this.add((Component)new JLabel("P\u00e9riode du", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.dateDeb, c);
        String valueDateDeb = DefaultNXProps.getInstance().getStringProperty("GrandLivreDateDeb");
        if (valueDateDeb.trim().length() > 0) {
            Long l = new Long(valueDateDeb);
            this.dateDeb.setValue(new Date(l));
        } else {
            this.dateDeb.setValue((Date)rowExercice.getObject("DATE_DEB"));
        }
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("au"), c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.dateEnd, c);
        String valueDateEnd = DefaultNXProps.getInstance().getStringProperty("GrandLivreDateEnd");
        if (valueDateEnd.trim().length() > 0) {
            Long l = new Long(valueDateEnd);
            this.dateEnd.setValue(new Date(l));
        } else {
            this.dateEnd.setValue((Date)rowExercice.getObject("DATE_FIN"));
        }
        this.compteDeb = new JTextField(8);
        this.compteEnd = new JTextField(8);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Du compte", 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 0;
        JPanel pCompte = new JPanel(new FlowLayout(3, 0, 0));
        pCompte.add(this.compteDeb);
        pCompte.add(new JLabel(" au compte "));
        pCompte.add(this.compteEnd);
        this.add((Component)pCompte, c);
        c.gridx = 0;
        c.gridwidth = 4;
        ++c.gridy;
        this.add((Component)new JLabelBold("Options"), c);
        final JCheckBox boxCumulsAnts = new JCheckBox("Cumuls ant\u00e9rieurs");
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.add((Component)boxCumulsAnts, c);
        boxCumulsAnts.setSelected(true);
        final JCheckBox boxCentralClient = new JCheckBox("Centralisation comptes clients");
        c.gridx += 2;
        c.gridwidth = 2;
        this.add((Component)boxCentralClient, c);
        final JCheckBox boxCompteSolde = new JCheckBox("Inclure les comptes sold\u00e9s");
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.add((Component)boxCompteSolde, c);
        boxCompteSolde.setSelected(true);
        final JCheckBox boxCentralFourn = new JCheckBox("Centralisation comptes fournisseurs");
        c.gridx += 2;
        c.gridwidth = 2;
        this.add((Component)boxCentralFourn, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Exclure le journal", 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        final ElementComboBox comboJrnl = new ElementComboBox(true);
        comboJrnl.init(Configuration.getInstance().getDirectory().getElement("JOURNAL"));
        this.add((Component)comboJrnl, c);
        JRadioButton radioAll = new JRadioButton(new AbstractAction("Toutes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionGrandLivrePanel.this.mode = GrandLivreSheet.MODEALL;
            }
        });
        JRadioButton radioLettree = new JRadioButton(new AbstractAction("Lettr\u00e9es"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionGrandLivrePanel.this.mode = GrandLivreSheet.MODELETTREE;
            }
        });
        JRadioButton radioNonLettree = new JRadioButton(new AbstractAction("Non lettr\u00e9es"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionGrandLivrePanel.this.mode = GrandLivreSheet.MODENONLETTREE;
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 0;
        this.add((Component)new JLabelBold("Ecritures \u00e0 inclure"), c);
        JPanel panelMode = new JPanel();
        panelMode.add(radioAll);
        panelMode.add(radioLettree);
        panelMode.add(radioNonLettree);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.weighty = 0.0;
        c.fill = 0;
        ButtonGroup group = new ButtonGroup();
        group.add(radioAll);
        group.add(radioLettree);
        group.add(radioNonLettree);
        radioAll.setSelected(true);
        this.add((Component)panelMode, c);
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)new JLabelBold("Progression de la creation du grand livre"), c);
        ++c.gridy;
        this.bar.setStringPainted(true);
        this.add((Component)this.bar, c);
        this.valid = new JButton("Valider");
        this.annul = new JButton("Fermer");
        this.checkImpr = new JCheckBox("Impression");
        this.checkVisu = new JCheckBox("Visualisation");
        JPanel panelPrintView = new JPanel(new FlowLayout(3, 2, 0));
        panelPrintView.add(this.checkImpr);
        panelPrintView.add(this.checkVisu);
        this.checkImpr.setSelected(true);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.anchor = 14;
        this.add((Component)panelPrintView, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel panelOkCancel = new JPanel();
        panelOkCancel.add(this.valid);
        panelOkCancel.add(this.annul);
        this.add((Component)panelOkCancel, c);
        this.checkValidity();
        this.valid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionGrandLivrePanel.this.valid.setEnabled(false);
                ImpressionGrandLivrePanel.this.bar.setString(null);
                ImpressionGrandLivrePanel.this.bar.setValue(1);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GrandLivreSheet bSheet = new GrandLivreSheet(ImpressionGrandLivrePanel.this.dateDeb.getDate(), ImpressionGrandLivrePanel.this.dateEnd.getDate(), ImpressionGrandLivrePanel.this.compteDeb.getText().trim(), ImpressionGrandLivrePanel.this.compteEnd.getText().trim(), ImpressionGrandLivrePanel.this.mode, boxCumulsAnts.isSelected(), !boxCompteSolde.isSelected(), boxCentralClient.isSelected(), boxCentralFourn.isSelected(), comboJrnl.getSelectedId());
                        if (bSheet.getSize() == 0) {
                            JOptionPane.showMessageDialog(ImpressionGrandLivrePanel.this, "Aucune \u00e9criture trouv\u00e9e");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ImpressionGrandLivrePanel.this.taskEnd();
                                }
                            });
                        } else {
                            final SpreadSheetGeneratorCompta generator = new SpreadSheetGeneratorCompta(bSheet, "GrandLivre" + Calendar.getInstance().getTimeInMillis(), ImpressionGrandLivrePanel.this.checkImpr.isSelected(), ImpressionGrandLivrePanel.this.checkVisu.isSelected(), false);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ImpressionGrandLivrePanel.this.bar.setValue(2);
                                    generator.addGenerateListener(ImpressionGrandLivrePanel.this);
                                }
                            });
                        }
                    }
                }).start();
            }
        });
        this.annul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(ImpressionGrandLivrePanel.this)).dispose();
            }
        });
        this.dateDeb.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionGrandLivrePanel.this.checkValidity();
                ImpressionGrandLivrePanel.this.storeValue();
            }
        });
        this.dateEnd.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionGrandLivrePanel.this.checkValidity();
                ImpressionGrandLivrePanel.this.storeValue();
            }
        });
        DocumentListener d = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImpressionGrandLivrePanel.this.checkValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImpressionGrandLivrePanel.this.checkValidity();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImpressionGrandLivrePanel.this.checkValidity();
            }
        };
        this.compteDeb.getDocument().addDocumentListener(d);
        String valueCompteDeb = DefaultNXProps.getInstance().getStringProperty("GrandLivreCompteDeb");
        if (valueCompteDeb.trim().length() > 0) {
            this.compteDeb.setText(valueCompteDeb);
        } else {
            this.compteDeb.setText("1");
        }
        this.compteEnd.getDocument().addDocumentListener(d);
        String valueCompteEnd = DefaultNXProps.getInstance().getStringProperty("GrandLivreCompteEnd");
        if (valueCompteEnd.trim().length() > 0) {
            this.compteEnd.setText(valueCompteEnd);
        } else {
            this.compteEnd.setText("8");
        }
    }

    private void checkValidity() {
        Date beginDate = this.dateDeb.getDate();
        Date endDate = this.dateEnd.getDate();
        this.valid.setEnabled(true);
        if (beginDate == null || endDate == null) {
            this.valid.setEnabled(false);
        } else if (this.compteDeb.getText().trim().length() == 0 || this.compteEnd.getText().trim().length() == 0) {
            this.valid.setEnabled(false);
        } else if (this.compteDeb.getText().trim().compareToIgnoreCase(this.compteEnd.getText().trim()) > 0) {
            this.valid.setEnabled(false);
        } else if (beginDate.after(endDate)) {
            this.valid.setEnabled(false);
        }
    }

    private void storeValue() {
        Date dFin;
        Date d = this.dateDeb.getDate();
        if (d != null) {
            DefaultNXProps.getInstance().setProperty("GrandLivreDateDeb", String.valueOf(d.getTime()));
        }
        if ((dFin = this.dateEnd.getDate()) != null) {
            DefaultNXProps.getInstance().setProperty("GrandLivreDateEnd", String.valueOf(dFin.getTime()));
        }
        DefaultNXProps.getInstance().setProperty("GrandLivreCompteDeb", this.compteDeb.getText());
        DefaultNXProps.getInstance().setProperty("GrandLivreCompteEnd", this.compteEnd.getText());
        DefaultNXProps.getInstance().store();
    }

    @Override
    public void taskEnd() {
        this.bar.setValue(3);
        this.bar.setString("Termin\u00e9e");
        this.valid.setEnabled(true);
    }
}

